/*
    ettercap -- dissector IRC -- TCP 6667 6668 6669

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_irc);

// --------------------


FUNC_DISSECTOR(Dissector_irc)
{

   TCP_header *tcp;
   u_char *payload;
   short datalen;
   char collector[50];
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (data_to_ettercap->datalen == 0) return 0;       // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   memset(collector, 0, 50);
   datalen = (data_to_ettercap->datalen > 50) ? 50 : data_to_ettercap->datalen;
   memcpy(collector, payload, datalen);

   if ( !strncasecmp(collector, "OPER ", 5) )
   {
      #ifdef DEBUG
         Debug_msg("\tDissector_irc OPER");
      #endif
      strcpy(data_to_ettercap->user, strtok(collector + 5, " "));
      strcpy(data_to_ettercap->pass, collector + 5 + strlen(data_to_ettercap->user) + 1);
      strcat(data_to_ettercap->user, "\n");
      strcat(data_to_ettercap->pass, "\n");
      strcpy(data_to_ettercap->info, "OPER (request for a O-line)");
   }

   if ( !strncasecmp(collector, "MODE ", 5) )
   {
      if (strstr(collector + 5, "+k"))
      {
         #ifdef DEBUG
            Debug_msg("\tDissector_irc MODE +k");
         #endif
         strcpy(data_to_ettercap->user, strtok(collector + 5, " "));
         strcpy(data_to_ettercap->pass, collector + 5 + strlen(data_to_ettercap->user) + 2);
         strcat(data_to_ettercap->user, " (IRC channel)\n");
         strcat(data_to_ettercap->pass, "\n");
         strcpy(data_to_ettercap->info, "MODE #channel +k password (password channel)");
      }
   }

   if ( !strncasecmp(collector, "JOIN ", 5) )
   {
      int i, count = 0;

      for (i=0; i <= strlen(collector); i++) // if count == 2 there is the channel key !
         if (collector[i] == ' ') count++;

      if (count == 2)
      {
         #ifdef DEBUG
            Debug_msg("\tDissector_irc JOIN #chan pass");
         #endif
         strcpy(data_to_ettercap->user, strtok(collector + 5, " "));
         strcpy(data_to_ettercap->pass, collector + 5 + strlen(data_to_ettercap->user) + 1);
         strcat(data_to_ettercap->user, " (IRC channel)\n");
         strcat(data_to_ettercap->pass, "\n");
         strcpy(data_to_ettercap->info, "JOIN #channel password (password channel)");
      }
   }

   return 0;
}


/* EOF */
