/*
    ettercap -- dissector IMAP 4 -- TCP 143 220

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

// protos

FUNC_DISSECTOR(Dissector_imap);

// --------------------


FUNC_DISSECTOR(Dissector_imap)
{

   TCP_header *tcp;
   u_char *payload;
   char *fromhere;
   static char auth_login = 0;
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == 143 || ntohs(tcp->source) == 220) return 0;           // skip server messages...

   payload = (char *)((int)tcp + tcp->doff * 4);

   if ( (fromhere = strstr(payload, "LOGIN")) && !strstr(payload, "AUTHENTICATE") )    // plain text login
   {
      char collector[80];
      char *p;

      #ifdef DEBUG
         Debug_msg("\tDissector_IMAP LOGIN ");
      #endif

      strncpy(collector, fromhere + strlen("LOGIN ") , 80 );
      p = strtok(collector, " ");
      if (p)
      {
         snprintf(data_to_ettercap->user, 25, "%s\n", p);
         p = strtok(NULL, " ");
         if (p) snprintf(data_to_ettercap->pass, 25, "%s\n", p);
      }
   }

   switch (auth_login)
   {
      case 0: // look for authenticate type
               if ( (fromhere = strstr(payload, "AUTHENTICATE")) )
               {
                  char collector[80];

                  #ifdef DEBUG
                     Debug_msg("\tDissector_IMAP %s", payload);
                  #endif

                  strncpy(collector, fromhere + strlen("AUTHENTICATE ") , 80 );

                  if (!strncasecmp(collector, "LOGIN", 5))
                  {
                     auth_login = 1;   // wait for the next packet in which there will be the login (base64)
                  }
                  else if (!strncasecmp(collector, "SKEY", 5))
                  {
                     auth_login = 3;   // wait for the next packet in which there will be the login (base64)
                  }
                  else
                  {
                     snprintf(data_to_ettercap->user, 25, "\n");
                     snprintf(data_to_ettercap->pass, 25, "\n");
                     snprintf(data_to_ettercap->info, 80, "Authenticated with %s\n", collector);
                  }
               }
               break;
      case 1: // waiting for user
               {
                  char collector[strlen(payload)];
                  #ifdef DEBUG
                     Debug_msg("\tDissector_IMAP AUTH LOGIN USER");
                  #endif
                  Dissector_base64decode(collector, payload);
                  snprintf(data_to_ettercap->user, 25, "%s\n", collector);
                  auth_login = 2;
               }
               break;
      case 2: // waiting for pass
               {
                  char collector[strlen(payload)];
                  #ifdef DEBUG
                     Debug_msg("\tDissector_IMAP AUTH LOGIN PASS");
                  #endif
                  Dissector_base64decode(collector, payload);
                  snprintf(data_to_ettercap->pass, 25, "%s\n", collector);
                  snprintf(data_to_ettercap->info, 80, "Authenticated LOGIN\n");
                  auth_login = 0;
               }
               break;
      case 3: // auth SKEY we can know only the login... the pass is One-Timed... argh!!
               {
                  char collector[strlen(payload)];
                  #ifdef DEBUG
                     Debug_msg("\tDissector_IMAP AUTH SKEY USER");
                  #endif
                  Dissector_base64decode(collector, payload);
                  snprintf(data_to_ettercap->user, 25, "%s\n", collector);
                  snprintf(data_to_ettercap->pass, 25, "\n");
                  snprintf(data_to_ettercap->info, 80, "Authenticated with %s\n", collector);
                  auth_login = 0;
               }
               break;
   }

   return 0;
}


/* EOF */
