/*
    ettercap -- dissector SMB (Server Message Block)

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif

typedef struct {
   u_char  proto[4];
   u_char  cmd;
   u_char  err[4];
   u_char  flags1;
   u_short flags2;
   u_short pad[6];
   u_short tid, pid, uid, mid;
} SMB_header;

typedef struct {
   u_char  mesg;
   u_char  flags;
   u_short len;
} NetBIOS_header;

// protos

FUNC_DISSECTOR(Dissector_smb);

// --------------------


FUNC_DISSECTOR(Dissector_smb)
{

   TCP_header *tcp;
   u_char *payload;
   SMB_header *smb;
   NetBIOS_header *NetBIOS;
   u_char *ptr;
   
   ONLY_CONNECTION;
   
   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == 139) return 0;            // skip server messages...

   payload = (char *)((int)tcp + tcp->doff * 4);
   NetBIOS = (NetBIOS_header *)payload;
   smb = (SMB_header *)(NetBIOS + 1);

   if (memcmp(smb->proto, "\xffSMB", 4) != 0 || smb->cmd != 0x73) return 0;  // it isn't SMBsesssetupX

   ptr = (u_char *)(smb + 1);

   if ( *ptr == 13 )
   {
      short pwlen, unilen;
      char pass[25];
      char *user;
      char *domain;

      ptr += 15;
      pwlen = ptohs(ptr);        // ANSI password len
      ptr += 2;
      unilen = ptohs(ptr);       // UNICODE password len

      #ifdef DEBUG
         Debug_msg("\tDissector_SMB NT LM 0.12 LEN [%d]-[%d]", pwlen, unilen);
      #endif

      if (pwlen > 0)
      {
         strncpy(pass, ptr + 12, 25);
         strcat(data_to_ettercap->pass, pass);
         strcat(data_to_ettercap->pass, "\n");  // don't forget it !!   datadecode needs it !!
      }

     	user = ptr + 12 + pwlen + unilen;
      snprintf(data_to_ettercap->user, 25, "%s\n", user);

		domain = user + strlen(user)+1;

		snprintf(data_to_ettercap->info, 100, "DOMAIN: %s  OS: %s\n", domain, domain+strlen(domain)+1);

      #ifdef DEBUG
         Debug_msg("\tDissector_SMB NT LM 0.12 USER & PASS");
      #endif
   }
   else if ( *ptr == 10 )
   {
      int pwlen;
      char pass[25];
      char *user;
      char *domain;

      ptr += 15;
      pwlen = ptohs(ptr);     // ANSI password len
      ptr += 2;

      if (pwlen > 0)
      {
         strncpy(pass, ptr + 6, 25);
         strcat(data_to_ettercap->pass, pass);
         strcat(data_to_ettercap->pass, "\n");  // don't forget it !!   datadecode needs it !!
      }

     	user = ptr + 6 + pwlen;
      snprintf(data_to_ettercap->user, 25, "%s\n", user);

		domain = user + strlen(user)+1;

		snprintf(data_to_ettercap->info, 100, "DOMAIN: %s  OS: %s\n", domain, domain+strlen(domain)+1);

      #ifdef DEBUG
         Debug_msg("\tDissector_SMB pre NT LM 0.12 USER & PASS");
      #endif
   }

   return 0;
}


/* EOF */
