/*
    ettercap -- the protocol dissector

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "include/ec_main.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"
#include "include/ec_decodedata.h"
#include "include/ec_error.h"

#ifdef DEBUG
   #include "include/ec_debug.h"
#endif


typedef struct {
   char mode;
   short proto;
   short port;
   int (*dissector)(u_char *, void *, int);
} DISSECTOR;

#define ALL_P -1


static DISSECTOR Available_Dissectors[] = {

   {MACBASED,  IPPROTO_TCP,    21, &Dissector_ftp},
#ifdef HAVE_OPENSSL
   {ARPBASED,  IPPROTO_TCP,    22, &Dissector_ssh},
#endif
   {MACBASED,  IPPROTO_TCP,    23, &Dissector_telnet},
   {MACBASED,  IPPROTO_TCP,    80, &Dissector_http},
   {MACBASED,  IPPROTO_TCP,   110, &Dissector_pop},
   {MACBASED,  IPPROTO_TCP,   139, &Dissector_smb},
   {MACBASED,  IPPROTO_TCP,   513, &Dissector_rlogin},
   {MACBASED,  IPPROTO_TCP,  3306, &Dissector_mysql},
   {MACBASED,  IPPROTO_UDP,  4000, &Dissector_icq},
   //{MACBASED,  IPPROTO_TCP,  6666, &Dissector_irc}, // TODO
   //{MACBASED,  IPPROTO_TCP,  6667, &Dissector_irc},
   //{MACBASED,  IPPROTO_TCP,  6668, &Dissector_irc},
   //{MACBASED,  IPPROTO_TCP,  6669, &Dissector_irc},
   {MACBASED,  IPPROTO_UDP, ALL_P, &Dissector_icq},   // ICQv5 uses different server port

                                          };

// protos....

void Dissector_Connections( char mode, short proto, u_char *data, void *data_to_ettercap, int Conn_Mode  );

// -------------------------------------


void Dissector_Connections( char mode, short proto, u_char *data, void *data_to_ettercap, int Conn_Mode )
{

   TCP_header *tcp;
   UDP_header *udp;
   DISSECTOR *ds;

   switch(proto)
   {
      case IPPROTO_TCP:
                        tcp = (TCP_header *) data;

                        for( ds = Available_Dissectors; ds->port != 0; ds++)
                        {
                           if ( ds->proto == IPPROTO_TCP && mode <= ds->mode && (ds->port == ALL_P || ntohs(tcp->source) == ds->port || ntohs(tcp->dest) == ds->port) )
                           {
                              if (ds->mode == ARPBASED)
                              {
                                 if (active_dissector)      // activated by user in iterface_sniff
                                    ds->dissector(data, data_to_ettercap, Conn_Mode);
                              }
                              else
                                 ds->dissector(data, data_to_ettercap, Conn_Mode);

                              break;
                           }
                        }
                        break;
      case IPPROTO_UDP:
                        udp = (UDP_header *) data;

                        for( ds = Available_Dissectors; ds->port != 0; ds++)
                        {
                           if ( ds->proto == IPPROTO_UDP && mode <= ds->mode && (ds->port == ALL_P || ntohs(udp->source) == ds->port || ntohs(udp->dest) == ds->port) )
                           {
                              if (ds->mode == ARPBASED)
                              {
                                 if (active_dissector)      // activated by user in iterface_sniff
                                    ds->dissector(data, data_to_ettercap, Conn_Mode);
                              }
                              else
                                 ds->dissector(data, data_to_ettercap, Conn_Mode);

                              break;
                           }
                        }
                        break;
   }
}

/* EOF */
