/* plugin_table.h
 * Table of exported addresses for Ethereal plugins.
 *
 * $Id: plugin_table.h,v 1.67 2003/07/18 03:01:35 guy Exp $
 *
 * Ethereal - Network traffic analyzer
 * Copyright 2000 by Gilbert Ramirez <gram@alumni.rice.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef PLUGIN_TABLE_H
#define PLUGIN_TABLE_H

#ifdef PLUGINS_NEED_ADDRESS_TABLE

/* Some OSes (Win32) have DLLs that cannot reference symbols in the parent
   executable, so the executable needs to provide a collection of pointers
   to those functions for the DLL plugin to use. */

/* Typedefs to make our plugin_address_table_t struct look prettier */

/* file generated by plugin_gen.py */
#include "Xplugin_table.h"

typedef guint8* (*addr_tvb_get_string)(tvbuff_t*, gint, gint);
typedef guint8* (*addr_tvb_get_stringz)(tvbuff_t*, gint, gint*);

typedef struct  {

#include "plugin_api_decls.h"

} plugin_address_table_t;

#else /* ! PLUGINS_NEED_ADDRESS_TABLE */

typedef void	plugin_address_table_t;

#endif /* PLUGINS_NEED_ADDRESS_TABLE */

#endif /* PLUGIN_TABLE_H */
