#! /usr/bin/python
# -*- python -*-
#
# $Id: plugin_gen.py,v 1.3 2003/08/23 07:34:31 guy Exp $
#
# mmelchior@xs4all.nl
#
# generate files for the windows plugin interface from a file with declarations
#
# The input for this script is generated by gcc using the following command:
#
# gcc -aux-info xyzzy $(pkg-config --cflags glib-2.0) -I ethereal-0.9.13 -c plugin_api_list.c
#
#   this gives one declaration per line, with consistent spacing.
#
#   with a much more elaborate parser than the one RE we have now, we could do without gcc.
#

"""Ethereal Windows interface generator."""

import sys, string, os, re
from string import strip, replace

pattFile = re.compile('.*plugin_api_list.* extern (.*)') # match filename and select declaration
pattName = re.compile('\w* .*?(\w*) \(.*') 		 # select function name

if len(sys.argv) > 1:
    file = open(sys.argv[1], 'r')       # input name on command line
else:
    file = sys.stdin			# read from a stream
    
f2 = open("Xplugin_api.h", 'w')		# defines to hide indirection
f3 = open("Xplugin_api.c", 'w')		# statements to copy addresses from structure
f4 = open("Xplugin_api_decls.h", 'w')	# pointer definitions
f5 = open("Xplugin_table.h", 'w')	# type definitions
f6 = open("Xass-list", 'w');		# exported structure initialization

comment = "/* This file is generated by %s, do not edit. */\n\n" % sys.argv[0]
f2.write(comment)
f3.write(comment)
f4.write(comment)
f5.write(comment)
f6.write(comment)

pos = 0
count = 0
while 1:
    line = file.readline()
    if not line: break
    matchobj = pattFile.match(line)
    if matchobj:
        # print "+", count, " ", strip(line)
        decl = matchobj.group(1)
        # print "=      ", decl
        matchobj = pattName.match(decl)
        if matchobj:
            count = count + 1
            name = matchobj.group(1)
            # print "       ", name
            f2.write("#define %s (*p_%s)\n" % (name, name))
            f3.write("p_%s = pat->p_%s;\n" % (name, name))
            f4.write("addr_%s p_%s;\n" % (name, name))
            f5.write(replace("typedef %s\n" % decl, name, "(*addr_%s)" % name))
            f6.write(name)
            pos = pos + len(name) + 2
            if pos > 60:
                pos = 0
                f6.write(",\n")
            else:
                f6.write(", ")
        else:
            print '**** function name not fount in "%s"' % decl
            
f6.write('\n')

print "%d symbols exported" % count

file.close()
f2.close()
f3.close()
f4.close()
f5.close()
f6.close()
