/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "ei.h"

/* this is our lamport clock */
extern erlang_trace *ei_trace(int query, erlang_trace *token)
{
  static erlang_trace save_token;
  static int tracing = 0;
  static int clock = 0;

  
  switch (query) {
  case -1: /* we are no longer tracing */
    tracing = 0;
    break;
    
  case 0: /* are we tracing? */
    if (tracing) {
      clock++;
      save_token.prev = save_token.serial++;
      return &save_token;
    }
    break;
    
  case 1: /* we are now tracing */
    tracing = 1;
    save_token = *token;
    if (save_token.serial > clock) 
      save_token.prev = clock = token->serial;
    break;
  }

  return NULL;
}

