/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * Copyright (c) 1985, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)gethostnamadr.c	6.39 (Berkeley) 1/4/90";
#endif /* LIBC_SCCS and not lint */

#include "resolver.h"
#include <ctype.h>
#include <errno.h>

char *strpbrk();
static struct hostent *_gethtbyname(), *_gethtbyaddr();


#if PACKETSZ > 1024
#define	MAXPACKET	PACKETSZ
#else
#define	MAXPACKET	1024
#endif

typedef union {
    HEADER hdr;
    u_char buf[MAXPACKET];
} querybuf;

typedef union {
    long al;
    char ac;
} align;


extern errno;

static struct hostent *
getanswer(answer, anslen, iquery)
	querybuf *answer;
	int anslen;
	int iquery;
{
	register HEADER *hp;
	register u_char *cp;
	register int n;
	u_char *eom;
	char *bp, **ap;
	int type, class, buflen, ancount, qdcount;
	int haveanswer, getclass = C_ANY;
	char **hap;

	eom = answer->buf + anslen;
	/*
	 * find first satisfactory answer
	 */
	hp = &answer->hdr;
	ancount = ntohs(hp->ancount);
	qdcount = ntohs(hp->qdcount);
	bp = _resolv_data->hostbuf;
	buflen = sizeof(_resolv_data->hostbuf);
	cp = answer->buf + sizeof(HEADER);
	if (qdcount) {
		if (iquery) {
			if ((n = dn_expand((char *)answer->buf, eom,
			     cp, bp, buflen)) < 0) {
				_resolv_data->h_errno = NO_RECOVERY;
				return ((struct hostent *) NULL);
			}
			cp += n + QFIXEDSZ;
			_resolv_data->host.h_name = bp;
			n = strlen(bp) + 1;
			bp += n;
			buflen -= n;
		} else
			cp += dn_skipname(cp, eom) + QFIXEDSZ;
		while (--qdcount > 0)
			cp += dn_skipname(cp, eom) + QFIXEDSZ;
	} else if (iquery) {
		if (hp->aa)
			_resolv_data->h_errno = HOST_NOT_FOUND;
		else
			_resolv_data->h_errno = TRY_AGAIN;
		return ((struct hostent *) NULL);
	}
	ap = _resolv_data->host_aliases;
	*ap = NULL;
	_resolv_data->host.h_aliases = _resolv_data->host_aliases;
	hap = _resolv_data->h_addr_ptrs;
	*hap = NULL;
#if BSD >= 43 || defined(h_addr)	/* new-style hostent structure */
	_resolv_data->host.h_addr_list = _resolv_data->h_addr_ptrs;
#endif
	haveanswer = 0;
	while (--ancount >= 0 && cp < eom) {
		if ((n = dn_expand((char *)answer->buf, eom, cp, bp, buflen)) < 0)
			break;
		cp += n;
		type = _getshort(cp);
 		cp += sizeof(u_short);
		class = _getshort(cp);
 		cp += sizeof(u_short) + sizeof(u_long);
		n = _getshort(cp);
		cp += sizeof(u_short);
		if (type == T_CNAME) {
			cp += n;
			if (ap >= &_resolv_data->host_aliases[MAXALIASES-1])
				continue;
			*ap++ = bp;
			n = strlen(bp) + 1;
			bp += n;
			buflen -= n;
			continue;
		}
		if (iquery && type == T_PTR) {
			if ((n = dn_expand((char *)answer->buf, eom,
			    cp, bp, buflen)) < 0) {
				cp += n;
				continue;
			}
			cp += n;
			_resolv_data->host.h_name = bp;
			return(&_resolv_data->host);
		}
		if (iquery || type != T_A)  {
#ifdef DEBUG
			if (_resolv_data->_res.options & RES_DEBUG)
				printf("unexpected answer type %d, size %d\n",
					type, n);
#endif
			cp += n;
			continue;
		}
		if (haveanswer) {
			if (n != _resolv_data->host.h_length) {
				cp += n;
				continue;
			}
			if (class != getclass) {
				cp += n;
				continue;
			}
		} else {
			_resolv_data->host.h_length = n;
			getclass = class;
			_resolv_data->host.h_addrtype = (class == C_IN) ? AF_INET : AF_UNSPEC;
			if (!iquery) {
				_resolv_data->host.h_name = bp;
				bp += strlen(bp) + 1;
			}
		}

		bp += sizeof(align) - ((u_long)bp % sizeof(align));

		if (bp + n >= &_resolv_data->hostbuf[sizeof(_resolv_data->hostbuf)]) {
#ifdef DEBUG
			if (_resolv_data->_res.options & RES_DEBUG)
				printf("size (%d) too big\n", n);
#endif
			break;
		}
		bcopy(cp, *hap++ = bp, n);
		bp +=n;
		cp += n;
		haveanswer++;
	}
	if (haveanswer) {
		*ap = NULL;
#if BSD >= 43 || defined(h_addr)	/* new-style hostent structure */
		*hap = NULL;
#else
		_resolv_data->host.h_addr = _resolv_data->h_addr_ptrs[0];
#endif
		return (&_resolv_data->host);
	} else {
		_resolv_data->h_errno = TRY_AGAIN;
		return ((struct hostent *) NULL);
	}
}

struct hostent *
gethostbyname(name)
	char *name;
{
	querybuf buf;
	register char *cp;
	int n;

	/*
	 * disallow names consisting only of digits/dots, unless
	 * they end in a dot.
	 */
	if (isdigit(name[0]))
		for (cp = name;; ++cp) {
			if (!*cp) {
				if (*--cp == '.')
					break;
				/*
				 * All-numeric, no dot at the end.
				 * Fake up a hostent as if we'd actually
				 * done a lookup.  What if someone types
				 * 255.255.255.255?  The test below will
				 * succeed spuriously... ???
				 */
				if ((_resolv_data->host_addr.s_addr = inet_addr(name)) == -1) {
					_resolv_data->h_errno = HOST_NOT_FOUND;
					return((struct hostent *) NULL);
				}
				_resolv_data->host.h_name = name;
				_resolv_data->host.h_aliases = _resolv_data->host_aliases;
				_resolv_data->host_aliases[0] = NULL;
				_resolv_data->host.h_addrtype = AF_INET;
				_resolv_data->host.h_length = sizeof(u_long);
				_resolv_data->h_addr_ptrs[0] = (char *)&_resolv_data->host_addr;
				_resolv_data->h_addr_ptrs[1] = (char *)0;
#if BSD >= 43 || defined(h_addr)	/* new-style hostent structure */
				_resolv_data->host.h_addr_list = _resolv_data->h_addr_ptrs;
#else
				_resolv_data->host.h_addr = _resolv_data->h_addr_ptrs[0];
#endif
				return (&_resolv_data->host);
			}
			if (!isdigit(*cp) && *cp != '.') 
				break;
		}

	if ((n = res_search(name, C_IN, T_A, buf.buf, sizeof(buf))) < 0) {
#ifdef DEBUG
		if (_resolv_data->_res.options & RES_DEBUG)
			printf("res_search failed\n");
#endif
		if (errno == ECONNREFUSED)
			return (_gethtbyname(name));
		else
			return ((struct hostent *) NULL);
	}
	return (getanswer(&buf, n, 0));
}

struct hostent *
gethostbyaddr(addr, len, type)
	char *addr;
	int len, type;
{
	int n;
	querybuf buf;
	register struct hostent *hp;
	char qbuf[MAXDNAME];
	
	if (type != AF_INET)
		return ((struct hostent *) NULL);
	(void)sprintf(qbuf, "%u.%u.%u.%u.in-addr.arpa",
		((unsigned)addr[3] & 0xff),
		((unsigned)addr[2] & 0xff),
		((unsigned)addr[1] & 0xff),
		((unsigned)addr[0] & 0xff));
	n = res_query(qbuf, C_IN, T_PTR, (char *)&buf, sizeof(buf));
	if (n < 0) {
#ifdef DEBUG
		if (_resolv_data->_res.options & RES_DEBUG)
			printf("res_query failed\n");
#endif
		if (errno == ECONNREFUSED)
			return (_gethtbyaddr(addr, len, type));
		return ((struct hostent *) NULL);
	}
	hp = getanswer(&buf, n, 1);
	if (hp == NULL)
		return ((struct hostent *) NULL);
	hp->h_addrtype = type;
	hp->h_length = len;
	_resolv_data->h_addr_ptrs[0] = (char *)&_resolv_data->host_addr;
	_resolv_data->h_addr_ptrs[1] = (char *)0;
	_resolv_data->host_addr = *(struct in_addr *)addr;
#if BSD < 43 && !defined(h_addr)	/* new-style hostent structure */
	hp->h_addr = _resolv_data->h_addr_ptrs[0];
#endif
	return(hp);
}


/* Fallback to VxWorks' hostLib functions if there is no nameserver */

static struct hostent *
_gethtent(addr, name)
	int addr;
	char *name;
{
	int len, buflen = sizeof(_resolv_data->hostbuf);

	if (buflen <= MAXHOSTNAMELEN)
		return(NULL);
	if (hostGetByAddr(addr, _resolv_data->hostbuf) == ERROR)
		return(NULL);
	if (name != NULL) {	/* possible alias */
		len = strlen(_resolv_data->hostbuf);
		/* forget about alias if no room */
		if (len + strlen(name) + 2 < buflen &&
		    strcmp(name, _resolv_data->hostbuf) != 0) {
			/* 'name' was an alias */
			_resolv_data->host_aliases[0] =
				_resolv_data->hostbuf + len + 1;
			strcpy(_resolv_data->host_aliases[0], name);
			_resolv_data->host_aliases[1] = NULL;
		} else {
			_resolv_data->host_aliases[0] = NULL;
		}
	}
	_resolv_data->host_addr.s_addr = (u_long)addr;
	_resolv_data->h_addr_ptrs[0] = (char *)&_resolv_data->host_addr;
        _resolv_data->h_addr_ptrs[1] = NULL;
#if BSD >= 43 || defined(h_addr)        /* new-style hostent structure */
        _resolv_data->host.h_addr_list = _resolv_data->h_addr_ptrs;
#else
        _resolv_data->host.h_addr = _resolv_data->h_addr_ptrs[0];
#endif
        _resolv_data->host.h_length = sizeof(u_long);
        _resolv_data->host.h_addrtype = AF_INET;
        _resolv_data->host.h_name = _resolv_data->hostbuf;
        _resolv_data->host.h_aliases = _resolv_data->host_aliases;
        return(&_resolv_data->host);
}

/* hostGetByName has some semantic deficiencies:
   - it isn't case-insensitive, and there is no function to iterate through
     the table, thus our lookup will necessarily be case-sensitive
   - it doesn't tell you if the name you looked up was an alias - we try to
     find out by doing hostGetByAddr on the address (in _gethtent() above).
*/
static struct hostent *
_gethtbyname(name)
	char *name;
{
	int addr;

	if ((addr = hostGetByName(name)) == ERROR)
		return(NULL);
	return(_gethtent(addr, name));
}

static struct hostent *
_gethtbyaddr(addr, len, type)
	char *addr;
	int len, type;
{
	int intaddr;
	struct hostent *p;

	if (len != sizeof(int))
		return(NULL);
	memcpy((char*)&intaddr, addr, len);
	if ((p = _gethtent(intaddr, (char *)NULL)) == NULL)
		return(NULL);
	if (p->h_addrtype != type)
		return(NULL);
	return (p);
}
