/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <stdlib.h>
#include <string.h>
#include "eihash.h"
#include "eireg.h"

extern ei_reg_obj *ei_reg_make(ei_reg *reg, int attr);

extern int ei_reg_setsval(ei_reg *reg, const char *key, const char *s)
{
  ei_hash *tab;
  ei_reg_obj *obj=NULL;
  int len = 0;

  
  if (!key || !reg) return -1; /* return EI_BADARG; */
  tab = reg->tab;
  if (s) len = strlen(s) +1;

  if ((obj=ei_hash_lookup(tab,key))) {
    /* object with same name already exists */
    switch (ei_reg_typeof(obj)) {
    case EI_INT:
      break;
    case EI_FLT:
      break;
    case EI_STR:
      if (obj->size > 0) free(obj->val.s);
      break;
    case EI_BIN:
      if (obj->size > 0) free(obj->val.p);
      break;
    default:
      return -1;
      /* return EI_UNKNOWN; */
    }
  }
  else {
    /* object is new */
    if (!(obj=ei_reg_make(reg,EI_STR))) return -1; /* return EI_NOMEM; */
    ei_hash_insert(tab,key,obj);
  }
  
  obj->attr = EI_STR | EI_DIRTY;
  obj->val.s=(char *)s;
  obj->size = len;

  return 0;
}
