/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <stdlib.h>
#include <string.h>
#include "erl_interface.h"
#include "ei.h"

#ifndef SMALLBUF
#define SMALLBUF 2048
#endif

/* return the ETERM pid corresponding to name. If caller
 * provides non-NULL node, nodename will be returned there
 */
/* global:whereis_name(name) -> pid */

extern ETERM *erl_global_whereis(int fd, const char *name, char *node)
{
  char buf[SMALLBUF];
  char tmpbuf[64];
  int index = 0;
  erlang_pid *self = erl_self();
  erlang_pid epid;
  ETERM *opid;
  erlang_msg msg;
  int i;
  int version,arity;

  self->num = fd;

  ei_encode_version(buf,&index);
  ei_encode_tuple_header(buf,&index,2);
  ei_encode_pid(buf,&index,self);               /* PidFrom */
  ei_encode_tuple_header(buf,&index,5);
  ei_encode_atom(buf,&index,"call");            /* call */
  ei_encode_atom(buf,&index,"global");          /* Mod */
  ei_encode_atom(buf,&index,"whereis_name");    /* Fun */
  ei_encode_list_header(buf,&index,1);          /* Args: [ name ] */
  ei_encode_atom(buf,&index,name);
  ei_encode_empty_list(buf,&index);
  ei_encode_atom(buf,&index,"user");            /* user */

  /* make the rpc call */
  if (ei_send_reg_encoded(fd,self,"rex",buf,index)) return NULL;

  while (1) {
    index = SMALLBUF;
    if (!(i = ei_receive_encoded(fd,buf,&index,&msg))) continue;
    else break;
  }

  if (i != ERL_SEND) return NULL;
    
  /* expecting { rex, pid } */
  index = 0;
  if (ei_decode_version(buf,&index,&version) 
      || ei_decode_tuple_header(buf,&index,&arity) 
      || (arity != 2) 
      || ei_decode_atom(buf,&index,tmpbuf) 
      || strcmp(tmpbuf,"rex")
      || ei_decode_pid(buf,&index,&epid))
    return NULL; /* bad response from other side */

  /* put the pid into a format for the caller */
  index = 0;
  ei_encode_pid(buf,&index,&epid);
  opid = erl_decode(buf);

  /* extract the nodename for the caller */
  if (node) strcpy(node,epid.node);

  return opid;
}
