/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * hooks to solaris threads functions 
 * this file will be linked if erl_init_sthreads() is called
 * see erl_init() in erl_locking.h
 */

#if !defined(VXWORKS) && !defined(__WIN32__)
#if defined (HAVE_THREAD_H) /* solaris */

#include <thread.h>
#include <synch.h>
#include <stdlib.h>

#ifdef DEBUG 
#include <stdio.h>
#endif 

extern int erl_locking_init_done;
extern void erl_common_init(void *, long);
int erl_init_sthreads(void *x, long y)
{
#ifdef DEBUG
  fprintf(stderr,"erl_interface using Solaris threads\n");
#endif
  erl_common_init(x,y);
  return 0; /*success */
}

mutex_t *erl_m_create(void)  
{ 
  mutex_t *l;

#ifdef DEBUG
  fprintf(stderr,"Solaris threads create\n");
#endif

  if (!erl_locking_init_done) return 0;

  if ((l = malloc(sizeof(*l)))) {
    mutex_init(l,USYNC_PROCESS,NULL);
  }

  return l;
}

int erl_m_destroy(mutex_t *l) 
{ 
  int r;
  if (!erl_locking_init_done) return 0;
  r = mutex_destroy(l);
  free(l);
  
  return r;
}

int erl_m_lock(mutex_t *l)    
{ 
  if (!erl_locking_init_done) return 0;
  return mutex_lock(l);
}

int erl_m_trylock(mutex_t *l) 
{ 
  if (!erl_locking_init_done) return 0;
  return mutex_trylock(l);
}

int erl_m_unlock(void *l)  
{ 
  if (!erl_locking_init_done) return 0;
  return mutex_unlock(l);
} 

#endif /* THREAD_H */
#endif /* !VXWORKS && !__WIN32__ */

