/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include <string.h>

#include "ei.h"
#include "putget.h"

int ei_decode_ref(const char *buf, int *index, erlang_ref *p)
{
  const char *s = buf + *index;
  const char *s0 = s;
  int len;
  
  if (get8(s) != ERL_REFERENCE_EXT) return -1;

  /* first the nodename */
  if (get8(s) != ERL_ATOM_EXT) return -1;

  len = get16be(s);

  if (p) {
    memmove(p->node, s, len);
    p->node[len] = (char)0;
  }
  s += len;
  
  /* now the numbers: num (4), creation (1) */
  if (p) {
    p->id = get32be(s);
    p->creation = get8(s) & 0x03;
  }
  else s += 5;
  
  *index += s-s0;
  
  return 0;
}
