/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * This file handles differences between operating systems.
 * This should be the only place with conditional compilation
 * depending on the type of OS.
 */

#ifndef _ERL_WIN_SYS_H
#define _ERL_WIN_SYS_H

#define HAS_STDARG

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <process.h>
#include <malloc.h>
#include <direct.h>
#include <errno.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <sys/timeb.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN

#ifdef PURIFY
#  include "pure.h"
#  define purify_is_running PurifyIsRunning
#  define purify_printf PurifyPrintf
#  define purify_new_leaks PurifyNewLeaks
#  define purify_new_fds_inuse PurifyNewHandlesInuse
#  define purify_set_pool_id 
#endif

/*
 * Define MAXPATHLEN in terms of MAXPATH if available.
 */

#ifndef MAXPATH
#define MAXPATH MAX_PATH
#endif /* MAXPATH */

#ifndef MAXPATHLEN
#define MAXPATHLEN MAXPATH
#endif /* MAXPATHLEN */

/*
 * Various configuration options, used to be in the Makefile.
 */

#define asinh undef_math_func_1
#define acosh undef_math_func_1
#define atanh undef_math_func_1
#define erf   undef_math_func_1
#define erfc  undef_math_func_1
#define lgamma undef_math_func_1

#define	ELIB_HEAP_SBRK
#define ELIB_ALLOC_IS_CLIB
#define NO_SYSLOG
#define NO_SYSCONF
#define NO_DAEMON
#define NO_PWD
#define HAVE_MEMMOVE


/*
 * Assume ANSI compiler when compiling BEAM.
 */

#define BEAM_ANSI

/*
 * Practial Windows specific macros.
 */

#define CreateAutoEvent(state) CreateEvent(NULL, FALSE, state, NULL)
#define CreateManualEvent(state) CreateEvent(NULL, TRUE, state, NULL)

/*
 * API to console window.
 */

void ConInit(void);
int ConPutChar(int c);
void ConPrintf(char *format, ...);
void ConVprintf(char *format, va_list va);
void ConSetCursor(int from, int to);
void ConSetCtrlHandler(BOOL (WINAPI *handler)(DWORD CtrlType));
int ConGetKey(void);
void ConBeep(void);
int ConReadInput(unsigned char *data, int n);


#endif
