/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef __SYS_H__
#define __SYS_H__

/* xxxP __VXWORKS__ */

#if defined (__WIN32__)
#  include "erl_win_sys.h"
#elif defined (VXWORKS) 
#  include "erl_vxworks_sys.h"
#else 
#  include "erl_unix_sys.h"
#endif

#ifdef DEBUG
#define ASSERT(e) \
  if (e) { \
     ; \
  } else { \
     erl_assert_error(#e, __FILE__, __LINE__); \
  }
void erl_assert_error(char* expr, char* file, int line);
#else
#define ASSERT(e)
#endif

/*
 * Microsoft C/C++: We certainly want to use stdarg.h and prototypes.
 * But MSC doesn't define __STDC__, unless we compile with the -Za
 * flag (strict ANSI C, no Microsoft extension).  Compiling with -Za
 * doesn't work: some Microsoft headers fail to compile...
 *
 * Solution: Test if __STDC__ or _MSC_VER is defined.
 *
 * Note: Simply defining __STDC__ doesn't work, as some Microsoft
 * headers will fail to compile!
 */

#if defined(__STDC__) || defined(_MSC_VER)
#include <stdarg.h>
#define VA_START(x, y) va_start(x, y)
#else
#include <varargs.h>
#define VA_START(x, y) va_start(x)
#endif

#if defined(__STDC__) || defined(_MSC_VER)
#define EXTERN_FUNCTION(t, f, x)  extern t f x
#define FUNCTION(t, f, x) t f x
#define _DOTS_ ...
#define _VOID_      void
#elif defined(__cplusplus)
#define EXTERN_FUNCTION(f, x) extern "C" { f x }
#define FUNCTION(t, f, x) t f x
#define _DOTS_ ...
#define _VOID_    void
#else
#define EXTERN_FUNCTION(t, f, x) extern t f (/*x*/)
#define FUNCTION(t, f, x) t f (/*x*/)
#define _DOTS_
#define _VOID_
#endif

#ifdef USE_ELIB
#include "elib.h"
#endif

/* This isn't sys-dependent, but putting it here benefits sys.c and drivers
   - allow use of 'const' regardless of compiler */

#if !defined(__STDC__) && !defined(_MSC_VER)
#define const
#endif

#ifdef VXWORKS
/* Replace VxWorks' printf with a real one that does fprintf(stdout, ...) */
EXTERN_FUNCTION(int, real_printf, (const char *fmt, ...));
#define printf real_printf
#endif

#ifdef ALPHA
typedef int		sint32;
typedef unsigned int	uint32;
typedef short		sint16;
typedef unsigned short	uint16;
typedef unsigned char	byte;
#define EXTRA_POINTER_BITS 0x140000000
#else
#ifdef RS6000
#   define EXTRA_POINTER_BITS 0x20000000
#endif
#ifdef HP9000
#   define EXTRA_POINTER_BITS 0x40000000
#endif
typedef long		sint32;
typedef unsigned long	uint32;
typedef short		sint16;
typedef unsigned short	uint16;
typedef unsigned char	byte;
#endif


/* Deal with memcpy() vs bcopy() etc. We want to use the mem*() functions,
   but be able to fall back on bcopy() etc on systems that don't have
   mem*(), but this doesn't work to well with memset()/bzero() - thus the
   memzero() macro.
*/

/* xxxP */
#if defined(USE_BCOPY)
#define memcpy(a, b, c) bcopy((b), (a), (c))
#define memcmp(a, b, c) bcmp((a), (b), (c))
#define memzero(buf, len) bzero((buf), (len))
#else
#define memzero(buf, len) memset((buf), '\0', (len))
#endif

/* Stuff that is useful for port programs, drivers, etc */

#ifdef ISC32			/* Too much for the Makefile... */
#define signal	sigset
#define lgamma	undef_math_func_1
#define asinh	undef_math_func_1
#define acosh	undef_math_func_1
#define atanh	undef_math_func_1
#define NO_FTRUNCATE
#define SIG_SIGHOLD
#define _POSIX_SOURCE 
#define _XOPEN_SOURCE
#endif

#ifdef QNX			/* Too much for the Makefile... */
#define SYS_SELECT_H
#define erf	undef_math_func_1
#define erfc	undef_math_func_1
#define lgamma	undef_math_func_1
/* This definition doesn't take NaN into account, but matherr() gets those */
#define finite(x) (fabs(x) != HUGE_VAL)
#define USE_MATHERR
#define HAVE_FINITE
#endif


#ifdef WANT_NONBLOCKING	    /* must define this to pull in fcntl.h/ioctl.h */

/* This is really a mess... We used to use fcntl O_NDELAY, but that seems
   to only work on SunOS 4 - in particular, on SysV-based systems
   (including Solaris 2), it does set non-blocking mode, but causes
   read() to return 0!!  fcntl O_NONBLOCK is specified by POSIX, and
   seems to work on most systems, with the notable exception of AIX,
   where the old ioctl FIONBIO is the *only* one that will set a *socket*
   in non-blocking mode - and ioctl FIONBIO on AIX *doesn't* work for
   pipes or ttys (O_NONBLOCK does)!!! For now, we'll use FIONBIO for AIX. */

#ifdef __WIN32__

static unsigned long zero_value = 0, one_value = 1;
#define SET_BLOCKING(fd)	{ if (ioctlsocket((fd), FIONBIO, &zero_value) != 0) fprintf(stderr, "Error setting socket to non-blocking: %d\n", WSAGetLastError()); }
#define SET_NONBLOCKING(fd)	ioctlsocket((fd), FIONBIO, &one_value)

#else
#ifdef VXWORKS
#include <fcntl.h> /* xxxP added for O_WRONLY etc ... macro:s ... */
#include <ioLib.h>
static const int zero_value = 0, one_value = 1;
#define SET_BLOCKING(fd)	ioctl((fd), FIONBIO, (int)&zero_value)
#define SET_NONBLOCKING(fd)	ioctl((fd), FIONBIO, (int)&one_value)
#define ERRNO_BLOCK EWOULDBLOCK

#else
#ifdef NB_FIONBIO		/* Old BSD */
#include <sys/ioctl.h>
static const int zero_value = 0, one_value = 1;
#define SET_BLOCKING(fd)	ioctl((fd), FIONBIO, &zero_value)
#define SET_NONBLOCKING(fd)	ioctl((fd), FIONBIO, &one_value)
#define ERRNO_BLOCK EWOULDBLOCK
#else /* !NB_FIONBIO */
#include <fcntl.h>
#ifdef NB_O_NDELAY		/* Nothing needs this? */
#   define NB_FLAG O_NDELAY
#   ifndef ERRNO_BLOCK		/* allow override (e.g. EAGAIN) via Makefile */
#      define ERRNO_BLOCK EWOULDBLOCK
#   endif
#else  /* !NB_O_NDELAY */	/* The True Way - POSIX!:-) */
#   define NB_FLAG O_NONBLOCK
#   define ERRNO_BLOCK EAGAIN
#endif /* !NB_O_NDELAY */
#define SET_BLOCKING(fd)	fcntl((fd), F_SETFL, \
				      fcntl((fd), F_GETFL, 0) & ~NB_FLAG)
#define SET_NONBLOCKING(fd)	fcntl((fd), F_SETFL, \
				      fcntl((fd), F_GETFL, 0) | NB_FLAG)
#endif /* !NB_FIONBIO */
#endif /* _WXWORKS_ */
#endif /* WANT_NONBLOCKING */

#endif /* !__WIN32__ */
     
/* Type that signal handlers return */
#ifndef SIGRETTYPE		/* allow override via Makefile */
#define SIGRETTYPE void
#endif
/* These are defined in sys.c */
extern SIGRETTYPE (*sys_sigset())();
extern void sys_sigrelease(int);
extern void sys_sigblock(int);

/*************** Floating point exception handling ***************/
#ifndef VXWORKS             /* currently defined in erl_vxworks_sys.h */
#ifdef __WIN32__
extern int erl_fp_exception;	/* defined in sys.c */
#define FP_PRE_CHECK_OK() (erl_fp_exception=0, 1)
#define FP_RESULT_OK(f) (!erl_fp_exception && _finite(f))
#endif

#ifndef __WIN32__
#ifdef USE_ISINF_ISNAN		/* simulate finite() */
#  define finite(f) (!isinf(f) && !isnan(f))
#  define HAVE_FINITE
#endif
#ifdef NO_FPE_CHECK		/* No FPE handling whatsoever */
#  define FP_RESULT_OK(f) (1)
#  define FP_PRE_CHECK_OK() (1)
#  define NO_FPE_SIGNALS
#endif

#if defined(HAVE_IEEE_HANDLER) && !defined(NO_FPE_SIGNALS)
   extern int erl_fp_exception;        /* defined in sys.c */
#  define FP_PRE_CHECK_OK() (erl_fp_exception=0, 1)
#  ifdef HAVE_FINITE
#    define FP_RESULT_OK(f) (!erl_fp_exception && finite(f))
#  else
#    define FP_RESULT_OK(f) (!erl_fp_exception)
#  endif
#else
   /* No FPE signal handling */
#  define NO_FPE_SIGNALS
#  ifdef HAVE_FINITE
#    ifdef USE_MATHERR
       extern int erl_fp_exception;        /* defined in sys.c */
#      define FP_PRE_CHECK_OK() (erl_fp_exception=0, 1)
#      define FP_RESULT_OK(f) (!erl_fp_exception && finite(f))
#    else
#      define FP_RESULT_OK(f) (finite(f))
#    endif
#  else
#    ifdef USE_MATHERR
       extern int erl_fp_exception;        /* defined in sys.c */
#      define FP_PRE_CHECK_OK() (erl_fp_exception=0, 1)
#      define FP_RESULT_OK(f) (!erl_fp_exception)
#    endif
#  endif
#endif

/* This macro is used *before* the actual floating point op is performed */
#ifndef FP_PRE_CHECK_OK
#  define FP_PRE_CHECK_OK() (1)
#endif

#endif /* !__WIN32__ */
#endif /* !VXWORKS */

/* Io constants to sys_printf and sys_putc */

typedef enum {
    CBUF = 0,
    COUT = 1,
    CERR = 2
} CIO;

typedef struct preload {
    char *name;  /* name of module */
    int  size;   /* 0 if beam_C size otherwise */
    void* ptr1;  /* function or code pointer */
    void* ptr2;  /* use in preloaded beam only */
} Preload;


/*
 * This structure contains options to all built in drivers.
 * None of the drivers use all of the fields.
 */

typedef struct _SysDriverOpts {
    int ifd;			/* Input file descriptor (fd driver). */
    int ofd;			/* Outputfile descriptor (fd driver). */
    int packet_bytes;		/* Number of bytes in packet header. */
    int read_write;		/* Read and write bits. */
    int use_stdio;		/* Use standard I/O: TRUE or FALSE. */
    int redir_stderr;           /* Redirect stderr to stdout: TRUE/FALSE. */
    int hide_window;		/* Hide this windows (Windows). */
    char *envir;		/* Environment of the port process, */
				/* in Windows format. */
    char *wd;			/* Working directory. */
} SysDriverOpts;

#ifdef DEBUG
extern int tot_allocated;
#endif

extern int cerr_pos;

extern char os_type[];

EXTERN_FUNCTION(int, sys_init_time, (int));
EXTERN_FUNCTION(int, sys_max_files, (_VOID_));
EXTERN_FUNCTION(void, sys_init_io, (byte*, uint32));
EXTERN_FUNCTION(const Preload*, sys_preloaded, (_VOID_));
EXTERN_FUNCTION(unsigned char*, sys_preload_begin, (Preload*));
EXTERN_FUNCTION(void, sys_preload_end, (Preload*));
EXTERN_FUNCTION(int, sys_get_key, (int));
EXTERN_FUNCTION(void, elapsed_time_both, (unsigned long*, unsigned long*, unsigned long*, unsigned long*));
EXTERN_FUNCTION(void, wall_clock_elapsed_time_both, (unsigned long*, unsigned long*));
EXTERN_FUNCTION(void, get_time, (int*, int*, int*));
EXTERN_FUNCTION(void, get_date, (int*, int*, int*));
EXTERN_FUNCTION(void, get_localtime, (int*, int*, int*, int*, int*, int*));
EXTERN_FUNCTION(void, get_universaltime, (int*, int*, int*, int*, int*, int*));
EXTERN_FUNCTION(int, univ_to_local, (int*, int*, int*, int*, int*, int*));
EXTERN_FUNCTION(int, local_to_univ, (int*, int*, int*, int*, int*, int*));
EXTERN_FUNCTION(void, get_now, (uint32*, uint32*, uint32*));
EXTERN_FUNCTION(void, set_break_quit, (void (*)(), void (*)()));

typedef void *GETENV_STATE;

EXTERN_FUNCTION(void, os_flavor, (char*, unsigned));
EXTERN_FUNCTION(void, os_version, (int*, int*, int*));
EXTERN_FUNCTION(void, init_getenv_state, (GETENV_STATE *));
EXTERN_FUNCTION(char *, getenv_string, (GETENV_STATE *));

/* xxxP */
EXTERN_FUNCTION(void, init_sys_float, (void));
EXTERN_FUNCTION(int, sys_chars_to_double, (char*, double*));
EXTERN_FUNCTION(int, sys_double_to_chars, (double, char*));
EXTERN_FUNCTION(void, sys_printf, (CIO, char*, _DOTS_));
EXTERN_FUNCTION(void, sys_putc, (int, CIO));
EXTERN_FUNCTION(void, sys_get_pid, (char *));
EXTERN_FUNCTION(int, sys_putenv, (char *));

#ifdef INSTRUMENT
EXTERN_FUNCTION(void, alloc_from, (int));
#define sys_alloc_from(Where,Size)	(alloc_from(Where),sys_alloc(Size))
#define safe_alloc_from(Where,Size)	(alloc_from(Where),safe_alloc(Size))
#define fix_alloc_from(Where,Desc)	(alloc_from(Where),fix_alloc(Desc))
#else
#define sys_alloc_from(Where,Size)	sys_alloc(Size)
#define safe_alloc_from(Where,Size)	safe_alloc(Size)
#define fix_alloc_from(Where,Desc)	fix_alloc(Desc)
#endif

#ifdef USE_ELIB

#define sys_alloc(sz)        elib_malloc(sz)
#define sys_realloc(ptr,sz)  elib_realloc(ptr,sz)
#define sys_free(p)          elib_free(p)
#define sys_memcpy(s1,s2,n)  elib_memcpy(s1,s2,n)
#define sys_memmove(s1,s2,n) elib_memmove(s1,s2,n)
#define sys_memcmp(s1,s2,n)  elib_memcmp(s1,s2,n)
#define sys_memset(s,c,n)    elib_memset(s,c,n)
#define sys_memzero(s, n)    elib_memset(s,'\0',n)
#define sys_strcmp(s1,s2)    elib_strcmp(s1,s2)
#define sys_strncmp(s1,s2,n) elib_strncmp(s1,s2,n)
#define sys_strcpy(s1,s2)    elib_strcpy(s1,s2)
#define sys_strncpy(s1,s2,n) elib_strncpy(s1,s2,n)
#define sys_strlen(s)        elib_strlen(s)

/* define function symbols (needed in sys_drv_api) */
#define sys_fp_alloc     elib_malloc
#define sys_fp_realloc   elib_realloc
#define sys_fp_free      elib_free
#define sys_fp_memcpy    elib_memcpy
#define sys_fp_memmove   elib_memmove
#define sys_fp_memcmp    elib_memcmp
#define sys_fp_memset    elib_memset
/* #define sys_fp_memzero    elib_memzero */
#define sys_fp_strcmp    elib_strcmp
#define sys_fp_strncmp   elib_strncmp
#define sys_fp_strcpy    elib_strcpy
#define sys_fp_strncpy   elib_strncpy
#define sys_fp_strlen    elib_strlen

#else

EXTERN_FUNCTION(void*, sys_alloc, (unsigned int));
EXTERN_FUNCTION(void*, sys_realloc, (void*,unsigned int));
EXTERN_FUNCTION(void, sys_free, (void*));
/* an alternative to functions above is 
#define sys_alloc(sz)           malloc(sz)
#define sys_realloc(ptr,sz)     realloc(ptr,sz)
#define sys_free(p)             free(p)
*/

#ifdef VXWORKS
EXTERN_FUNCTION(void*, sys_alloc2, (size_t));
EXTERN_FUNCTION(void*, sys_realloc2, (void*,size_t));
EXTERN_FUNCTION(void, sys_free2, (void*));
/* NOTE! sys_calloc2 does not exist on other 
   platforms than VxWorks */
EXTERN_FUNCTION(void*, sys_calloc2, (size_t, size_t));
#endif /* VXWORKS */


#define sys_memcpy(s1,s2,n)  memcpy(s1,s2,n)
#define sys_memmove(s1,s2,n) memmove(s1,s2,n)
#define sys_memcmp(s1,s2,n)  memcmp(s1,s2,n)
#define sys_memset(s,c,n)    memset(s,c,n)
#define sys_memzero(s, n)    memset(s,'\0',n)
#define sys_strcmp(s1,s2)    strcmp(s1,s2)
#define sys_strncmp(s1,s2,n) strncmp(s1,s2,n)
#define sys_strcpy(s1,s2)    strcpy(s1,s2)
#define sys_strncpy(s1,s2,n) strncpy(s1,s2,n)
#define sys_strlen(s)        strlen(s)

/* define function symbols (needed in sys_drv_api) */
#define sys_fp_alloc     sys_alloc
#define sys_fp_realloc   sys_realloc
#define sys_fp_free      sys_free
#define sys_fp_memcpy    memcpy
#define sys_fp_memmove   memmove
#define sys_fp_memcmp    memcmp
#define sys_fp_memset    memset
/* #define sys_fp_memzero    elib_memzero */
#define sys_fp_strcmp    strcmp
#define sys_fp_strncmp   strncmp
#define sys_fp_strcpy    strcpy
#define sys_fp_strncpy   strncpy
#define sys_fp_strlen    strlen

#endif

/* xxxP no_strerror ? */
#define sys_strerror(i)         strerror(i)

/* Return codes from the nb_read and nb_write functions */
#define FD_READY 1
#define FD_CONTINUE 2
#define FD_ERROR 3



/* Standard set of integer macros  .. */

#define get_int32(s) ((((unsigned char*) (s))[0] << 24) | \
                      (((unsigned char*) (s))[1] << 16) | \
                      (((unsigned char*) (s))[2] << 8)  | \
                      (((unsigned char*) (s))[3]))

#define put_int32(i, s) {((char*)(s))[0] = (char)((i) >> 24) & 0xff; \
                        ((char*)(s))[1] = (char)((i) >> 16) & 0xff; \
                        ((char*)(s))[2] = (char)((i) >> 8)  & 0xff; \
                        ((char*)(s))[3] = (char)((i)        & 0xff);}

#define get_int16(s) ((((unsigned char*)  (s))[0] << 8) | \
                      (((unsigned char*)  (s))[1]))


#define put_int16(i, s) {((unsigned char*)(s))[0] = ((i) >> 8) & 0xff; \
                        ((unsigned char*)(s))[1] = (i)         & 0xff;}

#define get_int8(s) ((((unsigned char*)  (s))[0] ))


#define put_int8(i, s) { ((unsigned char*)(s))[0] = (i)         & 0xff;}

/*
 * Use DEBUGF as you would use printf, but use double parentheses:
 *
 *   DEBUGF(("Error: %s\n", error));
 *
 * The output will appear in a special console.
 */

#ifdef DEBUG
EXTERN_FUNCTION(void, erl_debug, (char* format, ...));
EXTERN_FUNCTION(void, erl_bin_write, (unsigned char *, int, int));

#define DEBUGF(x) erl_debug x
#else
#define DEBUGF(x)
#endif


#ifdef VXWORKS
/* This includes redefines of malloc etc 
   this should be done after sys_alloc, etc, above */
#include "reclaim_master.h"
/*********************Malloc and friends************************
 * There is a problem with the naming of malloc and friends, 
 * malloc is used throughout sys.c and the resolver to mean save_alloc,
 * but it should actually mean either sys_alloc or sys_alloc2,
 * so the definitions from reclaim_master.h are not any
 * good, i redefine the malloc family here, although it's quite 
 * ugly, actually it would be preferrable to use the
 * names sys_alloc and so on throughout the offending code, but
 * that will be saved as an later exercise...
 * I also add an own calloc, to make the BSD resolver source happy.
 ***************************************************************/
/* Undefine malloc and friends */
#ifdef malloc
#undef malloc
#endif
#ifdef calloc
#undef calloc
#endif
#ifdef realloc
#undef realloc
#endif
#ifdef free
#undef free
#endif
/* Redefine malloc and friends */
#define malloc sys_alloc
#define calloc  sys_calloc
#define realloc  sys_realloc
#define free sys_free

#endif


#ifdef __WIN32__
void call_break_handler(void);
char* last_error(void);
char* win32_errorstr(int);
DWORD OS_type(void);


#endif
#endif
