/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: module.h
** Author: Tony Rovall
**
*/

#ifndef __MODULE_H__
#define __MODULE_H__

#ifndef __INDEX_H__
#include "index.h"
#endif

/*
** Module entry
*/
typedef struct module 
{
    IndexSlot slot;		/* Must be located at top of struct! */
    int module;			/* Atom index for module (not tagged). */

#if defined(BEAM)
    uint32* code;
    uint32* old_code;
#elif defined(JAM)
    byte* code;
    byte* old_code;
#endif
    int code_length;		/* Length of loaded code in bytes. */
    int old_code_length;	/* Length of old loaded code in bytes */
} Module; 

EXTERN_FUNCTION(int, module_get, (int));
EXTERN_FUNCTION(int, module_put, (int));
EXTERN_FUNCTION(void, init_module_table, (_VOID_));

EXTERN_FUNCTION(void, module_info, (CIO));

extern IndexTable module_table;

#define module_code(i)     ((Module*)module_table.table[i])
#define module_code_size   module_table.sz

#endif
