/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * Makes the file erl_version.h.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>

int
main(argc, argv)
int argc;
char** argv;
{
    FILE *file;
    time_t now;
    char *cnow;

    if (argc != 2) {
	fprintf(stderr, "usage: mkver version\n");
	exit(1);
    }

    if ((file = fopen("erl_version.h", "w")) == NULL) {
	fprintf(stderr, "Could not create file 'erl_version.h'!\n");
	exit(1);
    }

    time(&now);
    cnow = ctime(&now);
    cnow[24] = '\0';		/* tidelipom */
    fprintf(file, "/* This file was created by mkver -- don't modify.*/\n");
    fprintf(file, "#define ERLANG_VERSION \"%s\"\n", argv[1]);
    fprintf(file, "#define ERLANG_COMPILE_DATE \"%s\"\n", cnow);
    fclose(file);

    exit(0);
    return 0;
}
