/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: mkbif.c
** Author: Tony Rogvall
** 
** Description:
**
**  Input:
**     File with table entries (bif.tab)
**
**  Output:
**     sys_bifs.erl
**     bif_table.c
**     bif_table.h
**     bif.names
*/

#include <stdio.h>
#include <stdlib.h>

static FILE* efopen(char* name);

int main(argc, argv)
int argc; char** argv;
{
    char* infile;
    char name[80];
    int  arity;
    char imported[80];
    int index = 0;
    int line = 1;
    FILE* fc;
    FILE* fh;
    FILE* fa;
    FILE* in;

    while (argc > 1 && argv[1][0] == '-') {
	switch (argv[1][1]) {
	case 'd':		/* Directory to work in. */
	    chdir(argv[2]);
	    argc--, argv++;
	    break;
	default:
	    fprintf(stderr, "illegal option: %s\n", argv[1]);
	    break;
	}
	argc--, argv++;
    }

    if (argc == 1) {
	infile = "*stdin*";
	in = stdin;
    }
    else {
	infile = argv[1];
	if ((in = fopen(argv[1], "r")) == NULL) {
	    fprintf(stderr, "could not open file %s\n", argv[1]);
	    exit(1);
	}
    }
    

    fh = efopen("bif_table.h");
    fc = efopen("bif_table.c");
    fa = efopen("bif.names");

    /* PRELUDE */

    fprintf(fh, "/* File: bif_table.h generated from %s */\n", infile);
    fprintf(fh, "#ifndef __BIF_TABLE_H__\n");
    fprintf(fh, "#define __BIF_TABLE_H__\n\n");
    fprintf(fh, "typedef BIF_RETTYPE (*BifFunction)();\n\n");
    fprintf(fh, "typedef struct bif_entry\n");
    fprintf(fh, "{\n");
    fprintf(fh, "\tuint32* name;\n");
    fprintf(fh, "\tint arity;\n");
    fprintf(fh, "\tBifFunction f;\n");
    fprintf(fh, "} BifEntry;\n\n");
    fprintf(fh, "extern const BifEntry bif_table[];\n\n");
    
    fprintf(fc, "/* File: bif_table.c generated from %s */\n", infile);
    fprintf(fc, "#include \"sys.h\"\n");
    fprintf(fc, "#include \"erl_process.h\"\n");
    fprintf(fc, "#include \"bif.h\"\n");
    fprintf(fc, "#include \"am.h\"\n\n");
    
    fprintf(fc, "const BifEntry bif_table[] = {\n");

    while(!feof(in)) {
	int c = fgetc(in);

	/* Skip comments */
	if (c == '#') {
	    while((c = fgetc(in)) != '\n' && c != EOF)
		;
	    line++;
	}
	else {
	    while(c == ' ' || c == '\t' || c == '\n') {
		if (c == '\n')
		    line++;
		c = fgetc(in);
	    }
	    if (c == EOF)
		break;
	    ungetc(c, in);

	    if (fscanf(in, "%s %d %s", name, &arity, imported) != 3) {
		fprintf(stderr, "bad format in %s line %d\n", argv[1], line);
		exit(1);
	    }
	    while((c = fgetc(in)) != '\n' && c != EOF)
		;
		    
	    fprintf(fh, "#define BIF_%s_%d %d\n",
		    name, arity, index);
	    
	    fprintf(fh, 
		    "EXTERN_FUNCTION(BIF_RETTYPE, %s_%d, (BIF_XDECL_%d));\n\n",
		    name, arity, arity);

	    fprintf(fa, "%s\n", name);

	    if (index != 0)
		fprintf(fc, ",\n");
	    fprintf(fc, "\t{&am_%s, %d, %s_%d}",
		    name, arity, name, arity);
	    index++;
	    line++;
	}
    }

    /* POSTLUDE */
    fprintf(fc, "\n};\n");

    fprintf(fh, "#define BIF_SIZE %d\n", index);
    fprintf(fh, "#endif\n");

    fclose(fa);
    fclose(fh);
    fclose(fc);

    return(0);
}

static FILE*
efopen(name)
char* name;
{
    FILE* fp;
    
    if ((fp = fopen(name, "w")) == NULL) {
	fprintf(stderr, "can't open %s\n", name);
	exit(1);
    }
    return fp;
}
