/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: export.c
*/
#include "sys.h"
#include "config.h"
#include "global.h"
#include "export.h"

#define EXPORT_SIZE   500
#define EXPORT_LIMIT  (64*1024)
#define EXPORT_RATE   100

IndexTable export_table;

#ifdef BEAM
extern uint32* em_call_error_handler;
#endif

void export_info(to)
CIO to;
{
    index_info(to, &export_table);
}


static HashValue export_hash(x)
Export* x;
{
    HashValue h = ((x->module*x->function) + x->arity);
    return h;
}

static int export_cmp(tmpl, obj)
Export* tmpl; Export* obj;
{
    if (tmpl->module == obj->module &&
	tmpl->function == obj->function &&
	tmpl->arity == obj->arity)
	return 0;
    return 1;
}


static Export* export_alloc(tmpl)
Export* tmpl;
{
    Export* obj = (Export*) fix_alloc(export_desc);

    obj->module = tmpl->module;
    obj->function = tmpl->function;
    obj->arity = tmpl->arity;
    obj->slot.index = -1;
#if defined(JAM)
    obj->address = NULL;
#elif defined(BEAM)
    obj->address = &obj->op_error_handler;
    obj->op_error_handler = (uint32) em_call_error_handler;
#endif
    return obj;
}


static void export_free(obj)
Export* obj;
{
    fix_free(export_desc, (void*) obj);
}


void init_export_table()
{
    HashFunctions f;

    f.hash = (H_FUN) export_hash;
    f.cmp  = (HCMP_FUN) export_cmp;
    f.alloc = (HALLOC_FUN) export_alloc;
    f.free = (HFREE_FUN) export_free;

    index_init(&export_table, "export_list",
	       EXPORT_SIZE, EXPORT_LIMIT, EXPORT_RATE, f);
    erl_at_exit((ErlExitProc)index_delete, (void*)&export_table);
}


int export_get(m, f, a)
int m, f, a;
{
    Export e;
	
    e.module = m;
    e.function = f;
    e.arity = a;
	
    return index_get(&export_table, (void*) &e);
}


int export_put(m, f, a)
int m, f, a;
{
    Export e;
	
    e.module = m;
    e.function = f;
    e.arity = a;
    e.slot.index = -1;
#if defined(JAM)
    e.address = NULL;
#elif defined(BEAM)
    e.address = &e.op_error_handler;
#endif
    return index_put(&export_table, (void*) &e);
}
