/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#include "sys.h"
#include "config.h"
#include "global.h"
#include "erl_process.h"
#include "big.h"
#include "bif.h"

#define WITHIN(ptr, x, y) ((x) <= (ptr) && (ptr) < (y))

#define IN_HEAP(p, ptr) \
   (WITHIN((ptr), (p)->heap, (p)->hend) || (p->old_heap && \
       WITHIN((ptr), (p)->old_heap, (p)->old_hend)))

static int dcount;

static int pdisplay1(Process* p, uint32 obj, CIO fd);

void ptd(Process* p, uint32 x) 
{
    pdisplay1(p, x, CERR);
    erl_putc('\n', CERR);
}

/*
 * Paranoid version of display which doesn't crasch as easily if there
 * are errors in the data structures.
 */

void
paranoid_display(Process* p, uint32 obj, CIO fd)
{
    dcount = 100000;
    pdisplay1(p, obj, fd);
}

static int
pdisplay1(Process* p, uint32 obj, CIO fd)
{
    int i, k;
    uint32 *nobj;

    if (dcount-- <= 0)
	return(1);

    switch (tag_val_def(obj)) {
    case ATOM_DEF:
	print_atom((int)unsigned_val(obj), fd);
	break;
    case SMALL_DEF:
	erl_printf(fd, "%d", signed_val(obj));
	break;

    case BIG_DEF:
#if defined(BEAM)
        if(is_nil(obj)) {
            erl_printf(fd, "[]");
            break;
        }
#endif
	nobj = ptr_val(obj);
	if (!IN_HEAP(p, nobj)) {
	    erl_printf(fd, "#<bad big %X>#", obj);
	    return 1;
	}

	i = BIG_SIZE(nobj);
	if (BIG_SIGN(nobj))
	    erl_printf(fd, "-#integer(%d) = {", i);
	else
	    erl_printf(fd, "#integer(%d) = {", i);
	erl_printf(fd, "%d", BIG_DIGIT(nobj, 0));
	for (k = 1; k < i; k++)
	    erl_printf(fd, ",%d", BIG_DIGIT(nobj, k));
	erl_putc('}', fd);
	break;
#if defined(JAM)
    case NIL_DEF:
	erl_printf(fd, "[]");
	break;
#endif

    case REFER_DEF:
	erl_printf(fd, "<<%d,%d>>", get_node_reference(obj),
		get_number_reference(obj));
	break;
    case PID_DEF:
	erl_printf(fd, "<%d.%d.%d>",
		get_node(obj),get_number(obj),get_serial(obj));
	break;
    case PORT_DEF:
	erl_printf(fd, "<%d,%d>", get_node_reference(obj),
		get_number_reference(obj));
	break;
    case LIST_DEF:
	erl_putc('[', fd);
	nobj = ptr_val(obj);
	while (1) {
	    if (!IN_HEAP(p, nobj)) {
		erl_printf(fd, "#<bad list %X>", obj);
		return 1;
	    }
	    if (pdisplay1(p, *nobj++, fd) != 0)
		return(1);
	    if (is_not_list(*nobj))
		break;
	    erl_putc(',', fd);
	    nobj = ptr_val(*nobj);
	}
	if (is_not_nil(*nobj)) {
	    erl_putc('|', fd);
	    if (pdisplay1(p, *nobj, fd) != 0)
		return(1);
	}
	erl_putc(']', fd);
	break;
    case TUPLE_DEF:
	nobj = ptr_val(obj);	/* pointer to arity */
	i = arityval(*nobj);	/* arity */
	erl_putc('{', fd);
	while (i--) {
	    if (pdisplay1(p, *++nobj,fd) != 0) return(1);
	    if (i >= 1) erl_putc(',',fd);
	}
	erl_putc('}',fd);
	break;
    case FLOAT_DEF: {
	    FloatDef ff;
	    GET_DOUBLE(obj, ff);
	    erl_printf(fd, "%.20e", ff.fd);
	}
	break;
    case BINARY_DEF:
	erl_printf(fd, "#Bin");
	break;
#if defined(BEAM)
    case CP0:
#ifndef NOT_ALIGNED
    case CP4:
    case CP8:
    case CP12:
#endif
        erl_printf(fd, "cp %d", obj);
        break;  
    case BLANK:
        erl_printf(fd, "blank");
        break;  
#endif
    default:
	erl_printf(fd, "unknown object %x", obj);
    }
    return(0);
}

#ifdef BEAM
void
pps(p, stop)
Process* p; uint32* stop;
{
    uint32* sp = p->stack-1;

    if (stop <= p->htop) {
	stop = p->htop + 1;
    }

    while(sp >= stop) {
	erl_printf(COUT,"%08lx: ", (uint32) sp);
	if (is_catch(*sp)) {
	    erl_printf(COUT, "catch %d", ptr_val(*sp));
	} else {
	    paranoid_display(p, *sp, COUT);
	}
	erl_putc('\r', COUT);
	erl_putc('\n', COUT);
	sp--;
    }
}
#endif
