/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
 * This file is copyright (c) Ellemtel in December 1992
 *
 *
 * Include file for erlang driver writers 
 *  Author: Claes Wikstrom 
 */

#ifndef __DRIVER_H__
#define __DRIVER_H__

#include "driver_int.h"

#undef _ANSI_ARGS_
#undef CONST

#if ((defined(__STDC__) || defined(SABER)) && !defined(NO_PROTOTYPE)) || defined(__cplusplus) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)	x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)	()
#   define CONST
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif

/* Values for mode arg to driver_select() */

#define DO_READ	 (1 << 0)
#define DO_WRITE (1 << 1)

/* This macro is used to name a dynamic driver's init function in */
/* a way that doesn't lead to conflicts. This is crucial when using */
/* operating systems that has one namespace for all symbols */
/* (e.g. VxWorks). Example: if you have an dynamic driver C source */
/* file named echo_drv.c, you use the macro like this: */
/* int DRIVER_INIT(echo_drv)(void *handle) */
#if defined(VXWORKS)
#  define DRIVER_INIT(DRIVER_NAME) DRIVER_NAME  ## _init
#elif defined(__WIN32__)
#  define DRIVER_INIT(DRIVER_NAME) __declspec(dllexport) driver_init
#else 
#  define DRIVER_INIT(DRIVER_NAME)  driver_init
#endif

typedef int (*F_PTR)();    /* a function pointer */
typedef long (*L_PTR)();   /* pointer to a function returning long */

extern int null_func();

/* This structure MUST match Binary in global.h exactly!!! */
typedef struct driver_binary {
    int orig_size;        /* total length of binary */
    int refc;             /* number of references to this binary */
    char orig_bytes[1];   /* the data (char instead of byte!) */
} DriverBinary;

typedef struct {
    int vsize;     /* length of vectors */
    int size;      /* total size in bytes */
    SysIOVec* iov;
    DriverBinary**  binv;
} ErlIOVec;


typedef struct driver_entry {
    F_PTR init;          /* called at system start up (no args) */
    L_PTR start;         /* called when some one does an open_port
			 args: port, command (nul-terminated),
			 additional/alternate args for fd/vanilla/spawn driver.
			 return value -1 means failure, other
			 is saved and passed to the other funcs */
    F_PTR stop;          /* called when port is closed, and when the
			    emulator is halted - arg: start_return */
    F_PTR output;	 /* called when we have output from erlang to the port
		         args: start_return, buf, buflen */
    F_PTR ready_input;   /* called when we have input from one of the driver's
			 file descriptors - args: start_return, fd */
    F_PTR ready_output;  /* called when output is possible to one of the driver's
			 file descriptors - args: start_return, fd */
    char *driver_name;   /* name supplied as {driver,Name,Args} to open_port */

    F_PTR finish;        /* called before unloading (DYNAMIC DRIVERS ONLY) */
    void *handle;        /* file handle             (DYNAMIC DRIVERS ONLY) */
    F_PTR control;	 /* "ioctl" for drivers (invoked by port_command/3) */
    int (*timeout)_ANSI_ARGS_((long));	           /* Reserved */
    int (*outputv)_ANSI_ARGS_((long, ErlIOVec*));  /* Reserved */
} DriverEntry;


typedef struct de_list {
    DriverEntry *drv;
    struct de_list *next;
} DE_List;

extern DE_List *driver_list;

/* These are the kernel functions available for driver writers */

EXTERN int driver_select _ANSI_ARGS_((int,int,int,int));

EXTERN int driver_output _ANSI_ARGS_((int, char*, int));
EXTERN int driver_output2 _ANSI_ARGS_((int, char*, int, char*, int));
EXTERN int driver_output_binary _ANSI_ARGS_((int, char*, int,
					     DriverBinary*, int, int));
EXTERN int driver_outputv _ANSI_ARGS_((int, char*,int,ErlIOVec*,int));

EXTERN int driver_vec_to_buf _ANSI_ARGS_((ErlIOVec*, char*, int));

EXTERN int driver_set_timer _ANSI_ARGS_((int, unsigned long));
EXTERN int driver_cancel_timer _ANSI_ARGS_((int));

/*
 * The following functions are used to initiate a close of a port
 * from a driver.
 */
EXTERN int driver_failure_eof _ANSI_ARGS_((int));
EXTERN int driver_failure_atom _ANSI_ARGS_((int, char *));
EXTERN int driver_failure_posix _ANSI_ARGS_((int, int));
EXTERN int driver_failure _ANSI_ARGS_((int, int));


EXTERN char* erl_errno_id _ANSI_ARGS_((int error));
EXTERN void set_busy_port _ANSI_ARGS_((int, int));
EXTERN void add_driver_entry _ANSI_ARGS_((DriverEntry *));
EXTERN int remove_driver_entry _ANSI_ARGS_((DriverEntry *));

/* Binary interface */
/* NOTE: DO NOT overwrite a binary with new data (if the data is delivered);
** since the binary is a shared object it MUST be written once.
*/

EXTERN DriverBinary* driver_alloc_binary _ANSI_ARGS_((int));
EXTERN DriverBinary* driver_realloc_binary _ANSI_ARGS_((DriverBinary*, int));
EXTERN void driver_free_binary _ANSI_ARGS_((DriverBinary*));


/* Queue interface */
EXTERN int driver_enqv _ANSI_ARGS_((int, ErlIOVec*, int));
EXTERN int driver_pushqv _ANSI_ARGS_((int, ErlIOVec*, int));
EXTERN int driver_deq _ANSI_ARGS_((int, int));
EXTERN SysIOVec* driver_peekq _ANSI_ARGS_((int, int*));
EXTERN int driver_sizeq _ANSI_ARGS_((int));
EXTERN int driver_enq_bin _ANSI_ARGS_((int, DriverBinary*, int, int));
EXTERN int driver_enq _ANSI_ARGS_((int, char*, int));
EXTERN int driver_pushq_bin _ANSI_ARGS_((int, DriverBinary*, int, int));
EXTERN int driver_pushq _ANSI_ARGS_((int, char*, int));

#endif
