/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/*
** File: jam_opcode.h
**
*/
#ifndef __JAM_OPCODES_H__
#define __JAM_OPCODES_H__

enum {
    OP_dummy = 0,		/* Forces better code generation. */
    OP_pushVar_0 = 1,
    OP_pushVar_1 = 2,
    OP_pushVar_2 = 3,
    OP_pushVar_3 = 4,
    OP_pushVar_4 = 5,
    OP_pushVar_5 = 6,
    OP_pushVar_6 = 7,
    OP_pushVar_7 = 8,
    OP_pushVar_8 = 9,
    OP_pushVar_9 = 10,
    OP_pushVar_10 = 11,
    OP_pushVar_11 = 12,
    OP_pushVar_12 = 13,
    OP_pushVar_13 = 14,
    OP_pushVar_14 = 15,
    OP_pushVar_15 = 16,
    OP_pushVarN = 17,
    OP_storeVar_0 = 18,
    OP_storeVar_1 = 19,
    OP_storeVar_2 = 20,
    OP_storeVar_3 = 21,
    OP_storeVar_4 = 22,
    OP_storeVar_5 = 23,
    OP_storeVar_6 = 24,
    OP_storeVar_7 = 25,
    OP_storeVar_8 = 26,
    OP_storeVar_9 = 27,
    OP_storeVar_10 = 28,
    OP_storeVar_11 = 29,
    OP_storeVar_12 = 30,
    OP_storeVar_13 = 31,
    OP_storeVar_14 = 32,
    OP_storeVar_15 = 33,
    OP_storeVarN = 34,
    OP_alloc_0 = 35,
    OP_alloc_1 = 36,
    OP_alloc_2 = 37,
    OP_alloc_3 = 38,
    OP_alloc_4 = 39,
    OP_alloc_5 = 40,
    OP_alloc_6 = 41,
    OP_alloc_7 = 42,
    OP_alloc_8 = 43,
    OP_alloc_9 = 44,
    OP_alloc_10 = 45,
    OP_alloc_11 = 46,
    OP_alloc_12 = 47,
    OP_alloc_13 = 48,
    OP_alloc_14 = 49,
    OP_alloc_15 = 50,
    OP_allocN = 51,
    OP_eqVar_0 = 52,
    OP_eqVar_1 = 53,
    OP_eqVar_2 = 54,
    OP_eqVar_3 = 55,
    OP_eqVar_4 = 56,
    OP_eqVar_5 = 57,
    OP_eqVar_6 = 58,
    OP_eqVar_7 = 59,
    OP_eqVar_8 = 60,
    OP_eqVar_9 = 61,
    OP_eqVar_10 = 62,
    OP_eqVar_11 = 63,
    OP_eqVar_12 = 64,
    OP_eqVar_13 = 65,
    OP_eqVar_14 = 66,
    OP_eqVar_15 = 67,
    OP_eqVarN = 68,
    OP_eqArg_0 = 69,
    OP_eqArg_1 = 70,
    OP_eqArg_2 = 71,
    OP_eqArg_3 = 72,
    OP_eqArg_4 = 73,
    OP_eqArg_5 = 74,
    OP_eqArg_6 = 75,
    OP_eqArg_7 = 76,
    OP_eqArg_8 = 77,
    OP_eqArg_9 = 78,
    OP_eqArg_10 = 79,
    OP_eqArg_11 = 80,
    OP_eqArg_12 = 81,
    OP_eqArg_13 = 82,
    OP_eqArg_14 = 83,
    OP_eqArg_15 = 84,
    OP_eqArgN = 85,
    OP_arg_0 = 86,
    OP_arg_1 = 87,
    OP_arg_2 = 88,
    OP_arg_3 = 89,
    OP_arg_4 = 90,
    OP_arg_5 = 91,
    OP_arg_6 = 92,
    OP_arg_7 = 93,
    OP_arg_8 = 94,
    OP_arg_9 = 95,
    OP_arg_10 = 96,
    OP_arg_11 = 97,
    OP_arg_12 = 98,
    OP_arg_13 = 99,
    OP_arg_14 = 100,
    OP_arg_15 = 101,
    OP_argN = 102,
    OP_unpkTuple_0 = 103,
    OP_unpkTuple_1 = 104,
    OP_unpkTuple_2 = 105,
    OP_unpkTuple_3 = 106,
    OP_unpkTuple_4 = 107,
    OP_unpkTuple_5 = 108,
    OP_unpkTuple_6 = 109,
    OP_unpkTuple_7 = 110,
    OP_unpkTuple_8 = 111,
    OP_unpkTuple_9 = 112,
    OP_unpkTuple_10 = 113,
    OP_unpkTuple_11 = 114,
    OP_unpkTuple_12 = 115,
    OP_unpkTuple_13 = 116,
    OP_unpkTuple_14 = 117,
    OP_unpkTuple_15 = 118,
    OP_unpkTupleN = 119,
    OP_mkTuple_0 = 120,
    OP_mkTuple_1 = 121,
    OP_mkTuple_2 = 122,
    OP_mkTuple_3 = 123,
    OP_mkTuple_4 = 124,
    OP_mkTuple_5 = 125,
    OP_mkTuple_6 = 126,
    OP_mkTuple_7 = 127,
    OP_mkTuple_8 = 128,
    OP_mkTuple_9 = 129,
    OP_mkTuple_10 = 130,
    OP_mkTuple_11 = 131,
    OP_mkTuple_12 = 132,
    OP_mkTuple_13 = 133,
    OP_mkTuple_14 = 134,
    OP_mkTuple_15 = 135,
    OP_mkTupleN = 136,
    OP_getInt_0 = 137,
    OP_getInt_1 = 138,
    OP_getInt_2 = 139,
    OP_getInt_3 = 140,
    OP_getInt_4 = 141,
    OP_getInt_5 = 142,
    OP_getInt_6 = 143,
    OP_getInt_7 = 144,
    OP_getInt_8 = 145,
    OP_getInt_9 = 146,
    OP_getInt_10 = 147,
    OP_getInt_11 = 148,
    OP_getInt_12 = 149,
    OP_getInt_13 = 150,
    OP_getInt_14 = 151,
    OP_getInt_15 = 152,
    OP_getInt1 = 153,
    OP_hash = 154,
    OP_getFloat = 155,
    OP_pushInt_0 = 156,
    OP_pushInt_1 = 157,
    OP_pushInt_2 = 158,
    OP_pushInt_3 = 159,
    OP_pushInt_4 = 160,
    OP_pushInt_5 = 161,
    OP_pushInt_6 = 162,
    OP_pushInt_7 = 163,
    OP_pushInt_8 = 164,
    OP_pushInt_9 = 165,
    OP_pushInt_10 = 166,
    OP_pushInt_11 = 167,
    OP_pushInt_12 = 168,
    OP_pushInt_13 = 169,
    OP_pushInt_14 = 170,
    OP_pushInt_15 = 171,
    OP_pushInt1 = 172,
    OP_type = 173,
    OP_pushFloat = 174,
    OP_nodebug_info = 175,
    OP_list_length = 176,
    OP_getAtom = 177,
    OP_try_me_else_fail = 178,
    OP_commit = 179,
    OP_ret = 180,
    OP_getNil = 181,
    OP_pushNil = 182,
    OP_pop = 183,
    OP_mkList = 184,
    OP_unpkList = 185,
    OP_send = 186,
    OP_self = 187,
    OP_pushStr = 188,
    OP_pushAtom = 189,
    OP_getStr = 190,
    OP_call_remote = 191,
    OP_head = 192,
    OP_enter_remote = 193,
    OP_dup = 194,
    OP_popCommit = 195,
    OP_failIf = 196,
    OP_failCase = 197,
    OP_tail = 198,
    OP_popCatch = 199,
    OP_setTimeout = 200,
    OP_wait = 201,
    OP_gotoix = 202,
    OP_popCommitJoin = 203,
    OP_save = 204,
    OP_arith_plus = 205,
    OP_arith_minus = 206,
    OP_arith_times = 207,
    OP_arith_div = 208,
    OP_arith_intdiv = 209,
    OP_arith_band = 210,
    OP_arith_bor = 211,
    OP_arith_bxor = 212,
    OP_arith_bnot = 213,
    OP_arith_bsl = 214,
    OP_arith_bsr = 215,
    OP_arith_rem = 216,
    OP_comp_gt = 217,
    OP_comp_lt = 218,
    OP_comp_geq = 219,
    OP_comp_leq = 220,
    OP_pushIntN = 221,
    OP_getIntN = 222,
    OP_exact_eqeq = 223,
    OP_exact_neq = 224,
    OP_test_integer = 225,
    OP_test_float = 226,
    OP_test_number = 227,
    OP_test_atom = 228,
    OP_test_constant = 229,
    OP_test_list = 230,
    OP_test_tuple = 231,
    OP_test_pid = 232,
    OP_test_reference = 233,
    OP_test_port = 234,
    OP_stack_need = 235,
    OP_heap_need = 236,
    OP_comp_eqeq = 237,
    OP_comp_neq = 238,
    OP_debug_info = 239,
    OP_failFunction = 240,
    OP_test_binary = 241,
    OP_try_me_else = 242,
    OP_goto = 243,
    OP_call_local = 244,
    OP_enter_local = 245,
    OP_pushCatch = 246,
    OP_wait1 = 247,
    OP_pushInt4 = 248,
    OP_getInt4 = 249,
    OP_arith_neg = 250,
    OP_apply_enter = 251,
    OP_apply_call = 252,
    OP_bif_enter = 253,
    OP_bif_call = 254,
    OP_die = 255
};

#if defined(__GNUC__) && defined(WANT_JUMP_TABLE) && !defined(QUANTIFY)
#define DECL_JMPTAB \
    __label__ \
        L_OP_dummy, \
	L_OP_pushVar_0, \
	L_OP_pushVar_1, \
	L_OP_pushVar_2, \
	L_OP_pushVar_3, \
	L_OP_pushVar_4, \
	L_OP_pushVar_5, \
	L_OP_pushVar_6, \
	L_OP_pushVar_7, \
	L_OP_pushVar_8, \
	L_OP_pushVar_9, \
	L_OP_pushVar_10, \
	L_OP_pushVar_11, \
	L_OP_pushVar_12, \
	L_OP_pushVar_13, \
	L_OP_pushVar_14, \
	L_OP_pushVar_15, \
	L_OP_pushVarN, \
	L_OP_storeVar_0, \
	L_OP_storeVar_1, \
	L_OP_storeVar_2, \
	L_OP_storeVar_3, \
	L_OP_storeVar_4, \
	L_OP_storeVar_5, \
	L_OP_storeVar_6, \
	L_OP_storeVar_7, \
	L_OP_storeVar_8, \
	L_OP_storeVar_9, \
	L_OP_storeVar_10, \
	L_OP_storeVar_11, \
	L_OP_storeVar_12, \
	L_OP_storeVar_13, \
	L_OP_storeVar_14, \
	L_OP_storeVar_15, \
	L_OP_storeVarN, \
	L_OP_alloc_0, \
	L_OP_alloc_1, \
	L_OP_alloc_2, \
	L_OP_alloc_3, \
	L_OP_alloc_4, \
	L_OP_alloc_5, \
	L_OP_alloc_6, \
	L_OP_alloc_7, \
	L_OP_alloc_8, \
	L_OP_alloc_9, \
	L_OP_alloc_10, \
	L_OP_alloc_11, \
	L_OP_alloc_12, \
	L_OP_alloc_13, \
	L_OP_alloc_14, \
	L_OP_alloc_15, \
	L_OP_allocN, \
	L_OP_eqVar_0, \
	L_OP_eqVar_1, \
	L_OP_eqVar_2, \
	L_OP_eqVar_3, \
	L_OP_eqVar_4, \
	L_OP_eqVar_5, \
	L_OP_eqVar_6, \
	L_OP_eqVar_7, \
	L_OP_eqVar_8, \
	L_OP_eqVar_9, \
	L_OP_eqVar_10, \
	L_OP_eqVar_11, \
	L_OP_eqVar_12, \
	L_OP_eqVar_13, \
	L_OP_eqVar_14, \
	L_OP_eqVar_15, \
	L_OP_eqVarN, \
	L_OP_eqArg_0, \
	L_OP_eqArg_1, \
	L_OP_eqArg_2, \
	L_OP_eqArg_3, \
	L_OP_eqArg_4, \
	L_OP_eqArg_5, \
	L_OP_eqArg_6, \
	L_OP_eqArg_7, \
	L_OP_eqArg_8, \
	L_OP_eqArg_9, \
	L_OP_eqArg_10, \
	L_OP_eqArg_11, \
	L_OP_eqArg_12, \
	L_OP_eqArg_13, \
	L_OP_eqArg_14, \
	L_OP_eqArg_15, \
	L_OP_eqArgN, \
	L_OP_arg_0, \
	L_OP_arg_1, \
	L_OP_arg_2, \
	L_OP_arg_3, \
	L_OP_arg_4, \
	L_OP_arg_5, \
	L_OP_arg_6, \
	L_OP_arg_7, \
	L_OP_arg_8, \
	L_OP_arg_9, \
	L_OP_arg_10, \
	L_OP_arg_11, \
	L_OP_arg_12, \
	L_OP_arg_13, \
	L_OP_arg_14, \
	L_OP_arg_15, \
	L_OP_argN, \
	L_OP_unpkTuple_0, \
	L_OP_unpkTuple_1, \
	L_OP_unpkTuple_2, \
	L_OP_unpkTuple_3, \
	L_OP_unpkTuple_4, \
	L_OP_unpkTuple_5, \
	L_OP_unpkTuple_6, \
	L_OP_unpkTuple_7, \
	L_OP_unpkTuple_8, \
	L_OP_unpkTuple_9, \
	L_OP_unpkTuple_10, \
	L_OP_unpkTuple_11, \
	L_OP_unpkTuple_12, \
	L_OP_unpkTuple_13, \
	L_OP_unpkTuple_14, \
	L_OP_unpkTuple_15, \
	L_OP_unpkTupleN, \
	L_OP_mkTuple_0, \
	L_OP_mkTuple_1, \
	L_OP_mkTuple_2, \
	L_OP_mkTuple_3, \
	L_OP_mkTuple_4, \
	L_OP_mkTuple_5, \
	L_OP_mkTuple_6, \
	L_OP_mkTuple_7, \
	L_OP_mkTuple_8, \
	L_OP_mkTuple_9, \
	L_OP_mkTuple_10, \
	L_OP_mkTuple_11, \
	L_OP_mkTuple_12, \
	L_OP_mkTuple_13, \
	L_OP_mkTuple_14, \
	L_OP_mkTuple_15, \
	L_OP_mkTupleN, \
	L_OP_getInt_0, \
	L_OP_getInt_1, \
	L_OP_getInt_2, \
	L_OP_getInt_3, \
	L_OP_getInt_4, \
	L_OP_getInt_5, \
	L_OP_getInt_6, \
	L_OP_getInt_7, \
	L_OP_getInt_8, \
	L_OP_getInt_9, \
	L_OP_getInt_10, \
	L_OP_getInt_11, \
	L_OP_getInt_12, \
	L_OP_getInt_13, \
	L_OP_getInt_14, \
	L_OP_getInt_15, \
	L_OP_getInt1, \
	L_OP_hash, \
	L_OP_getFloat, \
	L_OP_pushInt_0, \
	L_OP_pushInt_1, \
	L_OP_pushInt_2, \
	L_OP_pushInt_3, \
	L_OP_pushInt_4, \
	L_OP_pushInt_5, \
	L_OP_pushInt_6, \
	L_OP_pushInt_7, \
	L_OP_pushInt_8, \
	L_OP_pushInt_9, \
	L_OP_pushInt_10, \
	L_OP_pushInt_11, \
	L_OP_pushInt_12, \
	L_OP_pushInt_13, \
	L_OP_pushInt_14, \
	L_OP_pushInt_15, \
	L_OP_pushInt1, \
	L_OP_type, \
	L_OP_pushFloat, \
	L_OP_nodebug_info, \
	L_OP_list_length, \
	L_OP_getAtom, \
	L_OP_try_me_else_fail, \
	L_OP_commit, \
	L_OP_ret, \
	L_OP_getNil, \
	L_OP_pushNil, \
	L_OP_pop, \
	L_OP_mkList, \
	L_OP_unpkList, \
	L_OP_send, \
	L_OP_self, \
	L_OP_pushStr, \
	L_OP_pushAtom, \
	L_OP_getStr, \
	L_OP_call_remote, \
	L_OP_head, \
	L_OP_enter_remote, \
	L_OP_dup, \
	L_OP_popCommit, \
	L_OP_failIf, \
	L_OP_failCase, \
	L_OP_tail, \
	L_OP_popCatch, \
	L_OP_setTimeout, \
	L_OP_wait, \
	L_OP_gotoix, \
	L_OP_popCommitJoin, \
	L_OP_save, \
	L_OP_arith_plus, \
	L_OP_arith_minus, \
	L_OP_arith_times, \
	L_OP_arith_div, \
	L_OP_arith_intdiv, \
	L_OP_arith_band, \
	L_OP_arith_bor, \
	L_OP_arith_bxor, \
	L_OP_arith_bnot, \
	L_OP_arith_bsl, \
	L_OP_arith_bsr, \
	L_OP_arith_rem, \
	L_OP_comp_gt, \
	L_OP_comp_lt, \
	L_OP_comp_geq, \
	L_OP_comp_leq, \
	L_OP_pushIntN, \
	L_OP_getIntN, \
	L_OP_exact_eqeq, \
	L_OP_exact_neq, \
	L_OP_test_integer, \
	L_OP_test_float, \
	L_OP_test_number, \
	L_OP_test_atom, \
	L_OP_test_constant, \
	L_OP_test_list, \
	L_OP_test_tuple, \
	L_OP_test_pid, \
	L_OP_test_reference, \
	L_OP_test_port, \
	L_OP_stack_need, \
	L_OP_heap_need, \
	L_OP_comp_eqeq, \
	L_OP_comp_neq, \
	L_OP_debug_info, \
	L_OP_failFunction, \
	L_OP_test_binary, \
	L_OP_try_me_else, \
	L_OP_goto, \
	L_OP_call_local, \
	L_OP_enter_local, \
	L_OP_pushCatch, \
	L_OP_wait1, \
	L_OP_pushInt4, \
	L_OP_getInt4, \
	L_OP_arith_neg, \
	L_OP_apply_enter, \
	L_OP_apply_call, \
	L_OP_bif_enter, \
	L_OP_bif_call, \
	L_OP_die; \
    static const void *jmptab[256] = { \
	&&L_OP_dummy, \
	&&L_OP_pushVar_0, \
	&&L_OP_pushVar_1, \
	&&L_OP_pushVar_2, \
	&&L_OP_pushVar_3, \
	&&L_OP_pushVar_4, \
	&&L_OP_pushVar_5, \
	&&L_OP_pushVar_6, \
	&&L_OP_pushVar_7, \
	&&L_OP_pushVar_8, \
	&&L_OP_pushVar_9, \
	&&L_OP_pushVar_10, \
	&&L_OP_pushVar_11, \
	&&L_OP_pushVar_12, \
	&&L_OP_pushVar_13, \
	&&L_OP_pushVar_14, \
	&&L_OP_pushVar_15, \
	&&L_OP_pushVarN, \
	&&L_OP_storeVar_0, \
	&&L_OP_storeVar_1, \
	&&L_OP_storeVar_2, \
	&&L_OP_storeVar_3, \
	&&L_OP_storeVar_4, \
	&&L_OP_storeVar_5, \
	&&L_OP_storeVar_6, \
	&&L_OP_storeVar_7, \
	&&L_OP_storeVar_8, \
	&&L_OP_storeVar_9, \
	&&L_OP_storeVar_10, \
	&&L_OP_storeVar_11, \
	&&L_OP_storeVar_12, \
	&&L_OP_storeVar_13, \
	&&L_OP_storeVar_14, \
	&&L_OP_storeVar_15, \
	&&L_OP_storeVarN, \
	&&L_OP_alloc_0, \
	&&L_OP_alloc_1, \
	&&L_OP_alloc_2, \
	&&L_OP_alloc_3, \
	&&L_OP_alloc_4, \
	&&L_OP_alloc_5, \
	&&L_OP_alloc_6, \
	&&L_OP_alloc_7, \
	&&L_OP_alloc_8, \
	&&L_OP_alloc_9, \
	&&L_OP_alloc_10, \
	&&L_OP_alloc_11, \
	&&L_OP_alloc_12, \
	&&L_OP_alloc_13, \
	&&L_OP_alloc_14, \
	&&L_OP_alloc_15, \
	&&L_OP_allocN, \
	&&L_OP_eqVar_0, \
	&&L_OP_eqVar_1, \
	&&L_OP_eqVar_2, \
	&&L_OP_eqVar_3, \
	&&L_OP_eqVar_4, \
	&&L_OP_eqVar_5, \
	&&L_OP_eqVar_6, \
	&&L_OP_eqVar_7, \
	&&L_OP_eqVar_8, \
	&&L_OP_eqVar_9, \
	&&L_OP_eqVar_10, \
	&&L_OP_eqVar_11, \
	&&L_OP_eqVar_12, \
	&&L_OP_eqVar_13, \
	&&L_OP_eqVar_14, \
	&&L_OP_eqVar_15, \
	&&L_OP_eqVarN, \
	&&L_OP_eqArg_0, \
	&&L_OP_eqArg_1, \
	&&L_OP_eqArg_2, \
	&&L_OP_eqArg_3, \
	&&L_OP_eqArg_4, \
	&&L_OP_eqArg_5, \
	&&L_OP_eqArg_6, \
	&&L_OP_eqArg_7, \
	&&L_OP_eqArg_8, \
	&&L_OP_eqArg_9, \
	&&L_OP_eqArg_10, \
	&&L_OP_eqArg_11, \
	&&L_OP_eqArg_12, \
	&&L_OP_eqArg_13, \
	&&L_OP_eqArg_14, \
	&&L_OP_eqArg_15, \
	&&L_OP_eqArgN, \
	&&L_OP_arg_0, \
	&&L_OP_arg_1, \
	&&L_OP_arg_2, \
	&&L_OP_arg_3, \
	&&L_OP_arg_4, \
	&&L_OP_arg_5, \
	&&L_OP_arg_6, \
	&&L_OP_arg_7, \
	&&L_OP_arg_8, \
	&&L_OP_arg_9, \
	&&L_OP_arg_10, \
	&&L_OP_arg_11, \
	&&L_OP_arg_12, \
	&&L_OP_arg_13, \
	&&L_OP_arg_14, \
	&&L_OP_arg_15, \
	&&L_OP_argN, \
	&&L_OP_unpkTuple_0, \
	&&L_OP_unpkTuple_1, \
	&&L_OP_unpkTuple_2, \
	&&L_OP_unpkTuple_3, \
	&&L_OP_unpkTuple_4, \
	&&L_OP_unpkTuple_5, \
	&&L_OP_unpkTuple_6, \
	&&L_OP_unpkTuple_7, \
	&&L_OP_unpkTuple_8, \
	&&L_OP_unpkTuple_9, \
	&&L_OP_unpkTuple_10, \
	&&L_OP_unpkTuple_11, \
	&&L_OP_unpkTuple_12, \
	&&L_OP_unpkTuple_13, \
	&&L_OP_unpkTuple_14, \
	&&L_OP_unpkTuple_15, \
	&&L_OP_unpkTupleN, \
	&&L_OP_mkTuple_0, \
	&&L_OP_mkTuple_1, \
	&&L_OP_mkTuple_2, \
	&&L_OP_mkTuple_3, \
	&&L_OP_mkTuple_4, \
	&&L_OP_mkTuple_5, \
	&&L_OP_mkTuple_6, \
	&&L_OP_mkTuple_7, \
	&&L_OP_mkTuple_8, \
	&&L_OP_mkTuple_9, \
	&&L_OP_mkTuple_10, \
	&&L_OP_mkTuple_11, \
	&&L_OP_mkTuple_12, \
	&&L_OP_mkTuple_13, \
	&&L_OP_mkTuple_14, \
	&&L_OP_mkTuple_15, \
	&&L_OP_mkTupleN, \
	&&L_OP_getInt_0, \
	&&L_OP_getInt_1, \
	&&L_OP_getInt_2, \
	&&L_OP_getInt_3, \
	&&L_OP_getInt_4, \
	&&L_OP_getInt_5, \
	&&L_OP_getInt_6, \
	&&L_OP_getInt_7, \
	&&L_OP_getInt_8, \
	&&L_OP_getInt_9, \
	&&L_OP_getInt_10, \
	&&L_OP_getInt_11, \
	&&L_OP_getInt_12, \
	&&L_OP_getInt_13, \
	&&L_OP_getInt_14, \
	&&L_OP_getInt_15, \
	&&L_OP_getInt1, \
	&&L_OP_hash, \
	&&L_OP_getFloat, \
	&&L_OP_pushInt_0, \
	&&L_OP_pushInt_1, \
	&&L_OP_pushInt_2, \
	&&L_OP_pushInt_3, \
	&&L_OP_pushInt_4, \
	&&L_OP_pushInt_5, \
	&&L_OP_pushInt_6, \
	&&L_OP_pushInt_7, \
	&&L_OP_pushInt_8, \
	&&L_OP_pushInt_9, \
	&&L_OP_pushInt_10, \
	&&L_OP_pushInt_11, \
	&&L_OP_pushInt_12, \
	&&L_OP_pushInt_13, \
	&&L_OP_pushInt_14, \
	&&L_OP_pushInt_15, \
	&&L_OP_pushInt1, \
	&&L_OP_type, \
	&&L_OP_pushFloat, \
	&&L_OP_nodebug_info, \
	&&L_OP_list_length, \
	&&L_OP_getAtom, \
	&&L_OP_try_me_else_fail, \
	&&L_OP_commit, \
	&&L_OP_ret, \
	&&L_OP_getNil, \
	&&L_OP_pushNil, \
	&&L_OP_pop, \
	&&L_OP_mkList, \
	&&L_OP_unpkList, \
	&&L_OP_send, \
	&&L_OP_self, \
	&&L_OP_pushStr, \
	&&L_OP_pushAtom, \
	&&L_OP_getStr, \
	&&L_OP_call_remote, \
	&&L_OP_head, \
	&&L_OP_enter_remote, \
	&&L_OP_dup, \
	&&L_OP_popCommit, \
	&&L_OP_failIf, \
	&&L_OP_failCase, \
	&&L_OP_tail, \
	&&L_OP_popCatch, \
	&&L_OP_setTimeout, \
	&&L_OP_wait, \
	&&L_OP_gotoix, \
	&&L_OP_popCommitJoin, \
	&&L_OP_save, \
	&&L_OP_arith_plus, \
	&&L_OP_arith_minus, \
	&&L_OP_arith_times, \
	&&L_OP_arith_div, \
	&&L_OP_arith_intdiv, \
	&&L_OP_arith_band, \
	&&L_OP_arith_bor, \
	&&L_OP_arith_bxor, \
	&&L_OP_arith_bnot, \
	&&L_OP_arith_bsl, \
	&&L_OP_arith_bsr, \
	&&L_OP_arith_rem, \
	&&L_OP_comp_gt, \
	&&L_OP_comp_lt, \
	&&L_OP_comp_geq, \
	&&L_OP_comp_leq, \
	&&L_OP_pushIntN, \
	&&L_OP_getIntN, \
	&&L_OP_exact_eqeq, \
	&&L_OP_exact_neq, \
	&&L_OP_test_integer, \
	&&L_OP_test_float, \
	&&L_OP_test_number, \
	&&L_OP_test_atom, \
	&&L_OP_test_constant, \
	&&L_OP_test_list, \
	&&L_OP_test_tuple, \
	&&L_OP_test_pid, \
	&&L_OP_test_reference, \
	&&L_OP_test_port, \
	&&L_OP_stack_need, \
	&&L_OP_heap_need, \
	&&L_OP_comp_eqeq, \
	&&L_OP_comp_neq, \
	&&L_OP_debug_info, \
	&&L_OP_failFunction, \
	&&L_OP_test_binary, \
	&&L_OP_try_me_else, \
	&&L_OP_goto, \
	&&L_OP_call_local, \
	&&L_OP_enter_local, \
	&&L_OP_pushCatch, \
	&&L_OP_wait1, \
	&&L_OP_pushInt4, \
	&&L_OP_getInt4, \
	&&L_OP_arith_neg, \
	&&L_OP_apply_enter, \
	&&L_OP_apply_call, \
	&&L_OP_bif_enter, \
	&&L_OP_bif_call, \
	&&L_OP_die }; \
    register const void** jmptabp = jmptab;
#else
#define DECL_JMPTAB
#endif

#if defined(OPTRACE) || defined(OPPROF)

struct op_entry {
    char *name;  /* instruction name */
    int  count;  /* bump count */
};

#define DECL_OP_TABLE struct op_entry opc[256] = { \
    {"notused", 0}, \
    {"pushVar_0", 0}, \
    {"pushVar_1", 0}, \
    {"pushVar_2", 0}, \
    {"pushVar_3", 0}, \
    {"pushVar_4", 0}, \
    {"pushVar_5", 0}, \
    {"pushVar_6", 0}, \
    {"pushVar_7", 0}, \
    {"pushVar_8", 0}, \
    {"pushVar_9", 0}, \
    {"pushVar_10", 0}, \
    {"pushVar_11", 0}, \
    {"pushVar_12", 0}, \
    {"pushVar_13", 0}, \
    {"pushVar_14", 0}, \
    {"pushVar_15", 0}, \
    {"pushVarN", 0}, \
    {"storeVar_0", 0}, \
    {"storeVar_1", 0}, \
    {"storeVar_2", 0}, \
    {"storeVar_3", 0}, \
    {"storeVar_4", 0}, \
    {"storeVar_5", 0}, \
    {"storeVar_6", 0}, \
    {"storeVar_7", 0}, \
    {"storeVar_8", 0}, \
    {"storeVar_9", 0}, \
    {"storeVar_10", 0}, \
    {"storeVar_11", 0}, \
    {"storeVar_12", 0}, \
    {"storeVar_13", 0}, \
    {"storeVar_14", 0}, \
    {"storeVar_15", 0}, \
    {"storeVarN", 0}, \
    {"alloc_0", 0}, \
    {"alloc_1", 0}, \
    {"alloc_2", 0}, \
    {"alloc_3", 0}, \
    {"alloc_4", 0}, \
    {"alloc_5", 0}, \
    {"alloc_6", 0}, \
    {"alloc_7", 0}, \
    {"alloc_8", 0}, \
    {"alloc_9", 0}, \
    {"alloc_10", 0}, \
    {"alloc_11", 0}, \
    {"alloc_12", 0}, \
    {"alloc_13", 0}, \
    {"alloc_14", 0}, \
    {"alloc_15", 0}, \
    {"allocN", 0}, \
    {"eqVar_0", 0}, \
    {"eqVar_1", 0}, \
    {"eqVar_2", 0}, \
    {"eqVar_3", 0}, \
    {"eqVar_4", 0}, \
    {"eqVar_5", 0}, \
    {"eqVar_6", 0}, \
    {"eqVar_7", 0}, \
    {"eqVar_8", 0}, \
    {"eqVar_9", 0}, \
    {"eqVar_10", 0}, \
    {"eqVar_11", 0}, \
    {"eqVar_12", 0}, \
    {"eqVar_13", 0}, \
    {"eqVar_14", 0}, \
    {"eqVar_15", 0}, \
    {"eqVarN", 0}, \
    {"eqArg_0", 0}, \
    {"eqArg_1", 0}, \
    {"eqArg_2", 0}, \
    {"eqArg_3", 0}, \
    {"eqArg_4", 0}, \
    {"eqArg_5", 0}, \
    {"eqArg_6", 0}, \
    {"eqArg_7", 0}, \
    {"eqArg_8", 0}, \
    {"eqArg_9", 0}, \
    {"eqArg_10", 0}, \
    {"eqArg_11", 0}, \
    {"eqArg_12", 0}, \
    {"eqArg_13", 0}, \
    {"eqArg_14", 0}, \
    {"eqArg_15", 0}, \
    {"eqArgN", 0}, \
    {"arg_0", 0}, \
    {"arg_1", 0}, \
    {"arg_2", 0}, \
    {"arg_3", 0}, \
    {"arg_4", 0}, \
    {"arg_5", 0}, \
    {"arg_6", 0}, \
    {"arg_7", 0}, \
    {"arg_8", 0}, \
    {"arg_9", 0}, \
    {"arg_10", 0}, \
    {"arg_11", 0}, \
    {"arg_12", 0}, \
    {"arg_13", 0}, \
    {"arg_14", 0}, \
    {"arg_15", 0}, \
    {"argN", 0}, \
    {"unpkTuple_0", 0}, \
    {"unpkTuple_1", 0}, \
    {"unpkTuple_2", 0}, \
    {"unpkTuple_3", 0}, \
    {"unpkTuple_4", 0}, \
    {"unpkTuple_5", 0}, \
    {"unpkTuple_6", 0}, \
    {"unpkTuple_7", 0}, \
    {"unpkTuple_8", 0}, \
    {"unpkTuple_9", 0}, \
    {"unpkTuple_10", 0}, \
    {"unpkTuple_11", 0}, \
    {"unpkTuple_12", 0}, \
    {"unpkTuple_13", 0}, \
    {"unpkTuple_14", 0}, \
    {"unpkTuple_15", 0}, \
    {"unpkTupleN", 0}, \
    {"mkTuple_0", 0}, \
    {"mkTuple_1", 0}, \
    {"mkTuple_2", 0}, \
    {"mkTuple_3", 0}, \
    {"mkTuple_4", 0}, \
    {"mkTuple_5", 0}, \
    {"mkTuple_6", 0}, \
    {"mkTuple_7", 0}, \
    {"mkTuple_8", 0}, \
    {"mkTuple_9", 0}, \
    {"mkTuple_10", 0}, \
    {"mkTuple_11", 0}, \
    {"mkTuple_12", 0}, \
    {"mkTuple_13", 0}, \
    {"mkTuple_14", 0}, \
    {"mkTuple_15", 0}, \
    {"mkTupleN", 0}, \
    {"getInt_0", 0}, \
    {"getInt_1", 0}, \
    {"getInt_2", 0}, \
    {"getInt_3", 0}, \
    {"getInt_4", 0}, \
    {"getInt_5", 0}, \
    {"getInt_6", 0}, \
    {"getInt_7", 0}, \
    {"getInt_8", 0}, \
    {"getInt_9", 0}, \
    {"getInt_10", 0}, \
    {"getInt_11", 0}, \
    {"getInt_12", 0}, \
    {"getInt_13", 0}, \
    {"getInt_14", 0}, \
    {"getInt_15", 0}, \
    {"getInt1", 0}, \
    {"hash", 0}, \
    {"getFloat", 0}, \
    {"pushInt_0", 0}, \
    {"pushInt_1", 0}, \
    {"pushInt_2", 0}, \
    {"pushInt_3", 0}, \
    {"pushInt_4", 0}, \
    {"pushInt_5", 0}, \
    {"pushInt_6", 0}, \
    {"pushInt_7", 0}, \
    {"pushInt_8", 0}, \
    {"pushInt_9", 0}, \
    {"pushInt_10", 0}, \
    {"pushInt_11", 0}, \
    {"pushInt_12", 0}, \
    {"pushInt_13", 0}, \
    {"pushInt_14", 0}, \
    {"pushInt_15", 0}, \
    {"pushInt1", 0}, \
    {"type", 0}, \
    {"pushFloat", 0}, \
    {"info", 0}, \
    {"list_length", 0}, \
    {"getAtom", 0}, \
    {"try_me_else_fail", 0}, \
    {"commit", 0}, \
    {"ret", 0}, \
    {"getNil", 0}, \
    {"pushNil", 0}, \
    {"pop", 0}, \
    {"mkList", 0}, \
    {"unpkList", 0}, \
    {"send", 0}, \
    {"self", 0}, \
    {"pushStr", 0}, \
    {"pushAtom", 0}, \
    {"getStr", 0}, \
    {"call_remote", 0}, \
    {"head", 0}, \
    {"enter_remote", 0}, \
    {"dup", 0}, \
    {"popCommit", 0}, \
    {"failIf", 0}, \
    {"failCase", 0}, \
    {"tail", 0}, \
    {"popCatch", 0}, \
    {"setTimeout", 0}, \
    {"wait", 0}, \
    {"gotoix", 0}, \
    {"popCommitJoin", 0}, \
    {"save", 0}, \
    {"arith_plus", 0}, \
    {"arith_minus", 0}, \
    {"arith_times", 0}, \
    {"arith_div", 0}, \
    {"arith_intdiv", 0}, \
    {"arith_band", 0}, \
    {"arith_bor", 0}, \
    {"arith_bxor", 0}, \
    {"arith_bnot", 0}, \
    {"arith_bsl", 0}, \
    {"arith_bsr", 0}, \
    {"arith_rem", 0}, \
    {"comp_gt", 0}, \
    {"comp_lt", 0}, \
    {"comp_geq", 0}, \
    {"comp_leq", 0}, \
    {"pushIntN", 0}, \
    {"getIntN", 0}, \
    {"exact_eqeq", 0}, \
    {"exact_neq", 0}, \
    {"test_integer", 0}, \
    {"test_float", 0}, \
    {"test_number", 0}, \
    {"test_atom", 0}, \
    {"test_constant", 0}, \
    {"test_list", 0}, \
    {"test_tuple", 0}, \
    {"test_pid", 0}, \
    {"test_reference", 0}, \
    {"test_port", 0}, \
    {"stack_need", 0}, \
    {"heap_need", 0}, \
    {"comp_eqeq", 0}, \
    {"comp_neq", 0}, \
    {"debug_info", 0}, \
    {"failFunction", 0}, \
    {"test_binary", 0}, \
    {"try_me_else", 0}, \
    {"goto", 0}, \
    {"call_local", 0}, \
    {"enter_local", 0}, \
    {"pushCatch", 0}, \
    {"wait1", 0}, \
    {"pushInt4", 0}, \
    {"getInt4", 0}, \
    {"arith_neg", 0}, \
    {"apply_enter", 0}, \
    {"apply_call", 0}, \
    {"bif_enter", 0}, \
    {"bif_call", 0}, \
    {"die", 0} };
extern struct op_entry opc[256];

#else

#define DECL_OP_TABLE

#endif


#endif
