/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* Copyright (C) 1993, Ellemtel Telecommunications Systems Laboratories */
/* Author: Claes Wikstrom  klacke@erix.ericsson.se */
/* Purpose:    Multidriver interface 
   This is an example of a driver which allows multiple instances of itself.
   I.e have one erlang process execute open_port(multi......) and
   at the same time have an other erlang process open an other port 
   running multi there as well.
*/


#include "driver.h"
#include "sys.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAXCHANNEL 20

static char buf[BUFSIZ];

static long multi_start();
static int multi_init(),multi_stop(),multi_erlang_read();

struct driver_entry multi_driver_entry = {
    multi_init,multi_start,multi_stop,multi_erlang_read,
    null_func,null_func,"multi"
    };


struct channel {
    int portno;
    int channel;
};

struct channel channels[MAXCHANNEL]; /* Max MAXCHANNEL instances */




static int multi_init()
{
    memzero(channels,MAXCHANNEL * sizeof(struct channel));
}


static long multi_start(port,buf) 
int port;
char *buf;
{

    int chan;
    chan = get_new_channel();
    channels[port].portno = port;
    channels[port].channel = chan;
    fprintf(stderr,"Opening channel %d port is %d\n",chan,port);
    return(port);
}


static int multi_stop(port)
int port;
{
    fprintf(stderr,"Closing channel %d\n",channels[port].channel);
    remove_channel(channels[port].channel);
}

 
static int multi_erlang_read(port,buf,count)
long port;
char *buf;
int count;

{
    fprintf(stderr,"Writing %d bytes to channel %d\n",
	    count,
	    channels[port].channel);
}



/* These two funs are fake */

get_new_channel() 
{
    static int ch = 1;
    
    return(ch++);
}

remove_channel(ch)
int ch;
{
    return;
}
