/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
/* Copyright (C) 1997, Ericsson Telecom */

/* 
 * Interface functions for the Windows dynamic loader.
 */
#include <windows.h>

#include "sys.h"
#include "config.h"
#include "erl_ddll.h"

#define EXT_LEN          4
#define FILE_EXT         ".dll"


/* XXX The ddll driver is single threaded */
static int dl_error;
static int dlopen_error;

#define ERL_DLERR_NAME_TO_LONG  1
#define ERL_DLERR_SYM_NOT_FOUND 2
#define ERL_DLERR_BAD_VERSION   3

#define APIINITSYM       "_ERL__DRIVER_INIT"

/* 
 * Open a shared object
 */
void *ddll_open(full_name)
    char *full_name;
{
    HINSTANCE handle;
    char* name;
    int len;
    char dlname[MAXPATHLEN + EXT_LEN + 1];

    dlopen_error = 0;
    name = full_name;

    if ((len = sys_strlen(name)) > MAXPATHLEN-EXT_LEN-1) {
	dlopen_error = ERL_DLERR_NAME_TO_LONG;
	return NULL;
    }
    sys_strcpy(dlname, name);
    sys_strcpy(dlname+len, FILE_EXT);

    if ((handle = LoadLibrary(dlname)) == NULL) {
	dl_error = GetLastError();
	return NULL;
    }

    return handle;
}

/* 
 * Find a symbol in the shared object
 */
uint32 *ddll_sym(handle, func_name)
    void *handle;
    char *func_name;
{
    return (uint32*) GetProcAddress((HINSTANCE) handle, func_name);
}

/* 
 * Close a chared object
 */
int ddll_close(handle)
    void *handle;
{
    FreeLibrary((HINSTANCE) handle);
    return 0;
}

/*
 * Return string that describes the (current) error
 */
char *ddll_error()
{
    if (dlopen_error) {
	switch(dlopen_error) {
	case ERL_DLERR_NAME_TO_LONG:
	    return "name to long";
	case ERL_DLERR_SYM_NOT_FOUND:
	    return "bad driver (link with erl_dll.lib)";
	case ERL_DLERR_BAD_VERSION:
	    return "bad driver version (recompile)";
	default:
	    return "unknown error";
	}
    }
    return win32_errorstr(dl_error);
}
