%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% File    : jam_yecc_pj.erl
%% Author  : Robert Virding
%% Purpose : A parse transform for improving Yecc generated code for the JAM!

-module(jam_yecc_pj).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').

-export([parse_transform/2]).

-define(shift, 4).
-define(mask, 16#f).

parse_transform(Forms, Opts) ->
    forms(Forms).

forms([{function,L,yeccpars2,7,Cs}|Fs]) ->
    Yp2_7 = yp2_7(L),
    Yp2_8 = {function,L,yeccpars2,8,yp_clauses(Cs)},
    [Yp2_7,Yp2_8|forms(Fs)];
forms([F|Fs]) ->
    [F|forms(Fs)];
forms([]) -> [].

yp2_7(L) ->
    As = [ {var,L,list_to_atom("___" ++ integer_to_list(A))} ||
	     A <- [1,2,3,4,5,6,7] ],
    C = {clause,L,As,[],
	 [{call,L,{atom,L,yeccpars2},
	   [{op,L,'bsr',hd(As),{integer,L,?shift}},
	    {op,L,'band',hd(As),{integer,L,?mask}}|tl(As)]}]},
    {function,L,yeccpars2,7,[C]}.

yp_clauses([{clause,Lc,[{integer,Li,I}|As],G,B}|Cs]) ->
    [{clause,Lc,[{integer,Li,I bsr ?shift},{integer,Li,I band ?mask}|As],G,B}|
     yp_clauses(Cs)];
yp_clauses([{clause,Lc,[{var,Lv,V}|As],G,B}|Cs]) ->
    Vl = atom_to_list(V),
    V1 = {var,Lv,list_to_atom(Vl ++ "_1")},
    V2 = {var,Lv,list_to_atom(Vl ++ "_2")},
    [{clause,Lc,[V1,V2|As],G,
      [{match,Lv,{var,Lv,V},
	{op,Lv,'bor',{op,Lv,'bsl',V1,{integer,Lv,?shift}},V2}}|B]}|
     yp_clauses(Cs)];
yp_clauses([]) -> [].
