/* 
   listbox.h [2000-11-5]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef LISTBOX_H
#define LISTBOX_H

#include <SDL.h>

struct _ListBox;
typedef struct _ListBox LISTBOX;

extern LISTBOX *ListBox(Sint16 x, Sint16 y, Uint16 max_w, Uint16 max_h, int margin, int showFocus);
extern int addListBoxItem(LISTBOX *lb, char *text1, char *text2);
extern int initListBox(LISTBOX *lb, SDL_Surface *surface);
extern int handleListBoxEvent(SDL_Event *event, LISTBOX *lb, SDL_Surface *surface);
extern int ListBoxFocusItem(LISTBOX *lb);
extern void setListBoxFocusItem(LISTBOX *lb, int focus);
extern void cleanupListBox(LISTBOX *lb);
extern void setListBoxSizes(LISTBOX *lb);
extern void drawListBox(LISTBOX *lb, SDL_Surface *surface);
extern void deleteListBox(LISTBOX *lb);

#endif
