/* 
   controlbar.h [2000-10-8]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef CONTROLBAR_H
#define CONTROLBAR_H

#include <SDL.h>
#include <SDL_thread.h>

#define PLAY	1
#define STOP	2
#define FULL	3
#define QUIT	4
#define FOLDER	5
#define INFO	6
#define PREF	7

#define MAX_BUTTONS 8

#define SEEK	10

extern int setupControlbar(SDL_Surface *surface, SDL_mutex *surflock, int pause);
extern int resizeControlbar(SDL_Surface *newSurface, int isvisible);
extern int controlButtonPressed(Uint16 x, Uint16 y);
extern int controlButtonReleased(Uint16 x, Uint16 y);
extern void resetButtons();
extern void showControlbar();

extern int slideButtonPressed(Uint16 x, Uint16 y);
extern int updateSlideButton(Uint16 x);
extern int setSlideButton(float percent);
extern float calcSlideOffset(Uint32 total, Uint32 current);
extern float currentSlideOffset();

#endif
