---------------------------
-- initialize level list --
---------------------------
levellist = {
--    {"a",""},
--    {"test",        "Test Landscape"},
    {"welcome",     "Welcome to Enigma"},
    {"sesame",      "Open Sesame"},
    {"lasers101",   "Lasers 101"},
    {"deadend",     "The Dead End"},
    {"space",       "Space Odyssey"},
    {"mirrors",     "Room of Mirrors"},
--    {"new",         "This one is new"},
}

enigma.ClearLevelList()
for i,level in levellist do
    enigma.AddLevel(level[1], level[2])
end


----------------------
-- Global variables --
----------------------

level_width = 0
level_height = 0

oxyd_default_flavor = "b"       -- Default flavor for oxyd stones.
oxyd_count = 0
oxyd_current_color = 0

---------------
-- Functions --
---------------

function create_world(w, h)
    oxyd_default_flavor = "b"
    oxyd_count = 0
    oxyd_current_color = 0

    level_width = w
    level_height = h
    enigma.CreateWorld("", w, h)
end

function set_attrib(obj, key,val)
    if key == "name" then
        enigma.NameObject(obj, val)
    else
        enigma.SetAttrib(obj, key, val)
    end
end

function set_attribs(obj, attrs)
    if not attrs then return end
    for key,val in attrs do
	set_attrib(obj, key, val)
    end
end

function make_object(name, attrs)
    local obj = enigma.MakeObject(name)
    set_attribs(obj, attrs)
    return obj
end


function set_floor(name, x, y, attrs)
    local obj = make_object(name, attrs)
    enigma.SetFloor(x,y,obj)
    return obj
end
function set_item(name, x, y, attrs)
    local obj = make_object(name, attrs)
    enigma.SetItem(x,y,obj)
    return obj
end
function set_stone(name, x,y, attrs)
    local obj=make_object(name, attrs)
    enigma.SetStone(x,y,obj)
    return obj
end

function fill_floor(name, x0,y0, w,h)
    for y=y0,y0+h-1 do
	for x=x0,x0+w-1 do
	    set_floor(name, x, y)
	end
    end
end

function draw_floor(name, xy0, xystep, n, attrs)
    local x,y = xy0[1],xy0[2]
    for i=1,n do
	set_floor(name, x, y, attrs)
	x = x+xystep[1]
	y = y+xystep[2]
    end
end
             
function draw_items(name, xy0, xystep, n, attrs)
    local x,y = xy0[1],xy0[2]
    for i=1,n do
	set_item(name, x, y, attrs)
	x = x+xystep[1]
	y = y+xystep[2]
    end
end

function draw_stones(name, xy0, xystep, n, attrs)
    local x,y = xy0[1],xy0[2]
    for i=1,n do
	set_stone(name, x, y, attrs)
	x = x+xystep[1]
	y = y+xystep[2]
    end
end

function draw_border(stonename)
    draw_stones(stonename, {0,0}, {1,0}, level_width)
    draw_stones(stonename, {0,level_height-1},{1,0}, level_width)
    draw_stones(stonename, {0,0}, {0,1}, level_height)
    draw_stones(stonename, {level_width-1,0},{0,1}, level_height)
end

function set_stones(name, poslist, attrs)
    for i,xy in poslist do
	set_stone(name, xy[1], xy[2], attrs)
    end
end

function set_actor(name, x, y, attrs)
    local obj=make_object(name, attrs)
    enigma.SetActor(x, y,obj)
    return obj
end

---------------------------------------------
-- Creation of particular kinds of objects --
---------------------------------------------
function fakeoxyd(x,y) set_stone("st-fakeoxyd",x,y) end


-- Create an oxyd stone with the current default flavor.
function oxyd(x,y)
    set_stone("st-oxyd",x,y, {flavor=oxyd_default_flavor, 
                color=""..oxyd_current_color})
    oxyd_count = oxyd_count +1
    if oxyd_count == 2 then
        oxyd_count = 0
        oxyd_current_color = oxyd_current_color + 1
    end
end

-- shuffle the colors of all oxyd stones in the world
function oxyd_shuffle()

end

function oneway(x,y,orient)
    return set_stone("st-oneway",x,y,{orientation=orient})
end
function laser(x,y,ison,dir)
    return set_stone("st-laser",x,y,{on=ison, dir=dir})
end

function mirrorp(x,y,movable, transp,orient)
    return set_stone("st-pmirror", x, y, {movable=movable, transparent=transp,
                         orientation=orient})
end
function mirror3(x,y,movable, transp, orient)
    return set_stone("st-3mirror", x, y, {movable=movable, transparent=transp,
                         orientation = orient})
end

PUZ_0000=1
PUZ_0001=2
PUZ_0010=3
PUZ_0011=4
PUZ_0100=5
PUZ_0101=6
PUZ_0110=7
PUZ_0111=8
PUZ_1000=9
PUZ_1001=10
PUZ_1010=11
PUZ_1011=12
PUZ_1100=13
PUZ_1101=14
PUZ_1110=15
PUZ_1111=16

function puzzle(x, y, conn)
    set_stone("st-puzzle", x,y, {connections=conn})
end
function switch(x,y,target,action)
    set_stone("st-switch", x,y, {target=target, action=action})
end


function abyss(x,y) set_floor("fl-abyss",x,y) end


-----------
-- ITEMS --
-----------
function document(x,y,t) set_item("it-document", x, y, {text=t}) end
function hammer(x,y) set_item("it-hammer",x,y) end
function dynamite(x,y) set_item("it-dynamite",x,y) end
function bomb(x,y) set_item("it-blackbomb",x,y) end
function shogundot(x,y,size,attrs) 
    if attrs==nil then attrs={} end
    attrs.size = size
    set_item("it-shogun", x, y, attrs)
end

function shogundot1(x,y,attrs) shogundot(x,y,1,attrs) end
function shogundot2(x,y,attrs) shogundot(x,y,2,attrs) end
function shogundot3(x,y,attrs) shogundot(x,y,3,attrs) end

function doorh(x,y,attrs) 
    attrs = attrs or {}
    attrs.type="h"
    set_stone("st-door",x,y,attrs)
end
function doorv(x,y,attrs) 
    attrs = attrs or {}
    attrs.type="v"
    set_stone("st-door",x,y,attrs)
end



EAST = enigma.EAST
NORTH = enigma.NORTH
SOUTH = enigma.SOUTH
WEST = enigma.WEST
TRUE = 1
FALSE = 0