//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================

#include "editor.hh"
#include "world.hh"
#include <iostream>

using namespace std;
using enigma::GridPos;

namespace
{
    class Action {
    public:
        void perform() { on_perform(); }
        void undo() { on_undo(); }
    private:
        virtual void on_perform() = 0;
        virtual void on_undo() = 0;
    };

    class Creator {
    public:
        virtual ~Creator() {}
        virtual void emit_code(ostream &os) = 0;
    };

    class StoneCreator : public Creator {
    public:
    private:
        void emit_code(ostream &os) {
            os << "set_stone(\"" << kind 
               << "\"," << pos.x << ","<<pos.y<<")\n";
        }
        string kind;
        GridPos pos;
    };
}

void
editor::EditLevel(const string &name)
{
}
