/*
 *  Emi Clock $B!=(B $B2hA|=hM}(B
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/Intrinsic.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B */
#include <X11/StringDefs.h>		/* $BI8=`%j%=!<%9J8;zNs$NDj5A(B */

/* 64bit $B%"!<%-%F%/%A%c$KBP1~$5$;$k$?$aI,MW$J%X%C%@!<(B */
#include <X11/Xmd.h>			/* $B%^%7%s8GM-CM$NDj5A(B */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdlib.h>			/* $BI8=`%i%$%V%i%j(B */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */

/* RCS ID */
rcsId(gengineId, "$Id: gengine.c,v 1.3 1999/09/26 16:18:18 koba Exp $")

/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
static void UncompressPixel __P((XImage *, PixelImage *));


/*
 *  PixelImage $B$r(B X11 $B$N(B XImage $B$KJQ49$9$k%k!<%A%s(B
 */
XImage *
PImage2XImage(w, cmap, pImage, appPixelTable, pixels, npixels,
					isGrayscale, isGray4, isPerfect)
    Widget		w;
    Colormap		cmap;
    PixelImage		*pImage;
    int			*appPixelTable;
    AllocPixel		*pixels;
    int			*npixels;
    Boolean		isGrayscale, isGray4, isPerfect;
{
    Cardinal		depth;
    Pixel		backgroundPixel;
    XImage		*image;
    XColor		*colorTable;
    Boolean		*isTransparentPixel;
    int			index, i;
    CARD8		paletteIndex;
    int			isAllocColorFailure = False;
    int			numOfCmapColors;
    XColor		queryColorTable[PIXELS_8];
    int			zDepth, imageWidth;
    int			pixelSize, padding;
    int			x, y;

    XtVaGetValues(w,
		XtNdepth,	&depth,
		XtNbackground,	&backgroundPixel,
		NULL);

    if (depth <= 8) {
	zDepth = 8;
	imageWidth = pImage->width;
    } else {
	zDepth = 32;
	imageWidth = 0;
    }

    image = XCreateImage(XtDisplay(w),
		DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		depth,					/* depth */
		ZPixmap,				/* format */
		0,					/* offset */
		None,					/* data */
		pImage->width,				/* width */
		pImage->height,				/* height */
		zDepth,					/* bitmap_pad */
		imageWidth);				/* bytes_per_line */
    if (image == NULL) {
	FatalError("Can't allocate memory for XImage.");
    }

    image->data = (char *)XtMalloc(image->bytes_per_line * pImage->height);

    /* $B05=L%T%/%;%k%$%a!<%8$NE83+(B */
    pixelSize = image->bytes_per_line / pImage->width;
    padding = image->bytes_per_line - (pImage->width * pixelSize);
    UncompressPixel(image, pImage);

    colorTable = (XColor *)XtMalloc(sizeof(XColor) * pImage->numOfPalettes);
    isTransparentPixel
	= (Boolean *)XtMalloc(sizeof(Boolean) * pImage->numOfPalettes);

    /* $B?'(B($B%+%i!<%;%k(B)$B$N3NJ](B */
    for (index = 0, *npixels = 0; index < pImage->numOfPalettes; index++) {
	colorTable[index].red = pImage->paletteColor[index * 3] << 8;
	colorTable[index].green = pImage->paletteColor[index * 3 + 1] << 8;
	colorTable[index].blue = pImage->paletteColor[index * 3 + 2] << 8;

	if ((colorTable[index].red +
	     colorTable[index].green + colorTable[index].blue) != 0) {

	    /* $BF)L@%T%/%;%k$G$O$J$$(B */

	    if (isGrayscale || isGray4) {
		unsigned long	grayvalue;
		int		split, i;

		grayvalue = (colorTable[index].red +
				colorTable[index].green +
				colorTable[index].blue) / 3;

		if (isGray4) {
		    split = 4;

		    /* 0$B!A(B65535 $B$NCM$r(B split $BJ,3d$9$k(B */
		    for (i = 0; i < split; i++) {
			if (grayvalue <= ((65535 * (i + 1)) / split)) {
			    grayvalue = (65535 * i) / (split - 1);
			    break;
			}
		    }
		}

		colorTable[index].red = grayvalue;
		colorTable[index].green = grayvalue;
		colorTable[index].blue = grayvalue;
	    }

	    if (XAllocColor(XtDisplay(w), cmap, &(colorTable[index])) == 0) {
		/* $B?'(B($B%+%i!<%;%k(B)$B$N3NJ]$K<:GT$7$?!*(B */
		long	distance, closedDistance;
		int	closedColor;
		int	redDistance, greenDistance, blueDistance;

		pixels[index].isAlloc = False;

		if (!isAllocColorFailure) {
		    /* $B%+%i!<%^%C%W>e$N?'$r<h$j=P$9(B */
		    int dCells = DisplayCells(XtDisplay(w),
						DefaultScreen(XtDisplay(w)));

		    numOfCmapColors = (dCells < PIXELS_8) ? dCells : PIXELS_8;

		    for (i = 0; i < numOfCmapColors; i++) {
			queryColorTable[i].pixel = (unsigned long)i;
		    }

		    XQueryColors(XtDisplay(w), cmap,
					queryColorTable, numOfCmapColors);
		    isAllocColorFailure = True;
		}

		/* $B%+%i!<%^%C%W$K$"$k:G$b6a$$?'$N%T%/%;%kCM$r;H$&(B */
		closedDistance = 255 * 255 * 3 + 1;
		closedColor = -1;
		for (i = 0; i < numOfCmapColors; i++) {
		    redDistance = pImage->paletteColor[index * 3] -
					(queryColorTable[i].red >> 8);
		    greenDistance = pImage->paletteColor[index * 3 + 1] -
					(queryColorTable[i].green >> 8);
		    blueDistance = pImage->paletteColor[index * 3 + 1] -
					(queryColorTable[i].blue >> 8);

		    distance = (redDistance * redDistance) +
				(greenDistance * greenDistance) +
				(blueDistance * blueDistance);
		    if (distance < closedDistance) {
			closedDistance = distance;
			closedColor = i;
		    }
		}

		if (closedColor < 0) {
		    FatalError("Internal Color Allocate Error!");
		}

		colorTable[index].pixel = queryColorTable[closedColor].pixel;
		colorTable[index].red = queryColorTable[closedColor].red;
		colorTable[index].green = queryColorTable[closedColor].green;
		colorTable[index].blue = queryColorTable[closedColor].blue;
	    } else {
		pixels[index].isAlloc = True;
		if ((depth <= 8) && !isPerfect) {
		    if (appPixelTable[colorTable[index].pixel]
							!= SPECIAL_PIXEL) {
			(appPixelTable[colorTable[index].pixel])++;
		    }
		}
	    }
	    pixels[index].pixel = colorTable[index].pixel;
	    isTransparentPixel[index] = False;
	} else {
	    /* $BF)L@%T%/%;%k(B */
	    pixels[index].isAlloc = False;
	    pixels[index].pixel = backgroundPixel;
	    isTransparentPixel[index] = True;
	}
    }
    *npixels = pImage->numOfPalettes;

    /* $B%T%/%;%k%G!<%?$r(B XAllocColor $B$7$?%T%/%;%kHV9f$K=q$-49$($k(B */
    for (y = 0; y < pImage->height; y++) {
	for (x = 0; x < pImage->width; x++) {
	    paletteIndex = XGetPixel(image, x, y);
	    XPutPixel(image, x, y,
		      isTransparentPixel[paletteIndex] ?
		      backgroundPixel : colorTable[paletteIndex].pixel);
	}
    }

    /* $B$"$H$7$^$D(B */
    XtFree((char *)colorTable);
    XtFree((char *)isTransparentPixel);

    return(image);
}


/*
 *  $B05=L%T%/%;%k%$%a!<%8$NE83+(B
 */
static void
UncompressPixel(image, pImage)
    XImage		*image;
    PixelImage		*pImage;
{
    unsigned int	x, y, count;
    CARD8		*compressedPixel;

    compressedPixel = pImage->pixel;
    for (y = 0, x = 0; y < pImage->height; ) {
	for (count = 0; count < *compressedPixel; count++) {
	    XPutPixel(image, x, y, *(compressedPixel + 1));

	    if (++x == pImage->width) {
		y++;
		x = 0;
	    }
	}
	compressedPixel += 2;
    }
}


/*
 *  BitmapTable $B$+$i(B Pixmap $B$r@8@.(B
 */
Pixmap
BitmapTable2Pixmap(w, bitmapTable)
    Widget	w;
    BitmapTable	*bitmapTable;
{
    Cardinal	depth;
    Pixmap	pixmap;

    XtVaGetValues(w, XtNdepth, &depth, NULL);

    pixmap = XCreatePixmapFromBitmapData(XtDisplay(w),
		RootWindowOfScreen(XtScreen(w)),
    		bitmapTable->bits, bitmapTable->width, bitmapTable->height,
		BlackPixel(XtDisplay(w), DefaultScreen(XtDisplay(w))),
		WhitePixel(XtDisplay(w), DefaultScreen(XtDisplay(w))),
    		depth);

    return(pixmap);
}


/*
 *  PixelImage $B$N%+%i!<%;%k$N3NJ](B
 */
void
AllocPImageCollors(w, cmap, pImage)
    Widget	w;
    Colormap	cmap;
    PixelImage	*pImage;
{
    int		i;
    XColor	color;

    for (i = 0; i < pImage->numOfPalettes; i++) {
	color.red = pImage->paletteColor[i * 3] << 8;
	color.green = pImage->paletteColor[i * 3 + 1] << 8;
	color.blue = pImage->paletteColor[i * 3 + 2] << 8;
	if (XAllocColor(XtDisplay(w), cmap, &color) == 0) {
	    FatalError("Can't XAllocColor.");
	}
    }
}


/*
 *  $B%"%W%j%1!<%7%g%s$N%T%/%;%kCM$rJ]B8$9$kFbIt%G!<%?$N=i4|2==hM}(B
 */
int *
AppPixelTableInit()
{
    int		*appPixelTable;
    int		i;

    appPixelTable = (int *)XtMalloc(sizeof(int) * PIXELS_8);

    for (i = 0; i < PIXELS_8; i++) {
	appPixelTable[i] = 0;
    }

    return(appPixelTable);
}


/*
 *  XFreeColors() $B$7$F$O$$$1$J$$%T%/%;%k$r5-21(B
 */
void
SetSpecialAppPixel(appPixelTable, pixel)
    int		*appPixelTable;
    int		pixel;
{
    if ((pixel >= 0) && (pixel < PIXELS_8)) {
	appPixelTable[pixel] = SPECIAL_PIXEL;
    }
}


/*
 *  $BFCCm(B XFreeColors()
 */
void
XeFreeColors(display, cmap, appPixelTable, pixels, npixels, planes)
    Display		*display;
    Colormap		cmap;
    int			*appPixelTable;
    unsigned long	*pixels;
    int			npixels;
    unsigned long	planes;
{
    int			i;
    unsigned long	unNeedPixels[PIXELS_8];
    int			numOfUnNeedPixels;

    for (i = 0, numOfUnNeedPixels = 0; i < npixels; i++) {
	if (pixels[i] < PIXELS_8) {
	    if (appPixelTable[pixels[i]] != SPECIAL_PIXEL) {
		(appPixelTable[pixels[i]])--;
		if (appPixelTable[pixels[i]] == 0) {
		    unNeedPixels[numOfUnNeedPixels++] = pixels[i];
		}
	    }
	}
    }

    XFreeColors(display, cmap, unNeedPixels, numOfUnNeedPixels, planes);
}


/*
 *  Pixmap $B2#J}8~05=L(B
 */
Pixmap
SqueezePixmapWidth(w, gc, pixmap, rate)
    Widget	w;
    GC		gc;
    Pixmap	pixmap;
    double	rate;
{
    Window		root;
    int			x, y;
    unsigned int	width, height, border_width, depth;
    XImage		*image;
    unsigned int	newWidth;
    Pixmap		newPixmap;

    XGetGeometry(XtDisplay(w), pixmap,
			&root, &x, &y, &width, &height,
			&border_width, &depth);

    newPixmap = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
				(unsigned int)(width * rate), height, depth);

    if (rate < 1.0) {
	image = XGetImage(XtDisplay(w), pixmap,
    				0, 0, width, height, -1, ZPixmap);

	newWidth = width * rate;
	for (y = 0; y < height; y++) {
	    for (x = 0; x < newWidth; x++) {
		XPutPixel(image, x, y,
				XGetPixel(image, (int)((double)x / rate), y));
	    }
	}

	XPutImage(XtDisplay(w), newPixmap, gc, image, 0, 0, 0, 0,
    							newWidth, height);
	XDestroyImage(image);
    } else {
	XCopyArea(XtDisplay(w), newPixmap, pixmap,
				gc, 0, 0, width, height, 0, 0);
    }

    return(newPixmap);
}
