/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class LoadResourceAction
extends Action {
    protected EditingDomain domain;

    public LoadResourceAction(EditingDomain domain) {
        this();
        this.domain = domain;
        this.update();
    }

    public LoadResourceAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResource_menu_item"));
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResource_menu_item_description"));
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void run() {
        LoadResourceDialog loadResourceDialog = new LoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain);
        loadResourceDialog.open();
    }

    public void update() {
        this.setEnabled(this.domain != null);
    }

    public void setActiveEditor(IEditorPart editorPart) {
        this.setEditingDomain(editorPart instanceof IEditingDomainProvider ? ((IEditingDomainProvider)editorPart).getEditingDomain() : null);
    }

    public static class LoadResourceDialog
    extends Dialog {
        public static int CONTROL_OFFSET = 10;
        protected EditingDomain domain;
        protected Text resourceURIField;
        protected String resourceURIs;

        public LoadResourceDialog(Shell parent) {
            this(parent, null);
        }

        public LoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            this.domain = domain;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResourceDialog_title"));
        }

        protected Control createDialogArea(Composite parent) {
            FormData data;
            boolean resourcesBundleIsAvailable = Platform.getBundle((String)"org.eclipse.core.resources") != null;
            Composite composite = (Composite)super.createDialogArea(parent);
            FormLayout layout = new FormLayout();
            composite.setLayout((Layout)layout);
            GridData data2 = new GridData();
            data2.verticalAlignment = 4;
            data2.grabExcessVerticalSpace = true;
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            if (!resourcesBundleIsAvailable) {
                data2.widthHint = 330;
            }
            composite.setLayoutData((Object)data2);
            Composite buttonComposite = new Composite(composite, 0);
            data2 = new FormData();
            data2.top = new FormAttachment(0, CONTROL_OFFSET);
            data2.left = new FormAttachment(30, 0);
            data2.right = new FormAttachment(100, -CONTROL_OFFSET);
            buttonComposite.setLayoutData((Object)data2);
            buttonComposite.setLayout((Layout)new FormLayout());
            Label resourceURILabel = new Label(composite, 16384);
            resourceURILabel.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_ResourceURI_label"));
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)buttonComposite, CONTROL_OFFSET, 0x1000000);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            resourceURILabel.setLayoutData((Object)data3);
            this.resourceURIField = new Text(composite, 2048);
            data3 = new FormData();
            data3.top = new FormAttachment((Control)buttonComposite, CONTROL_OFFSET);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            data3.right = new FormAttachment(100, -CONTROL_OFFSET);
            this.resourceURIField.setLayoutData((Object)data3);
            Button resourceURIBrowseFileSystemButton = new Button(buttonComposite, 8);
            resourceURIBrowseFileSystemButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
            resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ LoadResourceDialog this$1;
                {
                    this.this$1 = loadResourceDialog;
                }

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(this.this$1.getShell());
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                        this.this$1.resourceURIField.setText((String.valueOf(this.this$1.resourceURIField.getText()) + "  " + URI.createFileURI((String)filePath).toString()).trim());
                    }
                }
            });
            if (resourcesBundleIsAvailable) {
                Button resourceURIBrowseWorkspaceButton = new Button(buttonComposite, 8);
                data = new FormData();
                data.right = new FormAttachment(100);
                resourceURIBrowseWorkspaceButton.setLayoutData((Object)data);
                data = new FormData();
                data.right = new FormAttachment((Control)resourceURIBrowseWorkspaceButton, -CONTROL_OFFSET);
                resourceURIBrowseFileSystemButton.setLayoutData((Object)data);
                resourceURIBrowseWorkspaceButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
                resourceURIBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ LoadResourceDialog this$1;
                    {
                        this.this$1 = loadResourceDialog;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        new ArrayList<E>();
                        ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(this.this$1.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), EMFEditUIPlugin.INSTANCE.getString("_UI_SelectTheResource_label"));
                        resourceSelectionDialog.open();
                        Object[] result = resourceSelectionDialog.getResult();
                        if (result != null) {
                            StringBuffer text = new StringBuffer();
                            int i = 0;
                            while (i < result.length) {
                                IResource resource = (IResource)result[i];
                                if (resource.getType() == 1) {
                                    text.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString()));
                                    text.append("  ");
                                }
                                ++i;
                            }
                            this.this$1.resourceURIField.setText((String.valueOf(this.this$1.resourceURIField.getText()) + "  " + text.toString()).trim());
                        }
                    }
                });
            } else {
                FormData data4 = new FormData();
                data4.right = new FormAttachment(100);
                resourceURIBrowseFileSystemButton.setLayoutData((Object)data4);
            }
            Label separatorLabel = new Label(composite, 258);
            data = new FormData();
            data.top = new FormAttachment((Control)this.resourceURIField, (int)(1.5 * (double)CONTROL_OFFSET));
            data.left = new FormAttachment(0, -CONTROL_OFFSET);
            data.right = new FormAttachment(100, CONTROL_OFFSET);
            separatorLabel.setLayoutData((Object)data);
            composite.setTabList(new Control[]{this.resourceURIField, buttonComposite});
            return composite;
        }

        protected void okPressed() {
            this.resourceURIs = this.getResourceURIs();
            if (this.domain != null) {
                Iterator i = this.getURIs().iterator();
                while (i.hasNext()) {
                    try {
                        this.domain.getResourceSet().getResource((URI)i.next(), true);
                    }
                    catch (RuntimeException exception) {
                        EMFEditUIPlugin.INSTANCE.log(exception);
                    }
                }
            }
            super.okPressed();
        }

        public boolean close() {
            return super.close();
        }

        public String getResourceURIs() {
            return this.resourceURIField != null && !this.resourceURIField.isDisposed() ? this.resourceURIField.getText() : this.resourceURIs;
        }

        public List getURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.getResourceURIs());
            while (stringTokenizer.hasMoreTokens()) {
                String resourceURI = stringTokenizer.nextToken();
                uris.add(URI.createURI((String)resourceURI));
            }
            return uris;
        }
    }
}

