/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.WrapperItemProvider;

public class AttributeValueWrapperItemProvider
extends WrapperItemProvider
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IEditingDomainItemProvider {
    protected EAttribute attribute;
    protected int index;
    protected List propertyDescriptors;

    public AttributeValueWrapperItemProvider(Object value, EObject owner, EAttribute attribute, AdapterFactory adapterFactory) {
        super(value, owner, adapterFactory);
        this.attribute = attribute;
        this.index = -1;
    }

    public AttributeValueWrapperItemProvider(Object value, EObject owner, EAttribute attribute, int index, AdapterFactory adapterFactory) {
        super(value, owner, adapterFactory);
        this.attribute = attribute;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getText(Object object) {
        return this.value != null ? EcoreUtil.convertToString((EDataType)this.attribute.getEAttributeType(), (Object)this.value) : "null";
    }

    public List getPropertyDescriptors(Object object) {
        if (this.propertyDescriptors == null) {
            IItemPropertyDescriptor descriptor = new ItemPropertyDescriptor(this.getRootAdapterFactory(), this.getPropertyName(), this.getPropertyDescription(), (EStructuralFeature)this.attribute, this.isPropertySettable(), this.getPropertyImage());
            descriptor = new ItemPropertyDescriptorDecorator(this.owner, descriptor);
            this.propertyDescriptors = Collections.singletonList(descriptor);
        }
        return this.propertyDescriptors;
    }

    protected boolean isPropertySettable() {
        return this.attribute.isChangeable();
    }

    protected Object getPropertyImage() {
        return this.getPropertyImage(this.attribute.getEType().getInstanceClass());
    }

    protected Command createCopyCommand(EditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return new WrapperItemProvider.SimpleCopyCommand(this, domain){

            public IWrapperItemProvider copy() {
                Object valueCopy = null;
                if (AttributeValueWrapperItemProvider.this.value != null) {
                    EDataType dataType = AttributeValueWrapperItemProvider.this.attribute.getEAttributeType();
                    String serialization = EcoreUtil.convertToString((EDataType)dataType, (Object)AttributeValueWrapperItemProvider.this.value);
                    valueCopy = EcoreUtil.createFromString((EDataType)dataType, (String)serialization);
                    if (serialization == AttributeValueWrapperItemProvider.this.value && serialization == valueCopy) {
                        valueCopy = new String((String)AttributeValueWrapperItemProvider.this.value);
                    }
                }
                return new AttributeValueWrapperItemProvider(valueCopy, (EObject)AttributeValueWrapperItemProvider.this.owner, AttributeValueWrapperItemProvider.this.attribute, AttributeValueWrapperItemProvider.this.index, AttributeValueWrapperItemProvider.this.adapterFactory);
            }
        };
    }
}

