/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jmerge;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JControlModel {
    protected List dictionaryPatterns;
    protected List pullRules;
    protected List sweepRules;
    protected List sortRules;
    protected String indent;
    protected String redirect;
    protected boolean standardBraceStyle;
    protected Pattern blockPattern;
    protected Pattern noImportPattern;

    public JControlModel(String uri) {
        this.initialize(uri);
    }

    public JControlModel(Element element) {
        this.initialize(element);
    }

    public boolean convertToStandardBraceStyle() {
        return this.standardBraceStyle;
    }

    public void setConvertToStandardBraceStyle(boolean standardBraceStyle) {
        this.standardBraceStyle = standardBraceStyle;
    }

    public String getLeadingTabReplacement() {
        return this.indent;
    }

    public void setLeadingTabReplacement(String indent) {
        this.indent = indent;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public Pattern getBlockPattern() {
        return this.blockPattern;
    }

    public Pattern getNoImportPattern() {
        return this.noImportPattern;
    }

    public List getDictionaryPatterns() {
        if (this.dictionaryPatterns == null) {
            this.dictionaryPatterns = new ArrayList();
        }
        return this.dictionaryPatterns;
    }

    public List getPullRules() {
        if (this.pullRules == null) {
            this.pullRules = new ArrayList();
        }
        return this.pullRules;
    }

    public List getSweepRules() {
        if (this.sweepRules == null) {
            this.sweepRules = new ArrayList();
        }
        return this.sweepRules;
    }

    public List getSortRules() {
        if (this.sortRules == null) {
            this.sortRules = new ArrayList();
        }
        return this.sortRules;
    }

    protected void initialize(String uri) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(uri));
            this.initialize(document.getDocumentElement());
        }
        catch (Exception exception) {
            CodeGenPlugin.INSTANCE.log(exception);
        }
    }

    protected void initialize(Element element) {
        if (element.getLocalName().equals("options")) {
            if ("standard".equals(element.getAttributeNS(null, "braceStyle"))) {
                this.standardBraceStyle = true;
            }
            if (element.hasAttributeNS(null, "indent")) {
                this.indent = element.getAttributeNS(null, "indent");
            }
            if (element.hasAttributeNS(null, "redirect")) {
                this.redirect = element.getAttributeNS(null, "redirect");
            }
            if (element.hasAttributeNS(null, "block")) {
                this.blockPattern = Pattern.compile(element.getAttributeNS(null, "block"), 40);
            }
            if (element.hasAttributeNS(null, "noImport")) {
                this.noImportPattern = Pattern.compile(element.getAttributeNS(null, "noImport"), 40);
            }
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    Element elementChild = (Element)child;
                    if (elementChild.getLocalName().equals("dictionaryPattern")) {
                        this.getDictionaryPatterns().add(new DictionaryPattern(elementChild));
                    } else if (elementChild.getLocalName().equals("pull")) {
                        this.getPullRules().add(new PullRule(elementChild));
                    } else if (elementChild.getLocalName().equals("sweep")) {
                        this.getSweepRules().add(new SweepRule(elementChild));
                    } else if (elementChild.getLocalName().equals("sort")) {
                        this.getSortRules().add(new SortRule(elementChild));
                    }
                }
                child = child.getNextSibling();
            }
        }
    }

    public static Class classForClassName(String className) {
        className = "org.eclipse.jdt.core.jdom.IDOM" + className;
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException exception) {
            CodeGenPlugin.INSTANCE.log(exception);
            return null;
        }
    }

    public static class Feature {
        protected Class featureClass;
        protected Method featureMethod;

        public Feature(String path, Class[] parameterTypes) {
            int index = path.indexOf(47);
            String className = "org.eclipse.jdt.core.jdom.IDOM" + path.substring(0, index);
            String methodName = path.substring(index + 1);
            try {
                this.featureClass = Class.forName(className);
                this.featureMethod = this.featureClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }

        public Class getFeatureClass() {
            return this.featureClass;
        }

        public Method getFeatureMethod() {
            return this.featureMethod;
        }
    }

    public static class DictionaryPattern {
        protected static Class[] noParameterTypes = new Class[0];
        protected static Class[] stringParameterType;
        protected String name;
        protected Feature selectorFeature;
        protected Pattern pattern;
        static /* synthetic */ Class class$0;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            stringParameterType = classArray;
        }

        public DictionaryPattern() {
        }

        public DictionaryPattern(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            this.name = element.getAttribute("name");
            this.selectorFeature = new Feature(element.getAttribute("select"), noParameterTypes);
            this.pattern = Pattern.compile(element.getAttribute("match"), 40);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSelectorFeature() {
            return this.selectorFeature;
        }

        public void setSelectorFeature(Feature selectorFeature) {
            this.selectorFeature = selectorFeature;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }
    }

    public static class PullRule {
        protected static Class[] noParameterTypes = new Class[0];
        protected String name;
        protected Pattern sourceMarkup;
        protected Feature sourceGetFeature;
        protected Pattern sourceTransfer;
        protected Pattern targetMarkup;
        protected Feature targetPutFeature;
        protected Pattern targetTransfer;

        public PullRule() {
        }

        public PullRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            this.sourceGetFeature = new Feature(element.getAttribute("sourceGet"), noParameterTypes);
            if (this.sourceGetFeature != null) {
                Class<?> sourceReturnType = this.sourceGetFeature.getFeatureMethod().getReturnType();
                this.targetPutFeature = new Feature(element.getAttribute("targetPut"), new Class[]{sourceReturnType});
                if (this.targetPutFeature.getFeatureMethod() == null && sourceReturnType.isArray()) {
                    this.targetPutFeature = new Feature(element.getAttribute("targetPut"), new Class[]{sourceReturnType.getComponentType()});
                }
            }
            if (element.hasAttribute("sourceMarkup")) {
                this.sourceMarkup = Pattern.compile(element.getAttribute("sourceMarkup"), 40);
            }
            if (element.hasAttribute("targetMarkup")) {
                this.targetMarkup = Pattern.compile(element.getAttribute("targetMarkup"), 40);
            }
            if (element.hasAttribute("sourceTransfer")) {
                this.sourceTransfer = Pattern.compile(element.getAttribute("sourceTransfer"), 40);
            }
            if (element.hasAttribute("targetTransfer")) {
                this.targetTransfer = Pattern.compile(element.getAttribute("targetTransfer"), 40);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSourceGetFeature() {
            return this.sourceGetFeature;
        }

        public void setSourceGetFeature(Feature sourceGetFeature) {
            this.sourceGetFeature = sourceGetFeature;
        }

        public Feature getTargetPutFeature() {
            return this.targetPutFeature;
        }

        public void setTargetPutFeature(Feature targetPutFeature) {
            this.targetPutFeature = targetPutFeature;
        }

        public Pattern getSourceTransfer() {
            return this.sourceTransfer;
        }

        public void setSourceTransfer(Pattern sourceTransfer) {
            this.sourceTransfer = sourceTransfer;
        }

        public Pattern getTargetTransfer() {
            return this.targetTransfer;
        }

        public void setTargetTransfer(Pattern targetTransfer) {
            this.targetTransfer = targetTransfer;
        }

        public Pattern getSourceMarkup() {
            return this.sourceMarkup;
        }

        public void setSourceMarkup(Pattern sourceMarkup) {
            this.sourceMarkup = sourceMarkup;
        }

        public Pattern getTargetMarkup() {
            return this.targetMarkup;
        }

        public void setTargetMarkup(Pattern targetMarkup) {
            this.targetMarkup = targetMarkup;
        }
    }

    public static class SweepRule {
        protected String name;
        protected Class selector;
        protected Pattern markup;

        public SweepRule() {
        }

        public SweepRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getSelector() {
            return this.selector;
        }

        public void setSelector(Class selector) {
            this.selector = selector;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }
    }

    public static class SortRule {
        protected String name;
        protected Class selector;
        protected Pattern markup;

        public SortRule() {
        }

        public SortRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getSelector() {
            return this.selector;
        }

        public void setSelector(Class selector) {
            this.selector = selector;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }
    }
}

