/* $Id: e2_utils.h 1279 2008-09-27 23:34:46Z tpgww $

Copyright (C) 2003-2008 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef __E2_UTILS_H__
#define __E2_UTILS_H__

#include "emelfm2.h"

#define LF 10
#define CR 13

typedef enum
{
	E2_DOTS_START,
	E2_DOTS_MIDDLE,
	E2_DOTS_END,
} E2_DotMode;

typedef struct _E2_Duo
{
	gpointer a;
	gpointer b;
} E2_Duo;

typedef struct _E2_Trio
{
	gpointer a;
	gpointer b;
	gpointer c;
} E2_Trio;
/*
typedef struct _E2_Quartet
{
	gpointer a;
	gpointer b;
	gpointer c;
	gpointer d;
} E2_Quartet;
*/
typedef struct _E2_Sextet
{
	gpointer a;
	gpointer b;
	gpointer c;
	gpointer d;
	gpointer e;
	gpointer f;
} E2_Sextet;

typedef struct _E2_Nontet
{
	gpointer a;
	gpointer b;
	gpointer c;
	gpointer d;
	gpointer e;
	gpointer f;
	gpointer g;
	gpointer h;
	gpointer i;
} E2_Nontet;

//E2_Trio *e2_utils_trio_new (void);
E2_Sextet *e2_utils_sextet_new (void);
E2_Nontet *e2_utils_nontet_new (void);
//void e2_utils_trio_destroy (E2_Trio *t);
void e2_utils_sextet_destroy (E2_Sextet *s);
void e2_utils_nontet_destroy (E2_Nontet *n);
void e2_utils_show_memory_message (void);
void e2_utils_memory_error (void);
void e2_utils_show_help (gchar *title);
gchar *e2_utils_color2str (GdkColor *color);
gchar *e2_utils_str_replace (const gchar *str, const gchar *old, const gchar *new);
gint e2_utils_LF_line_ends (gchar *text);
gchar *e2_utils_revert_line_ends (gchar *text, guint linecount, gint separator);
gchar *e2_utils_get_mimetype (VPATH *localpath);
void e2_utils_get_charset (const gchar **encoding);
void e2_utils_rowstr_split (gchar *line, gint columns, gchar *parts[]);
gchar *e2_utils_str_stretch (gchar *string);
gchar *e2_utils_str_shorten (gchar *string, gint limit, E2_DotMode position);
gchar *e2_utils_str_to_lower (gchar *string);
gint e2_utils_get_byte_position (const gchar *utf8_string, gint charoffset);
gchar *e2_utils_dircat (ViewInfo *view, const gchar *string, gboolean localised);
gchar *e2_utils_strcat (const gchar *string1, const gchar *string2);
gchar **e2_utils_str_breakup (const gchar *string, const gchar *delimiter,
	gint max_tokens);
gchar *e2_utils_find_whitespace (gchar *string);
gchar *e2_utils_pass_whitespace (gchar *string);
gchar *e2_utils_quote_string (const gchar *string);
gchar *e2_utils_unquote_string (const gchar *utf8string);
gchar *e2_utils_bare_strchr (gchar *string, gchar c);
gchar *e2_utils_get_first_part (gchar *string, gboolean quoted);
gchar *e2_utils_get_tempname (const gchar *orig);
gboolean e2_utils_goto_accessible_path (E2_PaneRuntime *rt);
gboolean e2_utils_get_parent_path (gchar *path, gboolean ignore_trailer);
gchar *e2_utils_path_clean (gchar *path)
#ifdef G_GNUC_WARN_UNUSED_RESULT
 G_GNUC_WARN_UNUSED_RESULT
#endif
;
gchar *e2_utils_translate_relative_path (gchar *current_dir, gchar *new_dir);
gchar *e2_utils_create_relative_path (const gchar *src, const gchar *dest);
gchar *e2_utils_get_temp_path (const gchar *id);
gchar *e2_utils_get_home_path (const gchar *utfpath);
gchar *e2_utils_get_trash_path (gchar *localpath, gboolean filesplace);
GList *e2_utils_get_trash_all (void);
gchar *e2_utils_get_icons_path (gboolean withtrailer);
#ifdef E2_IMAGECACHE
void e2_utils_init_icon_sizes (void);
gint e2_utils_get_icon_size (GtkIconSize size);
GtkIconSize e2_utils_get_best_icon_size (gint psize);
#endif
gboolean e2_utils_check_stock_icon (const gchar *name);
const gchar *e2_utils_get_output_font (void);
void e2_utils_update_gtk_settings (void);
gchar *e2_utils_expand_macros (const gchar *text, const gchar *for_each);
gchar *e2_utils_replace_name_macros (const gchar *text, const gchar *utfpath);
gchar *e2_utils_replace_multiname (const gchar *text, gchar *path, GPtrArray *array,
	gboolean single);
gboolean e2_utils_get_variable (gchar **variable);
gchar *e2_utils_replace_vars (gchar *raw);
gchar *e2_utils_replace_wildcards (gchar *raw);
void e2_utils_get_abs_pos (GtkWidget *widget, gint *x, gint *y);
GdkModifierType e2_utils_get_modifiers (void);
void e2_utils_beep (void);
gboolean e2_utils_multi_src (GList *srclist);
gunichar e2_utils_get_mnemonic_char (const gchar *label);
guint e2_utils_get_mnemonic_keycode (gchar *label);
void e2_utils_block_thread_signals (void);

#ifndef USE_GTK2_10
gboolean e2_utils_key_is_modifier (GdkEventKey *event);
#endif
gboolean e2_utils_generic_press_cb (GtkWidget *widget, GdkEventButton *event,
	gpointer user_data);
//gboolean e2_utils_generic_release_cb (GtkWidget *widget, GdkEventButton *event,
//	gpointer user_data);
gboolean e2_utils_check_release (GdkEventButton *event);
gint e2_utils_check_drag (GdkEventButton *event);

#endif //ndef __E2_UTILS_H__
