
static char rcsid[] = "@(#)$Id: from.c,v 1.14.2.1 1999/08/27 04:06:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.14.2.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** print out whom each message is from in the pending folder or specified 
    one, including a subject line if available.

**/

#include "elmutil.h"
#include "s_from.h"
     
#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif
#include <sys/stat.h>

#define LINEFEED	(char) 10

#define metachar(c)	(c == '=' || c == '+' || c == '%')

/* ancient wisdom */
#ifndef TRUE
#  define TRUE	1
#  define FALSE	0
#endif

/* for explain(), positive and negative */
#define POS	1
#define NEG	0

/* defines for selecting messages by Status: */
#define NEW_MSG		0x1
#define OLD_MSG		0x2
#define READ_MSG	0x4
#define UNKNOWN		0x8

#define ALL_MSGS	0xf

/* exit statuses */
#define	EXIT_SELECTED	0	/* Selected messages present */
#define	EXIT_MAIL	1	/* Mail present, but no selected messages */
#define	EXIT_NO_MAIL	2	/* No messages at all */
#define	EXIT_ERROR	3	/* Error */

FILE *mailfile;

int   number = FALSE,	/* should we number the messages?? */
      veryquiet = FALSE,/* should we be print any output at all? */
      quiet = FALSE,	/* only print mail/no mail and/or summary */
      selct = FALSE,	/* select these types of messages */
      tidy  = FALSE,    /* tidy output with long 'from's */
      summarize = FALSE,/* print a summary of how many messages of each type */
      verbose = FALSE;	/* and should we prepend a header? */

char infile[SLEN];	/* current file name */

static char * explain P_((
			  int selection,
			  int how_to_say));
static void usage P_((char *prog));
static void print_help P_((void));

static char * whos_mail P_((char *filename,
			    char *realname));

static void read_headers P_((int user_mailbox,
			     int *total_msgs,
			     int *selected,
			     char *realname));

#ifndef	ANSI_C
	struct passwd *getpwuid();
#endif

int main(argc, argv)
     int argc;
     char *argv[];
{
	char *cp;
	int  multiple_files = FALSE, output_files = FALSE;
	int  user_mailbox = FALSE, no_files, c;
	struct passwd *pass;
	int hostlen, domlen;
	int total_msgs = 0, selected_msgs = 0;
	int file_exists;
	struct stat statbuf;
	char realname[SLEN];

	extern int optind;
	extern char *optarg;

	locale_init();
	user_init();
	strfcpy(realname,username,sizeof realname);
	init_defaults();
	read_rc_file();

	/*
	 * check the first character of the command basename to
	 * use as the selection criterion.
	 */
	cp = argv[0] + strlen(argv[0]) - 1;
	while (cp != argv[0] && cp[-1] != '/')
	  cp--;
	switch (*cp) {
	  case 'n': selct |= NEW_MSG;  break;
	  case 'u':
	  case 'o': selct |= OLD_MSG;  break;
	  case 'r': selct |= READ_MSG; break;
	}

	while ((c = getopt(argc, argv, "hnQqSs:tvd:")) != EOF) 
	  switch (c) {
	  case 'd':    debug = atoi(optarg); break;
	  case 'n': number++;	break;
	  case 'Q': veryquiet++;	break;
	  case 'q': quiet++;	break;
	  case 'S': summarize++; break; 
	  case 't': tidy++;      break;
	  case 'v': verbose++;	break;
	  case 's': if (optarg[1] == '\0') {
	    switch (*optarg) {
	    case 'n':
	    case 'N': selct |= NEW_MSG;  break;
	    case 'o':
	    case 'O':
	    case 'u':
	    case 'U': selct |= OLD_MSG;  break;
	    case 'r':
	    case 'R': selct |= READ_MSG; break;
	    default:       usage(argv[0]);
	      exit(EXIT_ERROR);
	    }
	  } else if (istrcmp(optarg,"new") == 0)
	    selct |= NEW_MSG;
	  else if (istrcmp(optarg,"old") == 0)
	    selct |= OLD_MSG;
	  else if (istrcmp(optarg,"unread") == 0)
	    selct |= OLD_MSG;
	  else if (istrcmp(optarg,"read") == 0)
	    selct |= READ_MSG;
	  else {
	    usage(argv[0]);
	    exit(EXIT_ERROR);
	  }
	  break;
	  case 'h': print_help();
			   exit(EXIT_ERROR);
	  case '?': usage(argv[0]);
	    lib_error(CATGETS(elm_msg_cat,
			      FromSet,FromForMoreInfo,
			      "For more information, type \"%s -h\"\n"),
		      argv[0]);
	    exit(EXIT_ERROR);
	  }

	if (quiet && verbose) {
	  lib_error(CATGETS(elm_msg_cat,FromSet,FromNoQuietVerbose,
			    "Can't have quiet *and* verbose!\n"));
	  exit(EXIT_ERROR);
	}

	if (veryquiet) {
	  if (freopen("/dev/null", "w", stdout) == NULL) {
	    lib_error(CATGETS(elm_msg_cat,FromSet,FromCantOpenDevNull,
			      "Can't open /dev/null for \"very quiet\" mode.\n"));
	    exit(EXIT_ERROR);
	  }
	}

	/* default is all messages */
	if (selct == 0 || selct == (NEW_MSG|OLD_MSG|READ_MSG))
	  selct = ALL_MSGS;

	infile[0] = '\0';

	if (no_files = optind == argc) { /* assignment intentional */
	  strfcpy(infile, defaultfile, sizeof infile);
	  optind -= 1;	/* ensure one pass through loop */
	}

	multiple_files = (argc - optind > 1);

	for ( ; optind < argc; optind++) {
	
	  /* copy next argument into infile */

	  if (multiple_files) {
	    strfcpy(infile, argv[optind], sizeof infile);
	    printf("%s%s: \n", output_files++ > 0 ? "\n":"", infile);
	  }
	  else if (infile[0] == '\0')
	    strfcpy(infile, argv[optind], sizeof infile);

	  if (metachar(infile[0])) {
	    if (expand(infile, sizeof infile) == 0) {
	       lib_error(CATGETS(elm_msg_cat,
				 FromSet,FromCouldntExpandFilename,
				 "%s: couldn't expand filename %s!\n"), 
			 argv[0], infile);
	       exit(EXIT_ERROR);
	    }
	  }


	  /* check if this is a mailbox or not, and attempt to open it */

	  if (strncmp(infile, mailhome, strlen(mailhome)) == 0)
	    user_mailbox = TRUE;
	  else
	    user_mailbox = FALSE;

	  /* if file name == default mailbox, its a spool file also
	   * even if its not in the spool directory. (SVR4)
	   */
	   if (strcmp(infile, defaultfile) == 0)
	     user_mailbox = TRUE;

	  /* pardon the oversimplification here */
	  if (stat(infile, &statbuf) == -1)
	    file_exists = FALSE;
	  else
	    file_exists = TRUE;

	  if (file_exists
#ifndef	_POSIX_SOURCE
	      && (statbuf.st_mode & S_IFMT) != S_IFREG
#else
	      && ! S_ISREG(statbuf.st_mode)
#endif
	      ) {
	    lib_error(CATGETS(elm_msg_cat,FromSet,FromNotRegularFile,
			      "\"%s\" is not a regular file!\n"), infile);
	    continue;
	  }

	  if ((mailfile = fopen(infile,"r")) == NULL) {
	    if ((user_mailbox && file_exists && statbuf.st_size == 0) || no_files) {
		if (!veryquiet)
		  printf(catgets(elm_msg_cat,FromSet,FromNoMail,"No mail.\n"));
		}
	    else {
	      if (infile[0] == '/' || file_exists == TRUE) 
	        lib_error(CATGETS(elm_msg_cat,FromSet,FromCouldntOpenFolder,
				  "Couldn't open folder \"%s\".\n"), infile);
	      else {
		/* only try mailhome if file not found */
		strfcpy(infile,mailhome,sizeof infile);
		strfcat(infile,argv[optind],sizeof infile);
		if ((mailfile = fopen(infile,"r")) == NULL) {
		  lib_error(CATGETS(elm_msg_cat,
				    FromSet,FromCouldntOpenFolderPlural,
				    "Couldn't open folders \"%s\" or \"%s\".\n"),
			    argv[optind], infile);
		  continue;	/* let's try the next file */
		} else
		  user_mailbox = TRUE;
	      }
	    }
	  }

	  /* if the open was successful, read the headers */

	  if (mailfile != NULL) {
	    if (strncmp(infile, mailhome, strlen(mailhome)) == 0) {
	      /*
	       * if this is a mailbox, use the identity of the mailbox owner.
	       * this affects the "To" processing.
	       */

	      strfcpy(username, infile+strlen(mailhome), sizeof username);

	      /*
	       * then get full username
	       */
	      if((cp = get_full_name(username)) != NULL)
		strfcpy(full_username, cp,sizeof full_username);
	      else
		strfcpy(full_username, username, sizeof full_username);

	    } else {
	      /* reset values */
	      user_init();
	    }

	    read_headers(user_mailbox, &total_msgs, &selected_msgs,realname);

	    /*
	     * we know what to say; now we have to figure out *how*
	     * to say it!
	     */

	    /* no messages at all? */
	    if (total_msgs == 0) {
	      if (user_mailbox)
		printf(catgets(elm_msg_cat,FromSet,FromStringNoMail,
			       "%s no mail.\n"), whos_mail(infile, realname));
	      else
		if (!summarize)
		  printf(catgets(elm_msg_cat,FromSet,FromNoMesgInFolder,
				 "No messages in that folder!\n"));
	    }
	    else
	      /* no selected messages then? */
	      if (selected_msgs == 0) {
		if (user_mailbox)
		  printf(catgets(elm_msg_cat,FromSet,FromNoExplainMail,
				 "%s no %s mail.\n"), whos_mail(infile, 
								realname),
			 explain(selct,NEG));
		else
		  if (!summarize)
		    printf(catgets(elm_msg_cat,
				   FromSet,FromNoExplainMessages,
				   "No %s messages in that folder.\n"),
			   explain(selct,NEG));
	      }
	      else
		/* there's mail, but we just want a one-liner */
		if (quiet && !summarize) {
		  if (user_mailbox)
		    printf(catgets(elm_msg_cat,FromSet,FromStringStringMail,
				   "%s %s mail.\n"), whos_mail(infile, 
							       realname),
			   explain(selct,POS));
		  else
		    printf(catgets(elm_msg_cat,FromSet,FromThereAreMesg,
				   "There are %s messages in that folder.\n"),
			    explain(selct,POS));
		}
	    fclose(mailfile);
	  }

	} /* for each arg */

	/*
	 * return "shell true" (0) if there are selected messages;
	 * 1 if there are messages, but no selected messages;
	 * 2 if there are no messages at all.
	 */
	if (selected_msgs > 0)
	  exit(EXIT_SELECTED);
	else if (total_msgs > 0)
	  exit(EXIT_MAIL);
	else
	  exit(EXIT_NO_MAIL);
}

static void read_headers(user_mailbox, total_msgs, selected, realname)
     int user_mailbox;
     int *total_msgs;
     int *selected;
     char *realname;
{
	     /** Read the headers, output as found.  User-Mailbox is to guarantee
		 that we get a reasonably sensible message from the '-v' option
	      **/

	     struct header_rec hdr;
	     char buffer[VERY_LONG_STRING];
	     char who[SLEN];
	     register int in_header = FALSE, count = 0, selected_msgs = 0;
	     int status, i;
	     int lenWho;
	     int summary[ALL_MSGS];
#ifdef MMDF
	     int newheader = FALSE;
#endif /* MMDF */

	     for (i=0; i<ALL_MSGS; i++)
	       summary[i] = 0;

	     while (mail_gets(buffer, SLEN, mailfile) != 0) {
	       if (index(buffer, '\n') == NULL && !feof(mailfile)) {
		 int c;
		 while ((c = getc(mailfile)) != EOF && c != '\n')
		   ; /* keep reading */
	       }

#ifdef MMDF
	       if (strcmp(buffer, MSG_SEPARATOR) == 0) {
		 newheader = !newheader;
		 if (newheader) {
		   hdr.to   = NULL;
		   hdr.cc   = NULL;
		   hdr.env_from[0] = '\0';
		   hdr.from = NULL;
		   hdr.subject[0] = '\0';

		   in_header = TRUE;
		   if (user_mailbox)
		     status = NEW_MSG;
		   else
		     status = READ_MSG;
		 }
	       }
#else
	       if (first_word(buffer, "From ") && real_from(buffer, &hdr)) {
		 hdr.to   = NULL;
		 hdr.cc   = NULL;
		 hdr.from = NULL;
		 hdr.subject[0] = '\0';

		 in_header = TRUE;
		 if (user_mailbox)
		   status = NEW_MSG;
		 else
		   status = READ_MSG;
	       }
#endif /* MMDF */
	       else if (in_header) {
#ifdef MMDF
		 if (real_from(buffer, &hdr))
		   /* null */ ;
		 else
#endif /* MMDF */	      
		   if (first_word_nc(buffer,">From ")) {
		     forwarded(buffer+6, &hdr); /* return address */
		   } else if (header_cmp(buffer,"Subject", NULL) ||
			      header_cmp(buffer,"Re", NULL)) {
		     if (hdr.subject[0] == '\0') {
		       remove_header_keyword(buffer);
		       no_ret(buffer);
		       strfcpy(hdr.subject, buffer, sizeof hdr.subject);
		     }
		   }
		   else if (header_cmp(buffer,"From", NULL)) {
		     /* does not handle continuation lines ! */
		     no_ret(buffer);
		     hdr.from = break_down_address(buffer+6,
						   decode_who_none);
		   } else if (header_cmp(buffer, "To", NULL)) {
		     no_ret(buffer);
		     hdr.to = break_down_address(index(buffer, ':') + 1,
					     decode_who_none);
		   } else if (header_cmp(buffer, "Cc", NULL)) {
		     no_ret(buffer);
		     hdr.cc = break_down_address(index(buffer, ':') + 1,
					     decode_who_none);
		   } else if (header_cmp(buffer, "Status", NULL)) {
		     remove_header_keyword(buffer);
		     no_ret(buffer);
		     switch (*buffer) {
		     case 'N': status = NEW_MSG;	break;
		     case 'O': status = OLD_MSG;	break;
		     case 'R': status = READ_MSG;	break;
		     default:  status = UNKNOWN;	break;
		     }
		     if (buffer[0] == 'O' && buffer[1] == 'R')
		       status = READ_MSG;
		 }
		 else if (buffer[0] == LINEFEED) {
		   in_header = FALSE;
		   count++;
		   summary[status]++;

		   if ((status & selct) != 0) {

		     /* what a mess! */
		     if (verbose && selected_msgs == 0) {
		       if (user_mailbox) {
			 if (selct == ALL_MSGS)
			   printf(catgets(elm_msg_cat,FromSet,FromFollowingMesg,
					  "%s the following mail messages:\n"),
				   whos_mail(infile, realname));
			 else
			   printf(catgets(elm_msg_cat,FromSet,FromStringStringMail,
					  "%s %s mail.\n"), whos_mail(infile, realname),
				  explain(selct,POS));
		       }
		       else
			 printf(catgets(elm_msg_cat,
					FromSet,FromFolderContainsFollowing,
			     "Folder contains the following %s messages:\n"),
				 explain(selct,POS));
		     }

		     selected_msgs++;
		     if (! quiet) {
		       int used_to_line = DisplayAddress(&hdr,who,sizeof who,
							 decode_who_none);

		       if (used_to_line) {
			 strfcpy(buffer, "To ", sizeof buffer);
			 strfcat(buffer, who, sizeof buffer);
			 strfcpy(who, buffer, sizeof who);
		       }

		       /***
		       *	Print subject on next line if the Who part blows
		       *	the alignment
		       ***/

		       if (tidy) 
			 lenWho = strlen(who);
		       else
			 lenWho = 0;			/* forces op on same line */

		       if (number)
			 printf("%3d: %-20s%c%*s%s\n", count, who, 
				     lenWho > 20 ? '\n' : ' ',
				     lenWho > 20 ? 27   :   1, "",
				     hdr.subject);
		       else
			 printf("%-20s%c%*s%s\n", who, 
				     lenWho > 20 ? '\n' : ' ',
				     lenWho > 20 ? 22   :   1, "",
				     hdr.subject);
		     }
		   }
		 }
	       }
	     }

	     *selected = selected_msgs;
	     *total_msgs = count;

	     /* print a message type summary */

	     if (summarize) {
	       int output=FALSE, unknown = 0;

	       if (user_mailbox)
		 printf("%s ", whos_mail(infile, realname));
	       else
		 printf(catgets(elm_msg_cat,FromSet,FromFolderContains,
				"Folder contains "));

	       for (i=0; i<ALL_MSGS; i++) {
		 if (summary[i] > 0) {
		   if (output)
		     printf(", ");
		   switch (i) {
		     case NEW_MSG:
		     case OLD_MSG:
		     case READ_MSG:
		       printf("%d %s ",summary[i], explain(i,POS));
		       if (summary[i] == 1)
			    printf("%s",catgets(elm_msg_cat,
					FromSet,FromMessage,"message"));
		       else
			    printf("%s",catgets(elm_msg_cat,
					FromSet,FromMessagePlural,"messages"));

		       output = TRUE;
		       break;
		     default:
		       unknown += summary[i];
		   }
		 }
	       }
	       if (unknown)
	       {
		    printf("%d ",unknown);

		    if (unknown == 1)
			 printf("%s",catgets(elm_msg_cat,
					     FromSet,FromMessage,"message"));
		    else
			 printf("%s",catgets(elm_msg_cat,
					     FromSet,FromMessagePlural,"messages"));

		    printf("%s "," of unknown status");
		    output = TRUE;
	       }

	       if (output)
		 printf(".\n");
	       else
		 printf(catgets(elm_msg_cat,FromSet,FromNoMessages,
			    "no messages.\n"));
	     }
     }

/*
 * Return an appropriate string as to whom this mailbox belongs.
 */
char * whos_mail(filename,
		 realname)
     char *filename;
     char *realname;
{
	static char whos_who[SLEN];
	char *mailname;

	if (strncmp(filename, mailhome, strlen(mailhome)) == 0) {
	  mailname = filename + strlen(mailhome);
	  if (*mailname == '/')
	    mailname++;
	  if (strcmp(mailname, realname) == 0)
	    strfcpy(whos_who,catgets(elm_msg_cat,
				     FromSet,FromYouHave,"You have"),
		    sizeof whos_who);
	  else {
	    strfcpy(whos_who, mailname, sizeof whos_who);
	    strfcat(whos_who,catgets(elm_msg_cat,FromSet,FromHas, " has"),
		    sizeof whos_who);
	  }
	}
	else
	/* punt... */
	  strfcpy(whos_who,catgets(elm_msg_cat,
				   FromSet,FromYouHave,"You have"),
		  sizeof whos_who);

	return whos_who;
}

static void usage(prog)
     char *prog;
{
     printf(catgets(elm_msg_cat,FromSet,FromUsage,
	"Usage: %s [-n] [-v] [-t] [-s {new|old|read}] [filename | username] ...\n"),
	    prog);
}

static void print_help()
{

     printf(catgets(elm_msg_cat,FromSet,FromHelpTitle,
 "frm -- list from and subject lines of messages in mailbox or folder\n"));
		    
     usage("frm");
     printf(catgets(elm_msg_cat,FromSet,FromHelpText,
"\noption summary:\n\
-h\tprint this help message.\n\
-n\tdisplay the message number of each message printed.\n\
-Q\tvery quiet -- no output is produced.  This option allows shell\n\
\tscripts to check frm's return status without having output.\n\
-q\tquiet -- only print summaries for each mailbox or folder.\n\
-S\tsummarize the number of messages in each mailbox or folder.\n\
-s status only -- select messages with the specified status.\n\
\t'status' is one of \"new\", \"old\", \"unread\" (same as \"old\"),\n\
\tor \"read\".  Only the first letter need be specified.\n\
-t\ttry to align subjects even if 'from' text is long.\n\
-v\tprint a verbose header.\n"));

}

/* explanation of messages visible after selection */
/* usage: "... has the following%s messages ...", explain(selct,POS) */

static char *
explain(selection, how_to_say)
     int selection;
     int how_to_say;
{
	switch (selection) {
	  case NEW_MSG:
	    return catgets(elm_msg_cat,FromSet,FromNew,"new");
	  case OLD_MSG:
	    return catgets(elm_msg_cat,FromSet,FromUnread,"unread");
	  case READ_MSG:
	    return catgets(elm_msg_cat,FromSet,FromRead,"read");
	  case (NEW_MSG|OLD_MSG):
	    if (how_to_say == POS)
	      return catgets(elm_msg_cat,FromSet,FromNewAndUnread,
			     "new and unread");
	    else
	      return catgets(elm_msg_cat,FromSet,FromNewOrUnread,
			     "new or unread");
	  case (NEW_MSG|READ_MSG):
	    if (how_to_say == POS)
	      return catgets(elm_msg_cat,FromSet,FromNewAndRead,
			     "new and read");
	    else
	      return catgets(elm_msg_cat,FromSet,FromNewOrRead,
			     "new or read");
	  case (READ_MSG|OLD_MSG):
	    if (how_to_say == POS)
	      return catgets(elm_msg_cat,FromSet,FromReadAndUnread,
			     "read and unread");
	    else
	      return catgets(elm_msg_cat,FromSet,FromReadOrUnread,
			     "read or unread");
	  case ALL_MSGS:
	    return "";
	  default:
	    return catgets(elm_msg_cat,FromSet,FromUnknown,"unknown");
	}
}
