
static char rcsid[] = "@(#)$Id: utils.c,v 1.5.4.1 1999/08/27 04:06:14 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Utility routines for ELM

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"
#include <sys/stat.h>
#include <errno.h>

extern int errno;

void create_new_folders()
{
	/* this creates a new folders directory */

	(void) mkdir(folders, 0700);

	(void) elm_chown(folders, userid, groupid);
}

void create_new_elmdir()
{
	/** this routine is just for allowing new users who don't have the
	    old elm files to create a new .elm directory **/

	char source[SLEN];
	sprintf(source, "%s/.elm", home);
	(void) mkdir(source, 0700);

	(void) elm_chown( source, userid, groupid);
}


/*
 * The initialize() procedure sets the "xalloc_fail_handler" vector to
 * point here in the event that xmalloc() or friends fail.
 */
/*ARGSUSED*/
void malloc_failed_exit(proc, len)
{
    MoveCursor(elm_LINES,0);
    Raw(OFF);
    fprintf(stderr, catgets(elm_msg_cat, ElmSet, ElmCouldntMallocBytes,
	"\n\nCouldn't malloc %d bytes!!\n\n"), len);
    emergency_exit(0);
}

void emergency_exit(interrupt)
     int interrupt;
{
  /* if interrupt is true we can't call anything which 
   * is not reentrant 
   */

	/** used in dramatic cases when we must leave without altering
	    ANYTHING about the system... **/
	int do_cursor = RawState();

	char *mk_lockname();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
	signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	if (interrupt)
	  dprint(1, (debugfile, "\nLeaving mailer from signal handler (emergency_exit)\n"));

	dprint(1, (debugfile,
     "\nERROR: Something dreadful is happening!  Taking emergency exit!!\n\n"));
	dprint(1, (debugfile,
	     "  possibly leaving behind the following files;\n"));
	if (current_folder) {
	  dprint(1, (debugfile,
		     "     The mailbox temp file : %s\n", 
		     current_folder->cur_tempfolder));
#ifdef	USE_DOTLOCK_LOCKING	  
	  if(current_folder->folder_type == SPOOL &&
	     current_folder->lockfile) 
	    dprint(1, (debugfile,
		       "     The mailbox lock file: %s\n", 
		       current_folder->lockfile));
#endif  /* USE_DOTLOCK_LOCKING */
	}

	dprint(1, (debugfile,
	     "     The composition file : %s\n", 
		   cur_editfile));

	/* softkeys_off(); */

	if (do_cursor) {
	  Raw(OFF);
	  MoveCursor(elm_LINES, 0);
	}

	fprintf(stderr,
		catgets(elm_msg_cat, ElmSet, ElmEmergencyExitTaken,
			"\nEmergency exit taken! All temp files intact!\n\n"));

	if (interrupt) {
	  fprintf(stderr,"ABORTING...\n");
#ifdef USE_PGP
	  /* Don't put passphrase to core file! */
	  pgp_void_passphrase();
#endif
	  abort();
	}

	exit(1);
}

void rm_temps_exit()
{
	char buffer[SLEN];
	int do_cursor = RawState();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
	signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	PutLine0(elm_LINES, 0, catgets(elm_msg_cat, ElmSet, ElmWriteFailedExitingIntact,
	 "\nWrite to temp file failed, exiting leaving mailbox intact!\n\n"));
	dprint(2, (debugfile, "\nrm_temps_exit, deleteing temp files\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	  unlink(cur_editfile); /* editor buffer */

	if (current_folder) {
	  if (current_folder->folder_type == SPOOL) {
	    (void) unlink(current_folder->cur_tempfolder);
	  }

	  unlock(0,current_folder);                               /* remove lock file if any */

	}

	if(do_cursor) {
	    MoveCursor(elm_LINES,0);
	    NewLine();
	    Raw(OFF);
	}

	exit(1);
}

/*ARGSUSED*/
/*VARARGS0*/

void leave (interrupt)
     int interrupt;
{
  int do_cursor = RawState();

  /* if interrupt is true do not call anything which is not re-entrant */  

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	if (interrupt)
	  dprint(2, (debugfile, "\nLeaving mailer from signal handler (leave)\n"));
	else
	  dprint(2, (debugfile, "\nLeaving mailer normally (leave)\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	  unlink(cur_editfile); /* editor buffer */

	if (current_folder) {
	  if (current_folder->folder_type == SPOOL) {
	    (void) unlink(current_folder->cur_tempfolder);
	  }

	  unlock(interrupt, current_folder);	/* remove lock file if any */
	}

	if (do_cursor) {
	  MoveCursor(elm_LINES,0);
	  NewLine();
	  Raw(OFF);
	}

	exit(0);
}

void silently_exit()
{
	/** This is the same as 'leave', but it doesn't remove any non-pid
	    files.  It's used when we notice that we're trying to create a
	    temp mail file and one already exists!!
	**/
	int do_cursor = RawState();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
	signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

	dprint(2, (debugfile, "\nLeaving mailer quietly (silently_exit)\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	  unlink(cur_editfile);

	if (do_cursor) {
	  MoveCursor(elm_LINES,0);
	  NewLine();
	  Raw(OFF);
	}

	if (current_folder)
	  unlock (0,current_folder);

	exit(0);
}

/*ARGSUSED0*/

#ifndef REMOVE_AT_LAST
void leave_locked(val)
     int val;	/* not used, placeholder for signal catching! */
{
	/** same as leave routine, but don't disturb lock file **/

        int do_cursor = RawState();

/*
 *	some OS's get extra cont signal, so once this far into the
 *	exit, ignore those signals (Especially Ultrix)
 */
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
#ifdef SIGSTOP
	signal(SIGSTOP,SIG_IGN);
#endif
#ifdef SIGCONT
	signal(SIGCONT,SIG_IGN);
#endif

        dprint(3, (debugfile,
	    "\nLeaving mailer due to presence of lock file (leave_locked)\n"));

	/* softkeys_off(); */

	if (cur_editfile[0])
	  unlink(cur_editfile); /* editor buffer */

	if (current_folder) {

	  (void) unlink(current_folder->cur_tempfolder);			/* temp mailbox */

	  if (MAILFILE(current_folder))
	    flush_mailfile(current_folder);
	}

	if (do_cursor) {
	  MoveCursor(elm_LINES,0);
	  NewLine();
	  Raw(OFF);
	}

	exit(0);
}
#endif

int
get_page(msg_pointer)
int msg_pointer;
{
	/** Ensure that 'current' is on the displayed page,
	    returning NEW_PAGE iff the page changed! **/

	register int first_on_page, last_on_page;

	if (headers_per_page == 0)
	  return(SAME_PAGE); /* What else can I do ? */

	first_on_page = (header_page * headers_per_page) + 1;

	last_on_page = first_on_page + headers_per_page - 1;

	if (selected)	/* but what is it on the SCREEN??? */
	  msg_pointer = compute_visible(msg_pointer);

	if (selected && msg_pointer > selected)
	  return(SAME_PAGE);	/* too far - page can't change! */

	if (msg_pointer > last_on_page) {
	  header_page = (int) (msg_pointer-1)/ headers_per_page;
	  return(NEW_PAGE);
	}
	else if (msg_pointer < first_on_page) {
	  header_page = (int) (msg_pointer-1) / headers_per_page;
	  return(NEW_PAGE);
	}
	else
	  return(SAME_PAGE);
}

char *nameof(filename)
char *filename;
{
	/** checks to see if 'filename' has any common prefixes, if
	    so it returns a string that is the same filename, but
	    with '=' as the folder directory, or '~' as the home
	    directory..
	**/

	static char buffer[STRING];
	register int i = 0, iindex = 0, len;

	len = strlen(folders);
	if (strncmp(filename, folders, len) == 0 &&
	    len > 0 && (filename[len] == '/' || filename[len] == '\0')) {
	  buffer[i++] = '=';
	  iindex = len;
	  if(filename[iindex] == '/')
	    iindex++;
	}
	else
	{
	  len = strlen(home);
	  if (strncmp(filename, home, len) == 0 &&
	      len > 1 && (filename[len] == '/' || filename[len] == '\0')) {
	    buffer[i++] = '~';
	    iindex = len;
	  }
	  else iindex = 0;
	}

	while (filename[iindex] != '\0')
	  buffer[i++] = filename[iindex++];
	buffer[i] = '\0';

	return( (char *) buffer);
}

int elm_chown(file, userid, groupid)
char *file;
int userid, groupid;
{
#ifdef CHOWN_NEG1
	int status;

	status = chown(file, -1, groupid);
	chown(file, userid, -1);

	return(status);
#else
	return(chown(file, userid, groupid));
#endif
}
