
static char rcsid[] = "@(#)$Id: remail.c,v 1.6.4.2 1999/10/10 15:57:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.4.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** For those cases when you want to have a message continue along
    to another person in such a way as they end up receiving it with
    the reply address the person YOU received the mail from.

**/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

extern int errno;

char *error_description();
extern void display_to();

static void remail_sent P_((FILE *fd, char * title, struct run_state *rs,
			    int ret, int exit_stat));

int remail(void)
{
  /** remail a message... returns TRUE if new foot needed ... **/
  
  FILE *mailfd = NULL;

  char *filename = NULL, buffer[VERY_LONG_STRING], ch;
  char *mailerflags[20], **argv;
  int mf_idx = 0;
  int  err;
  extern char *tempnam();
  struct header_rec *current_header;
  int encoding = ENCODING_NONE;
  char title[80];
  struct mailing_headers mailing_headers;

  /* Actually headers are not written. headers structure is just
   * used to pass mailing addresses to backend .
   */
  zero_mailing_headers(&mailing_headers);
    
  if (!current_folder)
    return 0;

  current_header = headers[current-1];
  
  if (! get_to(&mailing_headers.to))
    goto free_it;
  
  display_to(mailing_headers.to);
    
  if((filename=tempnam(temp_dir, "snd.")) == NULL) {
    dprint(1, (debugfile, "couldn't make temp file nam! (remail)\n"));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntMakeTempFileName,
		      "Sorry - couldn't make file temp file name."));
    goto free_it;
  }

  if ((mailfd = safeopen_rdwr(filename)) == NULL) {
    err = errno;
    dprint(1, (debugfile, "couldn't open temp file %s! (remail)\n", 
	       filename));
    dprint(1, (debugfile, "** %s **\n", error_description(err)));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntOpenForWriting,
		      "Sorry - couldn't open file %s for writing (%s)."),
	      error_description(err));
    goto free_it;
  }

  /** now let's copy the message into the newly opened
      buffer... **/
  
  (void) elm_chown(filename, userid, groupid);
  
#ifdef MMDF
  if (strcmp(submitmail, mailer) == 0)
    do_mmdf_addresses(mailfd, &mailing_headers);
#endif /* MMDF */

  copy_message(MAILFILE(current_folder),current_header,
	       "", mailfd, 
	       CM_REMOVE_ENVELOPE |
	       CM_REMOTE | CM_MMDF_HEAD | CM_REMAIL);
  
  /** Got the messsage, now let's ensure the person really wants to 
      remail it... **/
  
  ClearLine(elm_LINES-1);
  ClearLine(elm_LINES);
  elm_sfprintf(buffer, sizeof buffer,
	       CATGETS(elm_msg_cat, ElmSet, ElmSureYouWantToRemail,
		       "Are you sure you want to remail this message (%c/%c)? "),
	       *def_ans_yes, *def_ans_no);
  fflush(stdin);
  ch = want_to(buffer, *def_ans_yes, elm_LINES-1, 0);
  if (ch == *def_ans_no) { /* another day, another No... */
    set_error(catgets(elm_msg_cat, ElmSet, ElmBounceCancelled,
		      "Bounce of message canceled."));
    goto free_it;
  }
  
  if (current_header -> status & MIME_MESSAGE) {
    encoding = current_header->mime_rec.encoding;
    
    if (encoding == ENCODING_BINARY && 
	!(current_header->binary)) {
      dprint(2,(debugfile,
		"Remail: resets encoding=BINARY to encoding=8BIT\n"));
      encoding = ENCODING_8BIT;
    }
  }

  elm_sfprintf(title, sizeof title,
	       CATGETS(elm_msg_cat, ElmSet, ElmRemailTo,
		       "Remail to %.50s..."),
	       mailing_headers.to.addrs ? mailing_headers.to.addrs[0].addr : 
	       "(someone)");
  
  mail_backend(mailfd,&mailing_headers,0,remail_sent,encoding,title,1);
  
 free_it:

  if(mailfd)
    fclose(mailfd);

  if (filename) {
    unlink(filename);
    free(filename);
  }

  free_mailing_headers(&mailing_headers);

  return(1);
}

static void remail_sent (fd,title,rs,ret,exit_code)
     FILE *fd; 
     char * title;
     struct run_state *rs;
     int ret; 
     int exit_code;
{
  char very_long_buffer[90];
  lower_prompt(title);

  if (ret < 0) 
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmFailSignal,
		      "%.30s fail: Signal?"),
	      mailer);
  else if (ret > 0) {
    if (rs->save_errno)
      lib_error(CATGETS(elm_msg_cat, ElmSet, 
			ElmFailErrno,
			"Failed: %.30s: %.40s"),
		mailer,error_description(rs->save_errno));
    else if (exit_code) {
      lib_error(CATGETS(elm_msg_cat, ElmSet, 
			ElmMailerReturnedError,
			"mailer returned error status %d"), 
		exit_code);
    } else
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailResent, "Mail resent."));
  } else {
    lib_error(CATGETS(elm_msg_cat, ElmSet, 
		      ElmLostErrno,"%.30s lost: %.40s"),
	      mailer,error_description(rs->save_errno));
  }
}

#ifdef MMDF
void do_mmdf_addresses(dest_file,headers)
     FILE *dest_file;
     struct mailing_headers * headers;
{
  struct addr_item *p;
  
  for (p = headers->to.addrs; 
	 p < headers->to.addrs + headers->to.addrs_len; 
	 p++)
    fprintf(dest_file, "%s\n", p->addr);    
  for (p = headers->cc.addrs; 
	 p < headers->cc.addrs + headers->cc.addrs_len; 
	 p++)
    fprintf(dest_file, "%s\n", p->addr);    
  for (p = headers->bcc.addrs; 
	 p  < headers->bcc.addrs + headers->bcc.addrs_len; 
	 p++)
    fprintf(dest_file, "%s\n", p->addr);    
  fprintf(dest_file, "\n");
}
#endif /* MMDF */
