static char rcsid[] = "@(#)$Id: read_rc.c,v 1.22.2.1.2.6 1999/11/07 17:33:04 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.22.2.1.2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************
 *
 * Most of code copied from ../src/read_rc.c. It have following copyright:
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#define SAVE_OPTS
#include "headers.h"
#include "save_opts.h"
#include "s_elm.h"
#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif

#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

#ifndef I_UNISTD 
char *getlogin();
unsigned short getgid(), getuid(); 
struct passwd *getpwuid();
#endif





#define ASSIGNMENT      0
#define WEEDOUT		1
#define ALTERNATIVES	2

#define SYSTEM_RC	0
#define LOCAL_RC	1

static int lineno = 0;
static int errors = 0;

static void do_expand_env P_((char *, char *, char *, unsigned));
static void do_rc P_((FILE *file,int lcl, char *filaname));
static int do_set P_((FILE *, char *, char *, int, int, char *));

#define  metachar(c)	(c == '+' || c == '%' || c == '=')
#ifndef ok_rc_char
#define ok_rc_char(c)   (isalnum(c) || c == '-' || c == '_')
#endif

char system_text_file[SLEN] = SYSTEM_TEXT_FILE;
char system_data_file[SLEN]  = SYSTEM_DATA_FILE;
char system_rc_file[SLEN]    = SYSTEM_RC_FILE;
char system_mime_types[SLEN] = SYSTEM_MIME_TYPES;
char hostdomfile[SLEN]       = HOSTDOMFILE;
char system_mime_charsets[SLEN] = SYSTEM_MIME_CHARSETS;

char user_rc_file[SLEN]   = ELMRCFILE;              /* user_init fixes */
char user_text_file[SLEN] = USER_ALIAS_TEXT;        /* user_init fixes */
char user_data_file[SLEN] = USER_ALIAS_DATA;        /* user_init fixes */
char user_mime_types[SLEN] = USER_MIME_TYPES;       /* user_init fixes */
char user_mailheaders[SLEN] = MAILHEADERS;          /* user_init fixes */
char user_mime_charsets[SLEN] = USER_MIME_CHARSETS; /* user_init fixes */

char defaultfile[SLEN] = {0};	/* name of default folder */
char calendar_file[SLEN] = {0};	/* name of file for clndr  */
char raw_calendar_file[SLEN] = {0};	/* unexpanded name of file for clndr  */
int clear_pages = 0;		/* flag: act like "page" (more -c)? */
int title_messages = 1;		/* flag: title message display?     */
int debug = 0; 			/* flag: default is no debug!       */
FILE *debugfile = stderr;	/* file for debug output            */

nl_catd  elm_msg_cat = 0;	/* message catalog	    */

char username[SLEN] = {0};	/* return address name!    */
char home[SLEN] = {0};		/* home directory of user  */
int userid;			/* uid for current user	      */
int groupid;			/* groupid for current user   */
#ifdef SAVE_GROUP_MAILBOX_ID
int mailgroupid;		/* groupid for current user   */
#endif
/* ------------- Variables in elmrc ------------------------------- */

int alias_sortby = NAME_SORT;	        /* how to sort aliases...   */
char alternative_editor[SLEN] = {0};	/* alternative editor...    */
struct addr_rec *alternative_addresses;	/* how else do we get mail? */
int always_del = 0;		/* flag: always delete marked msgs? */
int always_keep = 1;		/* flag: always keep unread msgs?   */
int always_store = 0;		/* flag: always store read msgs?    */
int arrow_cursor = 0;		/* flag: use "->" cursor regardless?*/
int question_me = 1;		/* flag: ask questions as we leave? */
int prompt_for_cc = 1;		/* flag: ask user for "cc:" value?  */
#ifdef USE_PGP
int pgp_askpgpsig=0; /* Should pgp ask userid to sign messages with? */
int pgp_sign_type=0;   /* 0 = application/pgp
			  1 = text/plain
			  2 = text/x-pgp
			  */
enum pgp_version send_pgp_version = pgp_none; /* preferred pgp version*/
#endif
char attribution[SLEN] = {0};	/* attribution string for replies   */
int auto_copy = 0;		/* flag: automatically copy source? */
#ifdef BACKGROUD_PROCESSES       
int background_wait_time = 2;    /* If > 0 background mailer after  */
				 /* this number of seconds          */
#endif
/* int bounceback = 0;	*/	/* flag: bounce copy off remote?    */
int builtin_lines= -3;		/* int: if < 0 use builtin if message*/
                                /* shorter than LINES+builtin_lines */
                                /* else use pager. If > 0 use builtin*/
                                /* if message has fewer than # of lines*/
char raw_charset[SLEN] = "DISPLAY";	/* name of character set            */
charset_t charset      = NULL;	/* pointer of character set         */
char config_options[SLEN] = {0};/* which options are in o)ptions    */
int confirm_append = 0;		/* flag: confirm append to folder?  */
int confirm_create = 0;		/* flag: confirm create new folder? */
int confirm_files = 0;		/* flag: confirm files for append?  */
int confirm_folders = 0;	/* flag: confirm folders for create?*/
int convert_comment = 1;        /* flag: convert comment to fullname ?  */
int auto_cc = 0;		/* flag: mail copy to user?	    */
char display_locale[SLEN] = "NONE";  /* LC_CTYPE locale (character set) */
char default_display_charset[SLEN] = {0};  /* the charset, the display supports */
charset_t display_charset      = NULL;  /* the charset, the display supports */
char raw_display_charset[SLEN] = "$MM_CHARSET";	
                               /* the charset, the display supports */
#ifdef USE_DSN
int DSN_success = 0;            /* flag: Ask successfull DSNes      */
#endif
char e_editor[SLEN] = {0};	/* "~e" editor...                   */
char editor[SLEN] = {0};	/* editor for outgoing mail*/
char raw_editor[SLEN] = {0};	/* unexpanded editor for outgoing mail*/
char escape_char = TILDE_ESCAPE;/* '~' or something else..          */
int force_name = 0;		/* flag: save by name forced?	    */
int allow_forms = NO;		/* flag: are AT&T Mail forms okay?  */
char full_username[SLEN] = {0};	/* Full username - gecos            */
char hostdomain[SLEN] = {0};	/* name of domain we're in          */
char hostfullname[SLEN] = {0};	/* name of FQDN we're in            */
char hostname[SLEN] = {0};	/* name of machine we're on         */
int keep_empty_files = 0;	/* flag: leave empty folder files?  */
#ifdef USE_PGP
int pgp_keeppassfor = 300;      /* 5 minutes                        */
#endif
/* int hp_terminal = 0;	*/	/* flag: are we on HP term?	    */
char local_signature[SLEN] = {0};   /* local msg signature file     */
char raw_local_signature[SLEN] = {0};	/* unexpanded local msg     */
                                /*               signature file     */
#ifdef SYSCALL_LOCKING
int lockfolders  = 1;           /* Lock folder when open */
int lock_in_copy = 1;           /* Lock folder when copied to it    */
#else
int lockfolders  = 0;           /* Lock folder when open */
int lock_in_copy = 0;           /* Lock folder when copied to it    */
#endif
char folders[SLEN] = {0};	/* folder home directory            */
char raw_folders[SLEN] = {0};	/* unexpanded folder home directory */
int mail_permissions = 0600;	/* int: permissions for mailbox files */
int mini_menu = 1;		/* flag: menu specified?	    */
char raw_metamail_path[SLEN] = METAMAIL_PATH;
char metamail_path[SLEN] = "metamail"; /* Metamail path or "none"   */
                                /* if no metamail                   */
int metoo = 0;			/* flag: copy me on mail to alias?  */
int mimeforward = FALSE;        /* falg: Forward as Message/rfc822  */
int move_when_paged = 0;	/* flag: move when '+' or '-' used? */
int names_only = 1;		/* flag: display user names only?   */
int allow_no_encoding = 0;      /* 1: Allow 8bit without -B8BITMIME */
                                /* 2: Allow binary without -BBINARYMIME and */
                                /*    and 8bit without -B8BITMIME   */
int allow_no_hdrencoding = 0;   /* TRUE, if header encoding is      */
				/* not required                     */
int noheader = 1;		/* flag: copy + header to file?     */
int noheaderfwd = 0;		/* flag: copy + header to file(fwd)? */
int pagealternative=1;          /* Page if alternative have one know*/
                                /* subtype ?                        */
int pagemultipart=0;            /* Page unknown mime subparts?      */
int pagesigned=0;               /* Page unknown signed protocols?   */
char pager[SLEN] = {0};		/* what pager to use                */
char raw_pager[SLEN] = {0};	/* unexpanded what pager to use     */
#ifdef USE_PGP
char pgp2_path[SLEN]   = "none"; /* Pgp path or "none" if no pgp     */
char raw_pgp2_path[SLEN] = PGP2_PATH;
char pgp5_dir[SLEN] = "none";   /* pgp5 binary directory or "none" if no pgp5 */
char raw_pgp5_dir[SLEN] = PGP5_DIR;
char gpg_path[SLEN]  = "none";
char raw_gpg_path[SLEN] = GPG_PATH;
#endif
int point_to_new = 1;		/* flag: start pointing at new msg? */
char allowed_precedences[SLEN] = {0};	/* list of precedences user */
                                /* may specify                      */
char prefixchars[SLEN] = "> ";	/* prefix char(s) for msgs          */
char printout[SLEN] = {0};	/* how to print messages            */
char raw_printout[SLEN] = DEFAULT_PRINTOUT;	
                                /* unexpanded how to print messages */
int prompt_after_pager = 1;	/* flag: prompt after pager exits   */
int quote_forward = 0;		/* flag: fwd'd msgs quoted like replies */
int readdatapercentinc = 5;	/* data percent increment during new mbox read */
int readmsginc = 100;		/* increment of msg cnt when reading*/
                                /* new mbox                         */
char recvd_mail[SLEN] = {0};	/* folder for storing received mail */
char raw_recvdmail[SLEN] = {0};	/* unexpanded recvd_mail name       */
char remote_signature[SLEN] = {0};  /* remote msg signature file    */
char raw_remote_signature[SLEN] = {0};	/* unexpanded remote msg    */
                                /* signature file                   */
int req_mime_bodyencoding = 1;  /*                                  */
int req_mime_hdrencoding = 0;   /*                                  */
int resolve_mode = 1;		/* flag: delete saved mail?	    */
int save_by_name = 1;		/* flag: save mail by login name?   */
char sent_mail[SLEN] = {0};	/* name of file to save copies to   */
int send_mime_plain  = 1;       /* flag: send plain text as MIME?   */
char raw_sentmail[SLEN] = {0};	/* unexpanded name of file to save to*/
char shell[SLEN] = {0};		/* current system shell             */
char raw_shell[SLEN] = {0};	/* unexpanded current system shell  */
#ifdef USE_PGP
int pgp_noarmor=1;      /* Should Elm display text before PGP armor */
#endif
int showto = 0;                 /*                                  */
int sig_dashes = 1;		/* flag: include dashes above sigs? */
int sleepmsg = 2;		/* time to sleep for messages being */
                                /* overwritten on screen            */
/* int hp_softkeys = 0;	*/	/* flag: are there softkeys?        */
int sortby = REVERSE SENT_DATE;	/* how to sort incoming mail...     */
long elm_timeout = 600L;	/* timeout (secs) on main prompt    */
int sort_thread_max_time = 30;  /* Number of days which can considered 
				    be same thread */
char temp_dir[SLEN] = {0};      /* name of temp directory           */
char raw_temp_dir[SLEN] = {0};  /* unexpanded name of temp directory*/
#ifdef USE_PGP
int pgp_keeppass=0;             /* should Elm keep the passphrase in*/
                                /* memory?                          */
#endif
int user_level = 0;		/* flag: how good is the user?      */
int use_tite = 1;		/* flag: use termcap/terminfo ti/te?*/
char v_editor[SLEN] = {0};	/* "~v" editor...                   */
int elm_filter = 1;		/* flag: weed out header lines?	    */
char *weedlist[MAX_IN_WEEDLIST] = {0}; /*                           */
int  weedcount;                 /*                                  */
/* ---------------------------------------------------------------- */

static void do_expand_env(descr, dest, src, destlen)
    char	*descr, *dest, *src;
    unsigned	destlen;
{
    if (expand_env(dest, src, destlen) != 0) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotInitErrorExpanding,
	    "Cannot initialize \"%s\" - error expanding \"%s\"."),
	    descr, src);
	errors++;
	dest[0] = '\0';
    }
}

/* sets locale and elm_msg_cat */
static int locale_init_called = 0;

void locale_init () {

#ifdef I_LOCALE
  char *res;

  if (setlocale(LC_ALL, "") == NULL) {
    lib_error(FRM("Elm: Unsupported locale (check $LANG)\n"));
    if (setlocale(LC_CTYPE,"") != NULL) {
      lib_error(FRM("Elm: ... but succeed setting of LC_CTYPE\n"));
    } else {
      lib_error(FRM("Elm: ... check also $LC_CTYPE\n"));
    }
    /* sleep if stderr points to terminal */
    if (isatty(2))
      sleep(1);
  }
#endif

  elm_msg_cat       = catopen("elm2.4me+", 0);

#ifdef  I_LOCALE
  res = setlocale(LC_CTYPE,NULL);
  if (!res) {
    lib_error(FRM("Elm: Unable to get current locale (LC_CTYPE)\n"));
    /* sleep if stderr points to terminal */
    if (isatty(2))
      sleep(1);
  } else
    strfcpy(display_locale,res, sizeof display_locale);
#endif
  
  locale_init_called++;
}

enum matches { match_exact = 0, match_charset, 
	       match_lang_country, match_lang, MATCH_COUNT };

static int set_charset P_((CONST char * rest, char *targ, int size));

static int set_charset(c1, targ, size)
     CONST char *c1;
     char *targ;
     int size;
{
  while (*c1 && whitespace (*c1)) /* skip leading whitespace */
    c1++;

  if (!*c1)
    return 0;

  if (targ[0])
    return -1;

  if (!get_charset_map_info(targ,c1,size))
    strfcpy(targ,c1, size);

  return 1;
}

struct locale_map_item  * system_locale_map = NULL;
struct locale_map_item  * user_locale_map   = NULL;

static void map_display_charset P_((CONST char * lc_ctype));
static void map_display_charset(lc_ctype)
     CONST char * lc_ctype;
{  
  CONST char *lang = NULL;
  CONST char *lang_country = NULL;
  CONST char *charset = NULL;
  charset_t d_matches[MATCH_COUNT];
  int i,j;

  char lbuf[3], cbuf[6];

  for (i = 0; i < MATCH_COUNT; i++)
    d_matches[i] = NULL;

  if (isascii(lc_ctype[0]) && isalpha(lc_ctype[0]) &&
      isascii(lc_ctype[1]) && isalpha(lc_ctype[1]) &&
      ('.' == lc_ctype[2] || '_' == lc_ctype[2] || '\0' == lc_ctype[2])) {
    strncpy(lbuf,lc_ctype,3);
    lbuf[2] = '\0';
    lang = lbuf;

    if ('_' == lc_ctype[2]) {
      if (isascii(lc_ctype[3]) && isalpha(lc_ctype[3]) &&
	  isascii(lc_ctype[4]) && isalpha(lc_ctype[4]) &&
	  ('.' == lc_ctype[5] || '\0' == lc_ctype[5])) {

	strncpy(cbuf,lc_ctype,6);
	cbuf[5] = '\0';
	lang_country = cbuf;

	if ('.' == lc_ctype[5])
	  charset = lc_ctype+6;
      }
    } else if ('.' == lc_ctype[2])
	  charset = lc_ctype+3;      
  }

  if (lang) {
    dprint (10, (debugfile, 
		"map_display_charset: %s -> lang: %s\n", 
		lc_ctype,lang));
  } 
  if (lang_country) {
    dprint (10, (debugfile, 
		"map_display_charset: %s -> lang_country: %s\n", 
		lc_ctype,lang_country));
  }
  if (charset) {
    dprint (10, (debugfile, 
		"map_display_charset: %s -> charset: %s\n", 
		lc_ctype,charset));
  }

  for (i = 0; i < 3; i++) {
      if ( i < 2) {
	  int k;
	  struct locale_map_item * F = user_locale_map;
	  int l = strlen(lc_ctype);
	  if (1 == i)
	      F = system_locale_map;

	  if (!F)
	      continue;

	  for (k = 0; F[k].charset; k++) {
	      if (F[k].match) {
		  if (istrcmp (F[k].match, lc_ctype) == 0) {
		      d_matches[match_exact] = F[k].charset;
		  
		      dprint (3, (debugfile, 
				  "map_display_charset: user defined \"%s\" as %s\n", 
				  lc_ctype, 
				  d_matches[match_exact]->MIME_name ?
				  d_matches[match_exact]->MIME_name :
				  "<no MIME name>"));
		  }
		  if (charset && strncmp(F[k].match,"*.",2) == 0  &&
		      istrcmp (F[k].match+2, charset) == 0) {
		  
		      d_matches[match_charset] = F[k].charset;
		      
		      dprint (3, (debugfile, 
				  "map_display_charset: user defined \"%s\" (*.%s) as %s\n", 
				  lc_ctype, charset,
				  d_matches[match_charset]->MIME_name ?
				  d_matches[match_charset]->MIME_name :
				  "<no MIME name>"));	      
		  }
		  if (lang_country && istrcmp (F[k].match, lang_country) == 0) {
		      d_matches[match_lang_country] = F[k].charset;
		      dprint (3, (debugfile, 
				  "map_display_charset: user defined \"%s\" (%s) as %s\n", 
				  lc_ctype, lang_country, 
				  d_matches[match_lang_country]->MIME_name ?
				  d_matches[match_lang_country]->MIME_name :
				  "<no MIME name>")); 
		      
		  }
	      
		  if (lang_country && istrcmp (F[k].match, lang) == 0) {
		      d_matches[match_lang] = F[k].charset;
		      
		      dprint (3, (debugfile, 
				  "map_display_charset: user defined \"%s\" (%s) as %s\n", 
				  lc_ctype, lang, 
				  d_matches[match_lang]->MIME_name ?
				  d_matches[match_lang]->MIME_name :
				  "<no MIME name>"));
		  }
	      }
	  }

	  for (j = 0; j < MATCH_COUNT; j++)
	      if (d_matches[j]) {
		  display_charset = d_matches[j];
		  
		  dprint (3, (debugfile, 
			      "map_display_charset: using match %d: user defined \"%s\" as %s\n", 
			      j,lc_ctype, 
			      display_charset->MIME_name ?
			      display_charset->MIME_name :
			      "<no MIME name>"));

		  return;
	      }
      } else {
	  int val;
	  char buffer[STRING];
	  
	  if (0 == strcmp(lc_ctype,"C"))
	      display_charset = MIME_name_to_charset("US-ASCII",1); 
	  else if (0 == istrcmp(lc_ctype,"ASCII") ||
		   0 == istrcmp(lc_ctype,"US-ASCII"))
	      display_charset = MIME_name_to_charset("US_ASCII",1);
	  else if (0 == strincmp(lc_ctype,"ISO-8859-",9) &&
		   0 < (val = atoi(lc_ctype+9))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (0 == strincmp(lc_ctype,"ISO_8859-",9) &&
		     0 < (val = atoi(lc_ctype+9))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (0 == strincmp(lc_ctype,"ISO8859-",8) &&
		     0 < (val = atoi(lc_ctype+8))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (charset && (0 == istrcmp(charset,"ASCII") ||
				 0 == istrcmp(charset,"US-ASCII")))
	      display_charset = MIME_name_to_charset("US-ASCII",1);
	  else if (charset &&
		   0 == strincmp(charset,"ISO-8859-",9) &&
		   0 < (val = atoi(charset+9))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (charset &&
		     0 == strincmp(charset,"ISO_8859-",9) &&
		     0 < (val = atoi(charset+9))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (charset &&
		     0 == strincmp(charset,"ISO8859-",8) &&
		     0 < (val = atoi(charset+8))) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%d"),
			   val);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else if (charset &&
		     0 == strincmp(charset,"ISO8859",7) &&
		     isascii(charset[7]) && isdigit(charset[7]) && 
		     '\0' == charset[8]) {
	      elm_sfprintf(buffer, sizeof buffer,
			   FRM("ISO-8859-%c"),
			   charset[7]);
	      display_charset = MIME_name_to_charset(buffer,1);
	  } else {
	      display_charset = MIME_name_to_charset(default_display_charset,
						     1);
	      
	      lib_error(FRM("Elm: Unable to map %.20s locale (LC_CTYPE) to MIME charset"),
			lc_ctype);
	      lib_error(FRM("     Using default (%.20s). Check %.100s or\n      %.100s"),
			default_display_charset,system_mime_charsets,
			user_mime_charsets);
	      /* sleep if stderr points to terminal */
	      if (isatty(2))
		  sleep(1);	
	  }
	  dprint (3, (debugfile, 
		      "map_display_charset: default \"%s\" as \"%s\"\n", 
		      lc_ctype, display_charset->MIME_name));
      }
  }
}


void user_init() {
  char *cp;


	/** initialize the whole ball of wax.
	**/
	struct passwd *pass, *getpwnam();

	if (!locale_init_called)
	  locale_init ();

	userid  = getuid();
	groupid = getgid();	

	/* Get username (logname), home (login directory), and full_username
	 * (part of GCOS) field from the password entry for this user id.
	 * Full_username will get overridden by fullname in elmrc, if defined.
	 *
	 * For those sites that have various user names with the same user
	 * ID, use the passwd entry corresponding to the user name as long 
	 * as it matches the user ID.  Otherwise fall back on the entry 
	 * associated with the user ID alone.
	 */

	if((cp = getenv("LOGNAME")) == NULL)
		cp = getenv("USER");
	if(cp != NULL && (pass = getpwnam(cp)) != NULL &&
	    pass->pw_uid == userid) {
	  ;  /* Null body */
	} else if((pass = getpwuid(userid)) == NULL) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmYouHaveNoPasswordEntry,
			    "You have no password entry!"));
	  exit(1);
	}
	strfcpy(username, pass->pw_name, sizeof username);
	strfcpy(home, pass->pw_dir, sizeof home);
	strfcpy(shell, pass->pw_shell, sizeof shell);
	/* Null shell in /etc/passwd means /bin/sh */
	if ('\0' == shell[0]) 
	  strfcpy(shell, "/bin/sh", sizeof shell);

	if((cp = get_full_name(username)) != NULL)
	  strfcpy(full_username, cp, sizeof full_username);
	else
	  strfcpy(full_username, username, sizeof full_username);	
	/* fall back on logname */


	elm_sfprintf(user_rc_file, sizeof user_rc_file,
		     FRM("%s/%s"), home, ELMRCFILE);
	elm_sfprintf(user_text_file, sizeof user_text_file,
		     FRM("%s/%s"), home, USER_ALIAS_TEXT);
	elm_sfprintf(user_data_file, sizeof user_data_file,
		     FRM("%s/%s"), home, USER_ALIAS_DATA);
	elm_sfprintf(user_mime_types, sizeof user_mime_types,
		     FRM("%s/%s"), home, USER_MIME_TYPES);
	elm_sfprintf(user_mailheaders, sizeof user_mailheaders,
		     FRM("%s/%s"), home, MAILHEADERS);
	elm_sfprintf(user_mime_charsets, sizeof user_mime_charsets,
		     FRM("%s/%s"), home, USER_MIME_CHARSETS);
}

static void default_weedlist P_((void));

int init_defaults() {
  char     buffer[SLEN], *cp;
  FILE * file;
  int hostlen, domlen;

  /* Establish some defaults in case elmrc is incomplete or not there.
   * Defaults for other elmrc options were established in their
   * declaration - in elm.h.  And defaults for sent_mail and recvd_mail
   * are established after the elmrc is read in since these default
   * are based on the folders directory name, which may be given
   * in the emrc.
   * Also establish alternative_editor here since it is based on
   * the default editor and not on the one that might be given in the
   * elmrc.
   */
	 
  default_weedlist();
  errors = 0;

  /*
   * Get the host name as per configured behavior.
   */
#ifdef HOSTCOMPILED
  strfcpy(hostname, HOSTNAME, sizeof(hostname));
#else
  gethostname(hostname, sizeof(hostname));
#endif

  /*
   * now get the domain name, used to build the full name
   */
  gethostdomain(hostdomain, sizeof(hostdomain));
  
  /*
   * now the tough part:
   *	we need to make three variables out of this stuff:
   *	hostname = just the hostname, as in bangpaths,
   *		this is whatever the user gave us so far,
   *		we wont change this one
   *	hostdomain = this is the domain considered local to this
   *		machine, and should be what we got above.
   *	hostfullname = this is the full FQDN of this machine,
   *		and is a strange combination of the first two.
   *	if tail(hostname) == hostdomain
   *		then hostfullname = hostname
   *			ie: node.ld.domain.type, ld.domain.type -> node.ld.domain.type
   *	else if hostname == hostdomain + 1
   *		then hostfullname = hostname
   *			ie: domain.type, .domain.type -> domain.type
   *	
   *	else hostfullname = hostname + hostdomain
   *			ie: host, .domain.type -> host.domain.type
   * lost yet?
   */
  hostlen = strlen(hostname);
  domlen = strlen(hostdomain);
  if (hostlen >= domlen) {
    if (istrcmp(&hostname[hostlen - domlen], hostdomain) == 0)
      strfcpy(hostfullname, hostname, sizeof hostfullname);
    else {
      strfcpy(hostfullname, hostname, sizeof hostfullname);
      strfcat(hostfullname, hostdomain, sizeof hostfullname);
    }
  } else {
    if (istrcmp(hostname, hostdomain + 1) == 0)
      strfcpy(hostfullname, hostname, sizeof hostfullname);
    else {
      strfcpy(hostfullname, hostname, sizeof hostfullname);
      strfcat(hostfullname, hostdomain, sizeof hostfullname);
    }
  }
  
  /* Determine the default mail file name.
   * 
   * First look for an environment variable MAIL, then
   * use then mailhome if it is not found
   */
  if ((cp = getenv("MAIL")) == NULL)
    elm_sfprintf(defaultfile, sizeof defaultfile,
		 FRM("%s%s"), mailhome, username);
  else
    strfcpy(defaultfile, cp, sizeof defaultfile);

  alternative_addresses = NULL; 	/* none yet! */
  
  raw_local_signature[0] = raw_remote_signature[0] =
    local_signature[0] = remote_signature[0] =
    raw_recvdmail[0] = raw_sentmail[0] = 
    allowed_precedences[0] = '\0';
  /* no defaults for those */

  if (NULL != (cp = getenv("SHELL")) && '\0' != cp[0]) {
    strfcpy(raw_shell, "$SHELL", sizeof raw_shell);
    do_expand_env("shell", shell, raw_shell, sizeof(shell));
  } else {
    /* Shell is set from /etc/passwd in initialize () */
    raw_shell[0] = '\0';
  }
  strfcpy(raw_pager, ((cp = getenv("PAGER")) == NULL)? default_pager : cp,
	  sizeof raw_pager);
  do_expand_env("pager", pager, raw_pager, sizeof(pager));
  
  strfcpy(raw_temp_dir, (cp = getenv("TMPDIR")) ? cp : default_temp,
	  sizeof raw_temp_dir);

  do_expand_env("temp_dir", temp_dir, raw_temp_dir, sizeof(temp_dir));
  if (temp_dir[0] == '\0' || 
      temp_dir[strlen (temp_dir)-1] != '/')
    strfcat(temp_dir, "/", sizeof temp_dir);
  
  if ((cp = getenv("EDITOR")) != NULL && '\0' != cp[0]) {
    strfcpy(raw_editor, "$EDITOR", sizeof raw_editor);
    strfcpy(editor, cp, sizeof editor);
  } else {
    strfcpy(raw_editor, default_editor, sizeof raw_editor);
    do_expand_env("editor", editor, raw_editor, sizeof(editor));
  }

  strfcpy(alternative_editor, editor, sizeof alternative_editor);
    
  elm_sfprintf(raw_folders, sizeof raw_folders, FRM("~/%s"), default_folders);
  do_expand_env("folders", folders, raw_folders, sizeof(folders));
  
  elm_sfprintf(raw_calendar_file, sizeof raw_calendar_file,
	       FRM("~/%s"), dflt_calendar_file);
  do_expand_env("calendar_file", calendar_file, raw_calendar_file,
		sizeof(calendar_file));

  strfcpy(e_editor, emacs_editor, sizeof e_editor);
  strfcpy(v_editor, default_editor, sizeof v_editor);
  
  elm_sfprintf(raw_folders, sizeof raw_folders,
	       FRM("%s/%s"), home, default_folders);
  strfcpy(folders, raw_folders, sizeof folders);

  elm_sfprintf(raw_calendar_file, sizeof raw_calendar_file,
	       FRM("%s/%s"), home, dflt_calendar_file);
  strfcpy(calendar_file, raw_calendar_file, sizeof calendar_file);

  charset = MIME_name_to_charset(default_charset,1);
  if (!getenv("NOMETAMAIL") && getenv("MM_CHARSET"))
    strfcpy(raw_display_charset, "$MM_CHARSET",
	    sizeof raw_display_charset);
  else
    strfcpy(raw_display_charset, DEFAULT_DISPLAY_CHARSET,
	    sizeof raw_display_charset);

  /* try system-wide rc file */
  file = fopen(system_rc_file, "r");
  if ( file != NULL ) {
    do_rc(file, SYSTEM_RC,system_rc_file);
    fclose(file);
  }
  system_locale_map = load_locale_map(system_mime_charsets);

  return errors;
}

static void dump_rc_results P_((void));

int read_rc_file()
{
	/** this routine does all the actual work of reading in the
	    .rc file... **/

	FILE *file;
	char buffer[SLEN], filename[SLEN], *cp, 
	     	temp[SLEN]; /* for when an option is run through expandenv */
	int  i, ch, len, err;

	errors = 0;

	/* Look for the elmrc file */
	if ((file = fopen(user_rc_file, "r")) == NULL) {
	  dprint(2, (debugfile, 
		     "Warning:User has no \"%s\" file\n\n",
		     user_rc_file));
	}

	if (file != NULL) {
  	  do_rc(file, LOCAL_RC, ELMRCFILE);
	  fclose(file);
	}

	user_locale_map = load_locale_map(user_mime_charsets);

	post_init_check();

	return errors;
}

void post_init_check() {
	char     buffer[SLEN];

	do_expand_env("folders", folders, raw_folders, sizeof(folders));

	do_expand_env("temp_dir", temp_dir, raw_temp_dir, sizeof(temp_dir));
  	if ('\0' == temp_dir[0])
	  strfcpy(temp_dir,"/tmp/", sizeof temp_dir);
	else if (temp_dir[strlen (temp_dir)-1] != '/')
	  strfcat(temp_dir, "/", sizeof temp_dir);
  
	if (raw_shell[0] != '\0') {
	  /* shell is taken from /etc/passwd in initialize() */
	  do_expand_env("shell", shell, raw_shell, sizeof(shell));
	}
	do_expand_env("editor", editor, raw_editor, sizeof(editor));

	do_expand_env("calendar_file", calendar_file, raw_calendar_file,
	    sizeof(calendar_file));

	if (strcmp(raw_printout,"none") == 0 || 
	    raw_printout[0] == '\0') {
	  strfcpy(raw_printout,"none", sizeof raw_printout);
	  strfcpy(printout,"none", sizeof printout);
	} else {
	  do_expand_env("printout", printout, raw_printout, sizeof(printout));
	}

	do_expand_env("pager", pager, raw_pager, sizeof(pager));
	if (equal(pager, "builtin+") || equal(pager, "internal+"))
		clear_pages++;

	do_expand_env("local_signature", local_signature,
	    raw_local_signature, sizeof(local_signature));
	do_expand_env("remote_signature", remote_signature,
	    raw_remote_signature, sizeof(remote_signature));

	if (equal(local_signature, remote_signature) &&
	    (equal(shift_lower(local_signature), "on") ||
	    equal(shift_lower(local_signature), "off"))) {
	    errors++;

	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSignatureObsolete,
			      "\"signature\" used in obsolete way in .elm/elmrc file. Ignored!\n\
\t(Signature should specify the filename to use rather than on/off.)"));

	    raw_local_signature[0] = raw_remote_signature[0] =
		local_signature[0] = remote_signature[0] = '\0';
	}

	/* if (hp_softkeys) hp_terminal=TRUE; */	/* must be set also! */

	allow_forms = (allow_forms?MAYBE:NO);

	if ((elm_timeout != 0) && (elm_timeout < 10)) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTimeoutLTTen,
			      "Warning: timeout is set to less than 10 seconds. Ignored."));
	    elm_timeout = 0;
	}

	if (readdatapercentinc < 1) {
		errors++;
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReadDataIncrement,
				  "Warning: readdatapercentinc is set to less than 1.  Ignored."));
		readdatapercentinc = 1;
	}

	if (readmsginc < 1) {
		errors++;
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReadMessageIncrement,
				  "Warning: readmsginc is set to less than 1.  Ignored."));
		readmsginc = 1;
	}


	if (sleepmsg < 0) {
		errors++;
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSleepMessageInvalid,
				  "Warning: sleepmsg is set to less than 0.  Setting to 0."));
		sleepmsg = 0;
	}

#ifdef BACKGROUD_PROCESSES       
	if (background_wait_time  < 0) {
	  errors++;
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBackgroundLLT,
			    "Warning: background_wait_time is set less than 0. Setting to 0."));
	  background_wait_time = 0;
	}
#endif


	/* If recvd_mail or sent_mail havent't yet been established in
	 * the elmrc, establish them from their defaults.
	 * Then if they begin with a metacharacter, replace it with the
	 * folders directory name.
	 */
	if(*raw_recvdmail == '\0') {
	  strfcpy(raw_recvdmail, default_recvdmail,
		  sizeof raw_recvdmail);
	}

	do_expand_env("recvd_mail", recvd_mail, raw_recvdmail,
	    sizeof(recvd_mail));

	if(metachar(recvd_mail[0])) {
	  strfcpy(buffer, &recvd_mail[1], sizeof buffer);
	  elm_sfprintf(recvd_mail, sizeof recvd_mail,
		       FRM("%s/%s"), folders, buffer);
	}

	if(*raw_sentmail == '\0') {
	  strfcpy(raw_sentmail, default_sentmail, sizeof raw_sentmail);
	  strfcpy(sent_mail, default_sentmail, sizeof sent_mail);
	}

	do_expand_env("sent_mail", sent_mail, raw_sentmail, sizeof(sent_mail));

	if(metachar(sent_mail[0])) {
	  strfcpy(buffer, &sent_mail[1], sizeof buffer);
	  elm_sfprintf(sent_mail, sizeof sent_mail,
		       FRM("%s/%s"), folders, buffer);
	}

	if (!get_charset_map_info(default_display_charset,
				  raw_display_charset, 
				  sizeof(default_display_charset)))
	  do_expand_env("display_charset", default_display_charset, 
			raw_display_charset, 
			sizeof(default_display_charset));

	if (0 != strcmp(display_locale,"NONE"))
	    map_display_charset(display_locale);
	else
	    display_charset = MIME_name_to_charset(default_display_charset,1);

	if (0 != strcmp(raw_charset,"DISPLAY")) {
	    char buffer[LONG_STRING];
	    if (!get_charset_map_info(buffer,raw_charset, 
				      sizeof buffer))
		do_expand_env("charset", buffer, 
			      raw_charset, 
			      sizeof(buffer));
	    charset = MIME_name_to_charset(buffer,1);
	} else if (display_charset->MIME_name)
	    charset = display_charset;
	else {
	    charset = MIME_name_to_charset(default_display_charset,1);
	}

	if (strcmp(raw_metamail_path,"none") == 0 || 
	    raw_metamail_path[0] == '\0') {
	  strfcpy(raw_metamail_path,"none", sizeof raw_metamail_path);
	  strfcpy(metamail_path,"none", sizeof metamail_path);
	} else if(strcmp(raw_metamail_path,"metamail") == 0) {
	  if (getenv("NOMETAMAIL"))
	    strfcpy(metamail_path,"none", sizeof metamail_path);
	  else
	    strfcpy(metamail_path,"metamail", sizeof metamail_path);
	} else {
	  do_expand_env("metamail", metamail_path, raw_metamail_path, 
			sizeof(metamail_path));
	}

#ifdef USE_PGP
	if (strcmp(raw_pgp2_path,"none") == 0 || 
	    raw_pgp2_path[0] == '\0') {
	    strfcpy(raw_pgp2_path,"none", sizeof raw_pgp2_path);
	    strfcpy(pgp2_path,"none", sizeof pgp2_path);
	} else {
	    do_expand_env("pgp2", pgp2_path, raw_pgp2_path, 
			  sizeof(pgp2_path));
	}
	if (strcmp(raw_pgp5_dir,"none") == 0 || 
	    raw_pgp5_dir[0] == '\0') {
	    strfcpy(raw_pgp5_dir,"none", sizeof raw_pgp5_dir);
	    strfcpy(pgp5_dir,"none", sizeof pgp5_dir);
	} else {
	    do_expand_env("pgp5", pgp5_dir, raw_pgp5_dir, 
			  sizeof(pgp5_dir));
	}
	if (strcmp(raw_gpg_path,"none") == 0 || 
	    raw_gpg_path[0] == '\0') {
	    strfcpy(raw_gpg_path,"none", sizeof raw_gpg_path);
	    strfcpy(gpg_path,"none", sizeof gpg_path);
	} else {
	    do_expand_env("gpg", gpg_path, raw_gpg_path, 
			  sizeof(gpg_path));
	}
	if (pgp_none == send_pgp_version) {
	    if ('/' == gpg_path[0]) send_pgp_version = gpg;
	    if ('/' == pgp5_dir[0]) send_pgp_version = pgp5;
	    if ('/' == pgp2_path[0]) send_pgp_version = pgp2;
	}
#endif
}

static void weedout P_((char *)); /* Prototype */
static void alternatives P_((char *));      /* Prototype */
static int breakup P_((char *, char *, char *, int, int)); /* Prototype */

void do_rc(file, lcl, filename)
     FILE *file;
     int lcl;
     char *filename;
{
	static int prev_type = 0;
	int x;
	char buffer[SLEN], word1[SLEN], word2[SLEN];

	if (!file) return;
	lineno=0;

	while (x = mail_gets(buffer, SLEN, file)) {
	    lineno++;
	    no_ret(buffer);	 	/* remove return */
	    if (buffer[0] == '#'        /* comment       */
	     || x < 2)     /* empty line    */
	      continue;

	    if(breakup(buffer, word1, word2,
		       sizeof word1, sizeof word2) == -1)
	        continue;		/* word2 is null - let default value stand */

	    if(strcmp(word1, "warnings") == 0)
		continue;		/* grandfather old keywords */

	    strfcpy(word1, shift_lower(word1), 
		    sizeof word1);	/* to lower case */
	    x = do_set(file, word1, word2, lcl, 
		       sizeof word2, filename);

	    if (x == 0) {
		if (prev_type == DT_ALT) {
		    alternatives(buffer);
		} else if (prev_type == DT_WEE) {
		    weedout(buffer);
		} else {
		    errors++;
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadKeyInElmrc,
				      "I can't understand keyword \"%s\" in line %d in \"%s\" file"),
			word1, lineno,filename);
		}
	    } else
		prev_type = x;
	}
}

/*
 * set the named parameter according to save_info structure.
 * This routine may call itself (DT_SYN or DT_MLT).
 * Also tags params that were set in "local" (personal) RC file
 * so we know to save them back out in "o)ptions" screen.
 * Uses an internal table to decode sort-by params...should be coupled
 * with sort_name(), etc...but...
 */

int do_set(file, word1, word2, lcl, word2_size, filename)
     FILE *file;
     int lcl;
     char *word1, *word2;
     int word2_size;
     char *filename;
{
	int x, y;
	int e_val = 0;

	for (x=0; x < NUMBER_OF_SAVEABLE_OPTIONS; ++x) {
	    y = strcmp(word1, save_info[x].name);
	    if (y <= 0)
		break;
	}

	if (y != 0)
	    return(0);

	if (save_info[x].flags & FL_SYS && lcl == LOCAL_RC)
	    return(0);

	if (lcl == LOCAL_RC)
	    save_info[x].flags |= FL_LOCAL;

	if (save_info[x].e_ptr) {
	  int ci = -1, i;
	  e_val = 0;    /* First value is 'unknown' */

	  for (i = 0; i < save_info[x].e_ptr->nlen; i++)
	    if (0 == strcmp(save_info[x].e_ptr->list[i],word2)) {
	      e_val = i;
	      break;
	    } else if (0 == istrcmp(save_info[x].e_ptr->list[i],word2))
	      ci = i;
	  if (!e_val && ci >= 0)
	    e_val = ci;

	  if (i == save_info[x].e_ptr->nlen) {
	    char *p;	    
	    if (
		((save_info[x].flags & DT_MASK) != DT_NUM || 
		 strtol(word2,&p,10) < 0) || *p != '\0'
		) { 
	      
	      errors++;
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadEKeyInElmrc,
				"I can't understand %s key \"%s\" in line %d in \"%s\" file"),
			word1,word2, lineno,filename);
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadEKeyValues,
				"Possible values are:"));
	      for (i = 0; i < save_info[x].e_ptr->nlen; i++)
		lib_error(FRM(" - %s"),save_info[x].e_ptr->list[i]);
	    }
	  }

	} else
	  e_val = 0;

	switch (save_info[x].flags & DT_MASK) {
	    int l;
	    char *p;
	    case DT_SYN:
		return(do_set(file, SAVE_INFO_SYN(x), word2, lcl,
			      word2_size, filename));

	    case DT_MLT:
		y=0;
		{ register char **s;
		for (s = SAVE_INFO_MLT(x); *s; ++s)
		    y |= do_set(file, *s, word2, lcl, word2_size,filename);
		}

/* a kludge that should be part of the "machine", but... */
		if (equal(save_info[x].name, "alwaysleave")) {
		    always_store = !always_store;
		}
		return(y); /* we shouldn't "or" the values into "y" */

	case DT_STR:
	      if (strlen(word2) >= save_info[x].size_val) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLongValueInElmrc,
				    "Value of \"%s\" in line %d in \"%s\" file is too long"),
			    word1,lineno,filename);
		  errors++;
	      }
	      strfcpy(SAVE_INFO_STR(x), word2,
		      save_info[x].size_val);
	      if (save_info[x].flags & FL_NOSPC) {
		register char *s;
		for (s = SAVE_INFO_STR(x); *s; ++s)
		  if (*s == '_') *s=' ';
	      }
	      break;

	case DT_CHR:
		*SAVE_INFO_CHR(x) = word2[0];
		break;


	case DT_LONG:
	        l = strtol(word2,&p,10);
		*SAVE_INFO_LONG(x) = l;
		break;

#ifdef USE_PGP
	case DT_PGPVER:
		*SAVE_INFO_PGPVER(x) = (enum pgp_version) e_val;
		break;
#endif

	case DT_NUM:
	        l = strtol(word2,&p,10);
	        if (save_info[x].e_ptr && (e_val || *p || l < 0))
		  *SAVE_INFO_NUM(x) = e_val;
		else
		  *SAVE_INFO_NUM(x) = l;
		break;

	case DT_FUNC:
	    if (!SAVE_INFO_FUNC(x)(&word2,1)) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadValueInElmrc,
				  "Value of \"%s\" in line %d in \"%s\" file is bad"),
			  word1,lineno,filename);
		errors++;
	    }
	    break;
	case DT_PRM:
	    {
		    char *s = word2;
		    int m = 0;
		    char *modecharp = "rwxrwxrwx";
		    int modebit = 0400;
		    char c;

		    while ((c = *s++) != '\0') {
		    	if (c == *modecharp)
			    m |= modebit;
			else if (c != '-') {
			    errors++;
			    lib_error(CATGETS(elm_msg_cat, ElmSet, 
					      ElmBadModeInElmrc,
					      "I can't understand file permissions \"%s\" in line %d in \"%s\" file"),
				      word2, lineno,filename);
			    goto out;
			}
			modecharp++;
			modebit >>= 1;
		    }
		    if (*modecharp != '\0') {
		      errors++;
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadModeInElmrc,
					"I can't understand file permissions \"%s\" in line %d in \"%s\" file"),
			     word2, lineno,filename);
		      break;
		    }
		    *SAVE_INFO_NUM(x) = m;
		}
	out:
	        break;

	    case DT_BOL:
		if (save_info[x].flags & FL_OR)
		    *SAVE_INFO_BOL(x) |= is_it_on(word2);
		else if (save_info[x].flags & FL_AND)
		    *SAVE_INFO_BOL(x) &= is_it_on(word2);
		else
		    *SAVE_INFO_BOL(x) = is_it_on(word2);
		break;

	    case DT_SRT:
		{ static struct { char *kw; int sv; } srtval[]={
		    {"sent", SENT_DATE},
		    {"thread", THREAD},
		    {"received", RECEIVED_DATE},
		    {"recieved", RECEIVED_DATE},
		    {"rec", RECEIVED_DATE},
		    {"from", SENDER},
		    {"sender", SENDER},
		    {"size", SIZE},
		    {"lines", SIZE},
		    {"subject", SUBJECT},
		    {"mailbox", MAILBOX_ORDER},
		    {"folder", MAILBOX_ORDER},
		    {"status", STATUS},
		    {NULL, 0} };
		    char *s = word2;
		    int f;

		    f = 1;
		    strfcpy(word2, shift_lower(word2), word2_size);
		    if (strncmp(s, "rev-", 4) == 0 ||
			strncmp(s, "reverse-", 8) == 0) {
			f = -f;
			s = index(s, '-') + 1;
		    }

		    for (y= 0; srtval[y].kw; y++) {
			if (equal(s, srtval[y].kw))
			    break;
		    }
		    if (srtval[y].kw) {
			*SAVE_INFO_SRT(x) = f > 0 ? srtval[y].sv : -srtval[y].sv;
		    } else {
			errors++;
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmBadSortKeyInElmrc,
					  "I can't understand sort key \"%s\" in line %d in \"%s\" file"),
				  word2, lineno, filename);
		    }
		}
		break;

	    case DT_ASR:
		{ static struct { char *kw; int sv; } srtval[]={
		    {"alias", ALIAS_SORT},
		    {"name", NAME_SORT},
		    {"text", TEXT_SORT},
		    {NULL, 0} };
		    char *s = word2;
		    int f;

		    f = 1;
		    strfcpy(word2, shift_lower(word2), word2_size);
		    if (strncmp(s, "rev-", 4) == 0 ||
			strncmp(s, "reverse-", 8) == 0) {
			f = -f;
			s = index(s, '-') + 1;
		    }

		    for (y= 0; srtval[y].kw; y++) {
			if (equal(s, srtval[y].kw))
			    break;
		    }
		    if (srtval[y].kw) {
			*SAVE_INFO_SRT(x) = f > 0 ? srtval[y].sv : -srtval[y].sv;
		    } else {
			errors++;
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmBadAliasSortInElmrc,
					  "I can't understand alias sort key \"%s\" in line %d in \"%s\" file"),
				  word2, lineno,filename);
		    }
		}
		break;

	    case DT_ALT:
		alternatives(word2);
		break;

	    case DT_WEE:
		weedout(word2);
		break;
	    }

	return(save_info[x].flags & DT_MASK);
}
	
static void weedout(string)
     char *string;
{
	/** This routine is called with a list of headers to weed out.   **/

	char *strptr, *header, *p;
	int Len;
	int finished;

	finished = FALSE;
	strptr = string;
	while (!finished && (header = strtokq(strptr, "\t ,", TRUE)) != NULL) {
	  strptr = NULL;

	  if (!*header)
	    continue;

	  for (p = header; *p; ++p) {
	    if (*p == '_')
	      *p = ' ';
	  }

	  if (! istrcmp(header, "*end-of-user-headers*"))
	    break;

	  if (! istrcmp(header, "*end-of-defaults*"))
	    finished = TRUE;

	  if (! istrcmp(header, "*clear-weed-list*")) {
	    while (weedcount)
	      free(weedlist[--weedcount]);
	    header = "*end-of-defaults*";
	  }

	  if (matches_weedlist(header))
	    continue;

	  if (weedcount > MAX_IN_WEEDLIST) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTooManyWeedHeaders,
			      "Too many weed headers!  Leaving..."));
	    exit(1);
	  }
	  Len = strlen(header) + 1;
	  if ((p = malloc(Len)) == NULL) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTooManyWeedPmalloc,
			      "Too many weed headers!  Out of memory!  Leaving..."));
	    exit(1);
	  }
	  strfcpy(p, header, Len);
	  weedlist[weedcount++] = p;
	}
}

static void alternatives(string)
     char *string;
{
	/** This routine is called with a list of alternative addresses
	    that you may receive mail from (forwarded) **/

	char *strptr, *address;
	struct addr_rec *current_record, *previous_record;

	previous_record = alternative_addresses;	/* start 'er up! */
	/* move to the END of the alternative addresses list */

	if (previous_record != NULL)
	  while (previous_record->next != NULL)
	    previous_record = previous_record->next;

	strptr = (char *) string;

	while ((address = strtok(strptr, "\t ,\"'")) != NULL) {
	  if (previous_record == NULL) {
	    previous_record = (struct addr_rec *) pmalloc(sizeof 
		*alternative_addresses);

	    strfcpy(previous_record->address, address,
		    sizeof previous_record->address);
	    previous_record->next = NULL;
	    alternative_addresses = previous_record;
	  }
	  else {
	    current_record = (struct addr_rec *) pmalloc(sizeof 
		*alternative_addresses);
	  
	    strfcpy(current_record->address, address,
		    sizeof current_record->address);
	    current_record->next = NULL;
	    previous_record->next = current_record;
	    previous_record = current_record;
	  }
	  strptr = (char *) NULL;
	}
}

static void default_weedlist()
{
	/** Install the default headers to weed out!  Many gracious 
	    thanks to John Lebovitz for this dynamic method of 
	    allocation!
	**/

	static char *default_list[] = { ">From", "In-Reply-To:",
		       "References:", "Newsgroups:", "Received:",
		       "Apparently-To:", "Message-Id:", "Content-Type:",
		       "Content-Length", "MIME-Version",
		       "Content-Transfer-Encoding",
		       "From", "X-Mailer:", "Status:",
		       "X-ELM-",
		       "*end-of-defaults*", NULL
		     };

	for (weedcount = 0; default_list[weedcount] != (char *) 0;weedcount++){
	  int Len = strlen(default_list[weedcount]) + 1;
	  if ((weedlist[weedcount] = 
	      malloc(Len)) == NULL) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoMemDefaultWeed,
			      "Not enough memory for default weedlist. Leaving."));
	     (*safe_malloc_fail_handler)("default_weedlist", Len);
	     return;
	  }
	  strfcpy(weedlist[weedcount], default_list[weedcount], Len);
	}
}

int
matches_weedlist(buffer)
char *buffer;
{
	/** returns true iff the first 'n' characters of 'buffer' 
	    match an entry of the weedlist **/
	
	register int i;

	for (i=0;i < weedcount; i++)
	  if (strincmp(buffer, weedlist[i], strlen(weedlist[i])) == 0) 
	    return(1);

	return(0);
}

static int breakup(buffer, word1, word2, size_word1, size_word2)
     char *buffer, *word1, *word2;
     int size_word1, size_word2;
{
	/** This routine breaks buffer down into word1, word2 where 
	    word1 is alpha characters only, and there is an equal
	    sign delimiting the two...
		alpha = beta
	    For lines with more than one 'rhs', word2 is set to the
	    entire string.
	    Return -1 if word 2 is of zero length, else 0.
	**/

	int i;
	
	for (i=0;
	     buffer[i] != '\0' && ok_rc_char(buffer[i]) && i < size_word1 -1; 
	     i++)
	  if (buffer[i] == '_')
	    word1[i] = '-';
	  else
#ifdef ASCII_CTYPE
	    if (isascii(buffer[i]))
#endif
	      word1[i] = tolower((unsigned char)buffer[i]);

	word1[i++] = '\0';	/* that's the first word! */

	/** spaces before equal sign? **/

	while (whitespace(buffer[i])) i++;
	if (buffer[i] == '=') i++;

	/** spaces after equal sign? **/

	while (whitespace(buffer[i])) i++;

	if (buffer[i] != '\0')
	  strfcpy(word2, (char *) (buffer + i), size_word2);
	else
	  word2[0] = '\0';

	/* remove trailing spaces from word2! */
	i = strlen(word2) - 1;
	while(i && (whitespace(word2[i]) || word2[i] == '\n'))
	  word2[i--] = '\0';

	return(*word2 == '\0' ? -1 : 0 );

}


/*
 * expand_env() - Perform environment expansion on a pathname.  Also
 * replaces "~" at the front of the path with the user's home directory.
 * Environment expansion occurs at the path component boundaries, e.g.
 * "/foo/$BAR/baz" is subject to expansion but "/foo/zzz$BAR/baz" is not.
 * Returns 0 if expansion successful, -1 if an error occurs (result too
 * long, cannot get home directory, or environment expansion failed).
 */
expand_env(dest, src, destlen)
char *dest;		/* pointer to space to hold the result	*/
char *src;		/* pointer to string to expand		*/
unsigned destlen;	/* size of the destination buffer	*/
{
    char envname_buf[SLEN], *envname_front, *expval;
    int check_for_env, len, ret;

    --destlen;		/* reserve space for trailing '\0' */
    ret = 0;		/* assume success */

    /*
     * Replace "~" at front with user's home directory.
     */
    if (src[0] == '~' && (src[1] == '\0' || src[1] == '/')) {
	if (home[0] == '\0') {
	    expval = "~";
	    ret = -1;
	} else {
	    expval = home;
	}
	if ((len = strlen(expval)) > destlen)
	    len = destlen;
	strfcpy(dest, expval, len+1);
	dest += len;
	destlen -= len;
	++src;
    }

    /*
     * Copy through the rest, performing $NAME expansion where appropriate.
     */
    check_for_env = TRUE;
    while (destlen > 0 && *src != '\0') {

	/*
	 * Check for "$NAME" at the start of every path component.
	 */
	if (check_for_env && *src == '$') {

	    /*
	     * Get the environment parameter name into "envname_buf"
	     * and advance "src" to the next path component.
	     */
	    envname_front = ++src;
	    if ((len = strcspn(src, "/")) == 0)
		len = strlen(src);
	    src += len;
	    if (len > sizeof(envname_buf)-1)
		len = sizeof(envname_buf)-1;
	    strfcpy(envname_buf, envname_front, len+1);

	    /*
	     * Copy over the environment expansion.  If the environment
	     * parameter is undefined then copy over unchanged and set
	     * a fail return status.
	     */
	    if ((expval = getenv(envname_buf)) == NULL) {
		*dest++ = '$';
		--destlen;
		expval = envname_buf;
		ret = -1;
	    }
	    if ((len = strlen(expval)) > destlen)
		len = destlen;
	    strfcpy(dest, expval, len+1);
	    dest += len;
	    destlen -= len;
	    check_for_env = FALSE;

	} else {

	    check_for_env = (*src == '/');
	    *dest++ = *src++;
	    --destlen;

	}

    }

    *dest = '\0';
    if (destlen <= 0)
	ret = -1;
    return ret;
}

is_it_on(word)
char *word;
{
	/** Returns TRUE if the specified word is either 'ON', 'YES'
	    or 'TRUE', and FALSE otherwise.   We explicitly translate
	    to lowercase here to ensure that we have the fastest
	    routine possible - we really DON'T want to have this take
	    a long time or our startup will be major pain each time.
	**/

	static char mybuffer[NLEN];
	register int i, j;

	for (i=0, j=0; word[i] != '\0'; i++)
#ifdef ASCII_CTYPE
	  if (isascii(word[i]))
#endif
	    mybuffer[j++] = tolower((unsigned char)word[i]);
	mybuffer[j] = '\0';

	return(  (strncmp(mybuffer, "on",   2) == 0) ||
		 (strncmp(mybuffer, "yes",  3) == 0) ||
		 (strncmp(mybuffer, "true", 4) == 0)
	      );
}

char *
mode_to_str(mode)
int mode;
{
	static char modestr[9+1];	/* "rwxrwxrwx\0" */
	char *s = &modestr[0];
	char *modecharp = "rwxrwxrwx";
	int modebit = 0400;

	while (modebit != 0) {
	    if (mode & modebit)
	        *s++ = *modecharp;
	    else
		*s++ = '-';
	    modecharp++;
	    modebit >>= 1;
	}
	*s = '\0';
	return(modestr);
}

int null_option_func(value,enter)
     char **value; 
     int enter;
{
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
