static char rcsid[] = "@(#)$Id: getaddr.c,v 1.6 1999/05/22 13:49:47 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Content partially moved from melib/parse_util.c
 *****************************************************************************/

#include "headers.h"

char **rfc822_tokenize(line) 
     CONST char *line;
{
  CONST char * ptr;
  char **res;
  int len, count = 0,i;
  
  dprint(25,(debugfile,"rfc822_tokenize(line=\"%s\n\"):\n",line));

  for (ptr = line; *ptr; ptr += len) {
    len = rfc822_toklen(ptr);
    count++;
  }
  dprint(25,(debugfile,"rfc822_tokenize: count=%d\n",count));
  res = safe_malloc((count+1) * sizeof (char *));
  
  for (i = 0, ptr = line; 
       i < count; 
       i++, ptr += len) {
    len = rfc822_toklen(ptr);
    res[i] = safe_malloc(len+1);
    strncpy(res[i],ptr,len);
    res[i][len] = '\0';
    dprint(25,(debugfile,"             : [%i]=\"%s\"\n",i,res[i]));
  }
  res[count] = NULL;
  dprint(25,(debugfile,"             : [%i]=NULL\n",count));
  return res;
}

void remove_space_tokenized(tokenized)
     char ** tokenized;
{
  int ptr, ptr2 = 0;

  for (ptr = 0; tokenized[ptr]; ptr++) {
    if ('(' == tokenized[ptr][0] || whitespace(tokenized[ptr][0]) ||
	'\n' == tokenized[ptr][0]) {
      dprint(25,(debugfile,"remove_space_tokenized: FREE \t<= [%d] = \"%s\"\n",
		 ptr,tokenized[ptr]));
      free(tokenized[ptr]);
      tokenized[ptr] = NULL;
    } else {
      dprint(25,(debugfile,"remove_space_tokenized: [%d] \t<= [%d] = \"%s\"\n",
		 ptr2,ptr,tokenized[ptr]));
      tokenized[ptr2] = tokenized[ptr];
      if (ptr2 != ptr)
	tokenized[ptr] = NULL;
      ptr2++;
    }
  }
  /* Check: */
  while (ptr2 <= ptr) {
    if (!tokenized[ptr2]) {
      dprint(25,(debugfile,"remove_space_tokenized: [%d] \t<= NULL\n",
		 ptr2));
    } else {
      dprint(25,(debugfile,"remove_space_tokenized: [%d] \t== \"%s\" ERROR!\n",
		 ptr2,tokenized[ptr2]));
    }
    ptr2++;
  }
}

void free_rfc822tokenized(res)
     char **res; 
{
  int i;
  for (i = 0; res[i]; i++) {
    dprint(100,(debugfile,"free_rfc822tokenized: free(res[%d]=\"%s\")\n",
		i,res[i]));
    free(res[i]);
  }
  dprint(100,(debugfile,"free_rfc822tokenized: free(res)\n"));
  free(res);
}

static int look_special_tokens P_((char **tokenized,
				   CONST char *tok_chars,
				   int start, int *ended,
				   decode_who decoder,
				   char **comments,
				   char ***scanned));

static int look_special_tokens(tokenized,tok_chars,
			       start,ended,decoder,
			       comments,scanned) 
     char **tokenized;
     CONST char *tok_chars;
     int start; 
     int *ended;
     decode_who decoder;
     char **comments;
     char ***scanned;
{
  int end;

  dprint(30,(debugfile,
	     "look_special_tokens: start=%d, tok_chars=%s,*comments=%X=%s\n", 
	     start,tok_chars,*comments,NONULL(*comments)));
  
  *scanned = NULL;

  dprint(30,(debugfile,
	     "look_special_tokens: "));

  for (end = start; tokenized[end]; end++) {
    if (NULL != strchr(tok_chars,tokenized[end][0]) &&
	'\0' == tokenized[end][1])
      break;
    dprint(30,(debugfile," [%d]=%s",end,tokenized[end]));
  }
  dprint(30,(debugfile,"\n"));

  if (!tokenized[end]) {
    dprint(30,(debugfile,"look_special_tokens: end=%d NO MATCH\n",end));
  } else {
    dprint(30,(debugfile,"look_special_tokens: end=%d MATCH=%s\n",
	       end,tokenized[end]));
  }
  if (end > start) {
    int count = end-start;
    int i, in_ptr,out_ptr;
    char **res;
    dprint(31,(debugfile,"look_special_tokens: count=%d\n",
	       count));

    res = safe_malloc((count+1) * sizeof (char *));
    for (i = 0; i <= count; i++)
      res[i] = NULL;

    for (in_ptr=start, out_ptr=0;
	 in_ptr < end && out_ptr < count;
	 in_ptr++) {
      if (whitespace(tokenized[in_ptr][0])) {
	if (*comments && (*comments)[0] && in_ptr < end-1)
	  *comments = strmcat(*comments,tokenized[in_ptr]);
      } else if ('(' == tokenized[in_ptr][0]) {
	char buffer[1000];
	int k, j = 0;

	for (k = 1; tokenized[in_ptr][k] && 
	       (tokenized[in_ptr][k] != ')' || tokenized[in_ptr][k+1]) &&
	       j < sizeof buffer -1; k++)
	  buffer[j++] = tokenized[in_ptr][k];
	buffer[j] = '\0';
	    
	/* MIME decode */
	decoder(HDR_COMMENT,buffer,sizeof buffer );

	*comments = strmcat(*comments,buffer);
      } else
	res[out_ptr++] = safe_strdup(tokenized[in_ptr]);       
    }

    dprint(31,(debugfile,"look_special_tokens: real count=%d, scanned:",
	       out_ptr));

    for (i = 0; i < out_ptr; i++) {
      dprint(31,(debugfile," [%d]=%s",i,res[i]));
    }
    *scanned=res;

    dprint(31,(debugfile,
	       "\nlook_special_tokens: *scanned=%X, *comments=%X=%s\n",
	       *scanned,*comments,NONULL(*comments)));
  }
  if (ended)
    *ended = end;
  dprint(30,(debugfile,"look_special_tokens=%d\n",end-start));
  return end-start;
}

static char *scanned_to_phrase P_((char **scanned,decode_who decoder));

static char *scanned_to_phrase(scanned,decoder)
     char * *scanned;
     decode_who decoder;
{
  char *res = NULL;
  int idx, max_idx;

  dprint(30,(debugfile,"scanned_to_phrase:"));
  for (max_idx  = 0; scanned[max_idx]; max_idx++) {
    dprint(30,(debugfile," [%d]=%s",max_idx,scanned[max_idx]));
  }
  dprint(30,(debugfile,"\n"));

  for (idx  = 0; idx < max_idx; idx++) {
    if ('"' == scanned[idx][0]) {
      char buffer[1000];
      int k,j;
      for (k = 1, j = 0; 
	   scanned[idx][k] && (scanned[idx][k] != '"' || scanned[idx][k+1]) &&
	     j < sizeof buffer -1; 
	   k++)
	buffer[j++] = scanned[idx][k];
      buffer[j] = '\0';
      if (res && res[0] != '\0')
	res = strmcat(res," ");
      res = strmcat(res,buffer);
    } else {
      char buffer[1000];
      strfcpy(buffer,scanned[idx],sizeof buffer);
      while (idx+1 < max_idx && '"' != scanned[idx+1][0] &&
	     strlen(buffer) + strlen(scanned[idx+1]) +2 < sizeof buffer) {
	strfcat(buffer," ",sizeof buffer);
	strfcat(buffer,scanned[++idx], sizeof buffer);
      }
      decoder(HDR_PHRASE,buffer,sizeof buffer);
      if (res && res[0] != '\0')
	res = strmcat(res," ");
      res = strmcat(res,buffer);
    }
  }
  dprint(30,(debugfile,"scanned_to_phrase=%X=%s\n",res,NONULL(res)));
  return res;
}

static char *scanned_to_str P_((char **scanned));

static char *scanned_to_str(scanned)
     char **scanned;
{
  int idx;
  char * res = NULL;
  dprint(30,(debugfile,"scanned_to_str:"));
  for (idx = 0; scanned[idx]; idx++) {
    dprint(30,(debugfile," [%d]=%s",idx,scanned[idx]));
    res = strmcat(res,scanned[idx]);
  }
  dprint(30,(debugfile,"\nscanned_to_str=%X=%s\n",res,NONULL(res)));
  return res;
}

struct addr_item * break_down_address (buffer, decoder)
     CONST char *buffer;
     decode_who decoder;
{
  int count=1;
  int i,res_idx = 0;
  struct addr_item *res;
  int outer, inner;
  int tok_end;

  struct {
    int in_group;
    int in_bracket;
  } state;

  char **tokenized = rfc822_tokenize(buffer);

  dprint(13,(debugfile,
	     "break_down_address: buffer=%.100s\n",
	     buffer));

  if (!tokenized)
    return NULL;

  for (tok_end = 0; tokenized[tok_end]; tok_end++)
    if (tokenized[tok_end][0] == ',')
      count++;

  dprint(13,(debugfile,
	     "break_down_address: count=%d, tok_end=%d\n",
	     count,tok_end));

  res = safe_malloc((count+1) * sizeof (struct addr_item));

  for (i =0; i <= count; i++) {
    res[i].addr     = NULL;
    res[i].fullname = NULL;
    res[i].comment = NULL;
  }


  state.in_group   = 0;
  state.in_bracket = 0;

  for (outer = 0; outer < tok_end; outer = inner) {
      char **scanned = NULL;
      char *comments = NULL;
      char tok = '\0';
      int len;
      
      dprint(25,(debugfile,
		 "break_down_address: [%d]=%.10s... state: in_group=%d in_bracket=%d\n",
		 outer,tokenized[outer],state.in_group,state.in_bracket));
      
      len = look_special_tokens(tokenized,":<>,;",outer,&inner,decoder,
				&comments,&scanned);
      
      if (inner < tok_end) {
	  tok = tokenized[inner][0];
	  dprint(25,(debugfile,
		     "break_down_address: [%d] token=%c (%s)\n",inner,tok,tokenized[inner]));
	  inner++;
      } else {
	  tok = '\0';
	  dprint(25,(debugfile,
		     "break_down_address: [%d] token=EOS\n",inner));
      }
      

      if (res_idx < count) {

	  /* state engine */
	  if (!state.in_group) {
	      if (!state.in_bracket)
		  switch(tok) {
		  case ':':  dprint(25,(debugfile, "... skipping group phrase\n"));
		      state.in_group = 1;
		      break;
		  case '<': 
		      if (scanned && scanned[0]) {
			  char *str = scanned_to_phrase(scanned,decoder);
			  dprint(25,(debugfile, "... storing address phrase: %s\n",str));
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,str);
			  free(str);
		      }
		      state.in_bracket = 1;
		      break;
		  case '>':
		      dprint(25,(debugfile, "... Parse error, next token '>'\n"));
		      break;
		  case ';':
		      dprint(25,(debugfile, "... Parse error, next token ';'\n"));
		      break;
		  case ',':
		  default: /* \0 */	  
		      if (scanned  && scanned[0]) {
			  char *str = scanned_to_str(scanned);
			  dprint(25,(debugfile, "... storing address: %s\n",str));
			  res[res_idx].addr = strmcat(res[res_idx].addr,str);
			  free(str);
			  if (comments && convert_comment && 
			      !res[res_idx].fullname) {
			      dprint(25,(debugfile, "... storing comments (as fullname): %s\n",comments));
			      res[res_idx].fullname = strmcat(res[res_idx].fullname,comments);
			  } else if (comments) {
			      dprint(25,(debugfile, "... storing comments: %s\n",comments));
			      res[res_idx].comment = strmcat(res[res_idx].comment,comments);
			  }
		      } 
		      if (res[res_idx].addr || res[res_idx].fullname || 
			  res[res_idx].comment) {
			  res[res_idx].addr = strmcat(res[res_idx].addr,"");
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,"");
			  res[res_idx].comment = strmcat(res[res_idx].comment,"");
			  dprint(13,(debugfile,
				     "break_down_address: [%d].addr    =%.100s\n",
				     res_idx,res[res_idx].addr));
			  dprint(13,(debugfile,
				     "                  : [%d].fullname=%.100s\n",
				     res_idx,res[res_idx].fullname));
			  dprint(13,(debugfile,
				     "                  : [%d].comment =%.100s\n",
				     res_idx,res[res_idx].comment));
			  res_idx++;
		      }
		      break;
		  } else switch(tok) {    /* state.in_bracket */
		      char *str;
		  case ':': dprint(25,(debugfile, "... skipping route\n"));
		      break;
		  case '<':
		      dprint(25,(debugfile, "... Parse error, next token '<'\n"));
		      break;
		  case '>': store_addr1:
		      if (scanned  && scanned[0]) {
			  char *str = scanned_to_str(scanned);
			  dprint(25,(debugfile, "... storing address: %s\n",str));
			  res[res_idx].addr = strmcat(res[res_idx].addr,str);
			  free(str);
		      }
		      if (res[res_idx].addr || res[res_idx].fullname
			  || res[res_idx].comment) {
			  res[res_idx].addr = strmcat(res[res_idx].addr,"");
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,"");
			  res[res_idx].comment = strmcat(res[res_idx].comment,"");
			  dprint(13,(debugfile,
				     "break_down_address: [%d].addr    =%.100s\n",
				     res_idx,res[res_idx].addr));
			  dprint(13,(debugfile,
				     "                  : [%d].fullname=%.100s\n",
				     res_idx,res[res_idx].fullname));
			  dprint(13,(debugfile,
				     "                  : [%d].comment =%.100s\n",
				     res_idx,res[res_idx].comment));
			  res_idx++;
		      }
		      state.in_bracket = 0;
		      break;
		  case ',': dprint(25,(debugfile, "... skipping route\n"));
		      break;
		  case ';': dprint(25,(debugfile, "... Parse error, next token ';'\n"));
		      break;
		  default: /* \0 */	  
		      dprint(25,(debugfile, "... Parse error, missing '>'\n"));
		      goto store_addr1;	  
		  }
	  } else { /* state.in_group */
	      if (!state.in_bracket)
		  switch(tok) {
		  case ':': dprint(25,(debugfile, "... Parse error, next token ':'\n"));
		      break;
		  case '<':
		      if (scanned && scanned[0]) {
			  char *str = scanned_to_phrase(scanned,decoder);
			  dprint(25,(debugfile, "... storing address phrase: %s\n",str));
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,str);
			  free(str);
		      }
		      state.in_bracket = 1;
		      break;
		  case '>':
		      dprint(25,(debugfile, "... Parse error, next token '>'\n"));
		      break;
		  case ';': store_addr2:
		      state.in_group = 0;
		      /* FALLTHRU */
		  case ',': 
		      if (scanned  && scanned[0]) {
			  char *str = scanned_to_str(scanned);
			  dprint(25,(debugfile, "... storing address: %s\n",str));
			  res[res_idx].addr = strmcat(res[res_idx].addr,str);
			  free(str);
			  if (comments && convert_comment && 
			      !res[res_idx].fullname) {
			      dprint(25,(debugfile, "... storing comments (as fullname): %s\n",comments));
			      res[res_idx].fullname = strmcat(res[res_idx].fullname,comments);
			  } else if (comments) {
			      dprint(25,(debugfile, "... storing comments: %s\n",comments));
			      res[res_idx].comment = strmcat(res[res_idx].comment,comments);
			  }
		      } 
		      if (res[res_idx].addr || res[res_idx].fullname
			  || res[res_idx].comment) {
			  res[res_idx].addr = strmcat(res[res_idx].addr,"");
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,"");
			  res[res_idx].comment = strmcat(res[res_idx].comment,"");
			  dprint(13,(debugfile,
				     "break_down_address: [%d].addr    =%.100s\n",
				     res_idx,res[res_idx].addr));
			  dprint(13,(debugfile,
				     "                  : [%d].fullname=%.100s\n",
				     res_idx,res[res_idx].fullname));
			  dprint(13,(debugfile,
				     "                  : [%d].comment =%.100s\n",
				     res_idx,res[res_idx].comment));
			  res_idx++;
		      }
		      break;
		  default: /* \0 */
		      dprint(25,(debugfile, "... Parse error, missing ';'\n"));
		      goto store_addr2;
		  } else switch(tok) { /* state.in_bracket */
		  case ':': dprint(25,(debugfile, "... skipping route\n"));
		      break;
		  case '<':
		      dprint(25,(debugfile, "... Parse error, next token '<'\n"));
		      break;
		  case ';': 
		      dprint(25,(debugfile, 
				 "... Parse error, next token ';', missing '>'\n"));
		      state.in_group = 0;
		      /* FALLTHRU */
		  case '>': store_addr3:
		      if (scanned && scanned[0]) {
			  char *str = scanned_to_str(scanned);
			  dprint(25,(debugfile, "... storing address: %s\n",str));
			  res[res_idx].addr = strmcat(res[res_idx].addr,str);
			  free(str);
		      }
		      if (res[res_idx].addr || res[res_idx].fullname
			  || res[res_idx].comment) {
			  res[res_idx].addr = strmcat(res[res_idx].addr,"");
			  res[res_idx].fullname = strmcat(res[res_idx].fullname,"");
			  res[res_idx].comment = strmcat(res[res_idx].comment,"");
			  dprint(13,(debugfile,
				     "break_down_address: [%d].addr    =%.100s\n",
				     res_idx,res[res_idx].addr));
			  dprint(13,(debugfile,
				     "                  : [%d].fullname=%.100s\n",
				     res_idx,res[res_idx].fullname));
			  dprint(13,(debugfile,
				     "                  : [%d].comment =%.100s\n",
				     res_idx,res[res_idx].comment));
			  res_idx++;
		      }
		      state.in_bracket = 0;
		      break;
		  case ',': dprint(25,(debugfile, "... skipping route\n"));
		      break;
		  default: /* \0 */
		      dprint(25,(debugfile, 
				 "... Parse error, missing '>', missing ';'\n"));
		      state.in_group = 0;
		      goto store_addr3;
		  }
	  }
      } else {
	  if (scanned  && scanned[0]) {
	      dprint(13,(debugfile,
			 "break_down_address: OVERFLOW (already %d addresses)\n",
			 count));
	      
	  }
      }
      
      /* do not convert here comment to fullname even when convert_comment
       * is set!
       */
      if (comments && res_idx > 0 && 
	  !res[res_idx-1].comment[0] &&
	  /* Don't store comment it is already stored as fullname
	   * because of convert_comment is set!
	   */
	  0 != strcmp(res[res_idx-1].fullname,comments)) {
	  dprint(25,(debugfile, 
		 "... storing comments to previous address: %s\n",
		     comments));
	  res[res_idx-1].comment = strmcat(res[res_idx-1].comment,comments);
	  dprint(13,(debugfile,
		     "                  : [%d].comment =%.100s\n",
		     res_idx-1,res[res_idx-1].comment));	      
      }
      if (comments)
	  free(comments);
      if (scanned)
	  free_rfc822tokenized(scanned);
  }

  free_rfc822tokenized(tokenized);

  dprint(13,(debugfile,
	     "break_down_address=%08X (real count=%d)\n",
	     res,res_idx));

  return res;
}

void  free_addr_items (list)
     struct addr_item *list;
{
  struct addr_item *ptr;

  dprint(100,(debugfile,
	     "free_addr_items(%08X)\n",ptr));

  for (ptr=list; ptr->addr && ptr->fullname; ptr++) {
    free(ptr->addr);
    ptr->addr = NULL;

    free(ptr->fullname);
    ptr->fullname = NULL;

    free(ptr->comment);
    ptr->comment = NULL;
  }
  free(list);
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
