
static char rcsid[] ="@(#)$Id: lock.c,v 1.2.8.1 1999/09/01 16:36:28 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2.8.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


/** The lock() and unlock() routines herein duplicate exactly the
    equivalent routines in the Elm Mail System, and should also be
    compatible with sendmail, rmail, etc etc.

  
**/

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include "defs.h"

#include "elmlib.h"
#include "filter.h"
#include "s_filter.h"

static  int  we_locked_it;
static char *lockfile=(char*)0;

extern char *mk_lockname();

#ifdef	USE_FLOCK_LOCKING
#define	NEEDS_FLOCK_FD
#include <sys/types.h>
#  if (defined(BSD_TYPE) || !defined(apollo))
#    include <sys/file.h>
#  endif
#endif

#ifdef USE_FCNTL_LOCKING
#define	NEEDS_FLOCK_FD
static struct flock lock_info;
#endif

#ifdef NEEDS_FLOCK_FD
static	int flock_fd = -1;
static	char flock_name[SLEN];
#endif

#ifdef	USE_DOTLOCK_LOCKING			/*  USE_DOTLOCK_LOCKING	*/
static	char dotlock_name[SLEN];
#endif

#define	FLOCKING_OK	0
#define	FLOCKING_RETRY	1
#define	FLOCKING_FAIL	-1

extern  int  errno;

int
Grab_the_file(flock_fd)
int flock_fd;
{
    int	retcode	= FLOCKING_OK;

    errno = 0;

#ifdef   USE_FCNTL_LOCKING
    lock_info.l_type = F_WRLCK;
    lock_info.l_whence = 0;
    lock_info.l_start = 0;
    lock_info.l_len = 0;

    if (fcntl(flock_fd, F_SETLK, &lock_info)) {
	return ((errno == EACCES) || (EAGAIN))
		? FLOCKING_RETRY
		: FLOCKING_FAIL ;
    }
#endif

#ifdef	USE_FLOCK_LOCKING
    if (flock (flock_fd, LOCK_NB | LOCK_EX)) {

	retcode = ((errno == EWOULDBLOCK) || (errno == EAGAIN))
		   ? FLOCKING_RETRY
		   : FLOCKING_FAIL ;

#ifdef USE_FCNTL_LOCKING
	lock_info.l_type = F_UNLCK;
	lock_info.l_whence = 0;
	lock_info.l_start = 0;
	lock_info.l_len = 0;

	/*
	 *  Just unlock it because we did not succeed with the
	 *  flock()-style locking. Never mind the return value.
	 *  It was our own lock anyway if we ever got this far.
	 */
	fcntl (flock_fd, F_SETLK, &lock_info);
#endif
	return retcode;
    }
#endif

    return FLOCKING_OK;
}

int
Release_the_file(flock_fd)
int flock_fd;
{
    int	fcntlret = 0,
	flockret = 0,
	fcntlerr = 0,
	flockerr = 0;

#ifdef	USE_FLOCK_LOCKING
    errno = 0;
    flockret = flock (flock_fd, LOCK_UN);
    flockerr = errno;
#endif

#ifdef	USE_FCNTL_LOCKING
    lock_info.l_type = F_UNLCK;
    lock_info.l_whence = 0;
    lock_info.l_start = 0;
    lock_info.l_len = 0;

    errno = 0;
    fcntlret = fcntl (flock_fd, F_SETLK, &lock_info);
    fcntlerr = errno;
#endif

    if (fcntlret) {
	errno = fcntlerr;
	return fcntlret;
    }
    else if (flockret) {
	errno = flockret;
	return flockret;
    }
    return 0;
}

int
lock()
{
	/** This routine will return 1 if we could lock the mailfile,
	    zero otherwise.
	**/

	int attempts = 0, ret;

#ifdef	USE_DOTLOCK_LOCKING			/* { USE_DOTLOCK_LOCKING	*/
	strfcpy(dotlock_name,mailhome, sizeof dotlock_name);
	strfcat(dotlock_name,username, sizeof dotlock_name);
	lockfile = mk_lockname(dotlock_name);
#ifdef PIDCHECK
	/** first, try to read the lock file, and if possible, check the pid.
	    If we can validate that the pid is no longer active, then remove
	    the lock file.
	**/
	if((ret=open(lockfile,O_RDONLY)) != -1) {
	  char pid_buffer[SHORT];
	  if (read(ret, pid_buffer, SHORT) > 0) {
	    attempts = atoi(pid_buffer);
	    if (attempts) {
	      if (kill(attempts, 0)) {
	        close(ret);
	        if (unlink(lockfile) != 0)
		  return(1);
	      }
	    }
	  }
	  attempts = 0;
        }
#endif

	while ((ret = open(lockfile, O_WRONLY | O_CREAT | O_EXCL, 0444)) < 0 
	       && attempts++ < 10) {
	  sleep(3);	/* wait three seconds each pass, okay?? */
	}

	if (ret >= 0) {
	  we_locked_it++;
	  close(ret);			/* no need to keep it open! */
	  ret = 1;
	} else {
	  ret = 0;
	}
	  
#endif					/* } USE_DOTLOCK_LOCKING	*/

#ifdef	NEEDS_FLOCK_FD			/* { NEEDS_FLOCK_FD	*/
	(void)elm_sfprintf(flock_name,sizeof flock_name,
			   FRM("%s%s"),
			   mailhome,username);
	flock_fd = open(flock_name, O_RDWR | O_CREAT, 0600);

	if ( flock_fd >= 0 ) {
	    for (attempts = 0; attempts < 10; attempts++) {

		ret = Grab_the_file (flock_fd);
	    
		if ((ret == FLOCKING_FAIL) || (ret == FLOCKING_OK)) {
		    break;
		}
		(void)sleep((unsigned)3);
	    }

	    if ( ret == FLOCKING_OK ) {
		we_locked_it++;
		ret = 1;
	    }
	    else {
		we_locked_it = 0;
		if ( lockfile[0] ) {
		    (void)unlink(lockfile);
		    lockfile[0] = 0;
		}
		(void)close(flock_fd);
		flock_fd = -1;
		ret = 0;
	    }
	}
#endif					 /* { NEEDS_FLOCK_FD	*/
	return(ret);
}

void unlock()
{
	/** this routine will remove the lock file, but only if we were
	    the people that locked it in the first place... **/

#ifdef	USE_DOTLOCK_LOCKING
	if (we_locked_it && lockfile[0]) {
	    unlink(lockfile);	/* blamo! */
	    lockfile[0] = 0;
	}
#endif
#ifdef	NEED_FLOCK_FD
	if (we_locked_it && flock_fd >= 0) {
	    /*
	     *	Give it at least a decent try. OK?
	     */
	    (void) Release_the_file (flock_fd);
	    /*
	     *	And then blast the locks anyway...
	     */
	    (void) close (flock_fd);
	    flock_fd = -1;
	}
#endif
	we_locked_it = 0;
}
