#!/usr/local/bin/python2.0

""" Configuration for the eGenix mx BASE distribution.

    Copyright (c) 1997-2000, Marc-Andre Lemburg; mailto:mal@lemburg.com
    Copyright (c) 2000-2003, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further information on copyrights,
    or contact the author. All Rights Reserved.
"""
from distutils.core import Extension

#
# Package version
#
version = '2.0.5'

#
# Setup information
#
name = "egenix-mx-base"

#
# Meta-Data
#
description = "eGenix mx-Extensions for Python - BASE package"
long_description = """\
The eGenix mx Extension Series are a collection of
Python extensions written in ANSI C and Python
which provide a large spectrum of useful additions
to everyday Python programming.

The BASE package includes the Open Source subpackages
of the series and is needed by all other add-on
packages of the series.

This software is brought to you by eGenix.com and
distributed under the eGenix.com Public License.
"""
license = (
"Copyright (c) 1997-2000, Marc-Andre Lemburg, All Rights Reserved; "
"Copyright (c) 2000-2003, eGenix.com Software GmbH, All Rights Reserved"
)
author = "Marc-Andre Lemburg"
author_email = "mal@egenix.com"
url = "http://www.lemburg.com/python/mxExtensions.html"

#
# Python packages
#
packages = [
    
    'mx',

    'mx.DateTime',
    'mx.DateTime.mxDateTime',
    'mx.DateTime.Examples',

    'mx.Proxy',
    'mx.Proxy.mxProxy',

    'mx.Queue',
    'mx.Queue.mxQueue',

    'mx.Stack',
    'mx.Stack.mxStack',
    
    'mx.TextTools',
    'mx.TextTools.mxTextTools',
    'mx.TextTools.Constants',
    'mx.TextTools.Examples',
    
    'mx.Tools',
    'mx.Tools.mxTools',
    'mx.Tools.Examples',
    
    'mx.BeeBase',
    'mx.BeeBase.mxBeeBase',
    
    'mx.Misc',
    
    ]

#
# C Extensions
#
ext_modules = [

    Extension('mx.DateTime.mxDateTime.mxDateTime',
              ['mx/DateTime/mxDateTime/mxDateTime.c'],
              include_dirs=['mx/DateTime/mxDateTime']),

    Extension('mx.Proxy.mxProxy.mxProxy',
              ['mx/Proxy/mxProxy/mxProxy.c'],
              include_dirs=['mx/Proxy/mxProxy']),

    Extension('mx.Queue.mxQueue.mxQueue',
              ['mx/Queue/mxQueue/mxQueue.c'],
              include_dirs=['mx/Queue/mxQueue']),

    Extension('mx.Stack.mxStack.mxStack',
              ['mx/Stack/mxStack/mxStack.c'],
              include_dirs=['mx/Stack/mxStack']),

    Extension('mx.TextTools.mxTextTools.mxTextTools',
              ['mx/TextTools/mxTextTools/mxTextTools.c',
               'mx/TextTools/mxTextTools/mxte.c',
               'mx/TextTools/mxTextTools/mxbmse.c'],
              include_dirs=['mx/TextTools/mxTextTools']),
    
    Extension('mx.Tools.mxTools.mxTools',
              ['mx/Tools/mxTools/mxTools.c'],
              include_dirs=['mx/Tools/mxTools']),
    Extension('mx.Tools.mxTools.xmap',
              ['mx/Tools/mxTools/xmap.c'],
              include_dirs=['mx/Tools/mxTools']),

    Extension('mx.BeeBase.mxBeeBase.mxBeeBase',
              ['mx/BeeBase/mxBeeBase/mxBeeBase.c',
               'mx/BeeBase/mxBeeBase/btr.c'],
              include_dirs=['mx/BeeBase/mxBeeBase']),

    ]

#
# Data files
#
data_files = [

    'mx/Doc/eGenix-mx-Extensions.html',
    'mx/Doc/eGenix.com-Commercial-Copyright.txt',
    'mx/Doc/eGenix.com-Commercial-License.txt',
    'mx/Doc/eGenix.com-Public-Copyright.txt',
    'mx/Doc/eGenix.com-Public-License.txt',
    'mx/Doc/mxBeeBase.html',
    'mx/Doc/mxDateTime.html',
    'mx/Doc/mxLicense.html',
    'mx/Doc/mxProxy.html',
    'mx/Doc/mxQueue.html',
    'mx/Doc/mxStack.html',
    'mx/Doc/mxTextTools.html',
    'mx/Doc/mxTools.html',

    'mx/DateTime/Doc/mxDateTime.html',
    'mx/DateTime/Doc/mxDateTime-History.html',
    'mx/DateTime/Doc/mxLicense.html',
    'mx/DateTime/COPYRIGHT',
    'mx/DateTime/LICENSE',
    'mx/DateTime/README',
    'mx/DateTime/mxDateTime/mxDateTime.h',
    'mx/DateTime/mxDateTime/mxh.h',
    
    'mx/Proxy/Doc/mxProxy.html',
    'mx/Proxy/Doc/mxLicense.html',
    'mx/Proxy/COPYRIGHT',
    'mx/Proxy/LICENSE',
    'mx/Proxy/README',
    'mx/Proxy/mxProxy/mxProxy.h',
    'mx/Proxy/mxProxy/mxh.h',

    'mx/Queue/Doc/mxQueue.html',
    'mx/Queue/Doc/mxLicense.html',
    'mx/Queue/COPYRIGHT',
    'mx/Queue/LICENSE',
    'mx/Queue/README',
    'mx/Queue/mxQueue/mxQueue.h',
    'mx/Queue/mxQueue/mxh.h',

    'mx/TextTools/Doc/mxTextTools.html',
    'mx/TextTools/Doc/mxLicense.html',
    'mx/TextTools/COPYRIGHT',
    'mx/TextTools/LICENSE',
    'mx/TextTools/README',
    'mx/TextTools/mxTextTools/mxTextTools.h',
    'mx/TextTools/mxTextTools/mxh.h',
    'mx/TextTools/mxTextTools/mxte.h',
    'mx/TextTools/mxTextTools/mxbmse.h',

    'mx/Tools/Doc/mxTools.html',
    'mx/Tools/Doc/mxLicense.html',
    'mx/Tools/COPYRIGHT',
    'mx/Tools/LICENSE',
    'mx/Tools/README',
    'mx/Tools/mxTools/mxTools.h',
    'mx/Tools/mxTools/mxh.h',

    'mx/BeeBase/Doc/mxBeeBase.html',
    'mx/BeeBase/Doc/mxLicense.html',
    'mx/BeeBase/COPYRIGHT',
    'mx/BeeBase/LICENSE',
    'mx/BeeBase/README',
    'mx/BeeBase/mxBeeBase/mxBeeBase.h',
    'mx/BeeBase/mxBeeBase/mxh.h',
    'mx/BeeBase/mxBeeBase/btr.h',

    'mx/COPYRIGHT',
    'mx/LICENSE',
    'mx/README',

    ]
