/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysisTestDriver;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.detect.IOStreamFactory;
import edu.umd.cs.findbugs.detect.InstanceFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.MethodReturnValueStreamFactory;
import edu.umd.cs.findbugs.detect.StaticFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEquivalenceClass;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamResourceTracker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindOpenStream
extends ResourceTrackingDetector<Stream, StreamResourceTracker>
implements StatelessDetector {
    static final boolean DEBUG = SystemProperties.getBoolean((String)"fos.debug");
    static final boolean IGNORE_WRAPPED_UNINTERESTING_STREAMS = !SystemProperties.getBoolean((String)"fos.allowWUS");
    static final ObjectType[] streamBaseList = new ObjectType[]{ObjectTypeFactory.getInstance((String)"java.io.InputStream"), ObjectTypeFactory.getInstance((String)"java.io.OutputStream"), ObjectTypeFactory.getInstance((String)"java.io.Reader"), ObjectTypeFactory.getInstance((String)"java.io.Writer"), ObjectTypeFactory.getInstance((String)"java.sql.Connection"), ObjectTypeFactory.getInstance((String)"java.sql.Statement"), ObjectTypeFactory.getInstance((String)"java.sql.ResultSet")};
    static final StreamFactory[] streamFactoryList;
    private List<PotentialOpenStream> potentialOpenStreamList = new LinkedList<PotentialOpenStream>();
    private static final String[] PRESCREEN_CLASS_LIST;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindOpenStream;

    public FindOpenStream(BugReporter bugReporter) {
        super(bugReporter);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        boolean sawResourceClass = false;
        block0: for (int i = 0; i < jclass.getConstantPool().getLength(); ++i) {
            Constant constant = jclass.getConstantPool().getConstant(i);
            if (!(constant instanceof ConstantMethodref)) continue;
            ConstantMethodref cmr = (ConstantMethodref)constant;
            int classIndex = cmr.getClassIndex();
            String className = jclass.getConstantPool().getConstantString(classIndex, (byte)7);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("FindOpenStream: saw class ").append(className).toString());
            }
            if (className == null) continue;
            for (String aPRESCREEN_CLASS_LIST : PRESCREEN_CLASS_LIST) {
                if (className.indexOf(aPRESCREEN_CLASS_LIST) < 0) continue;
                sawResourceClass = true;
                continue block0;
            }
        }
        if (sawResourceClass) {
            super.visitClassContext(classContext);
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return false;
        }
        return bytecodeSet.get(187) || bytecodeSet.get(185) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(182);
    }

    public StreamResourceTracker getResourceTracker(ClassContext classContext, Method method) {
        return new StreamResourceTracker(streamFactoryList, (RepositoryLookupFailureCallback)this.bugReporter);
    }

    public static boolean isMainMethod(Method method) {
        return method.isStatic() && method.getName().equals("main") && method.getSignature().equals("([Ljava/lang/String;)V");
    }

    public void analyzeMethod(ClassContext classContext, Method method, StreamResourceTracker resourceTracker, ResourceCollection<Stream> resourceCollection) throws CFGBuilderException, DataflowAnalysisException {
        if (FindOpenStream.isMainMethod(method)) {
            return;
        }
        this.potentialOpenStreamList.clear();
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        try {
            Type[] parameterTypeList = Type.getArgumentTypes((String)methodGen.getSignature());
            Location firstLocation = new Location(cfg.getEntry().getFirstInstruction(), cfg.getEntry());
            int local = methodGen.isStatic() ? 0 : 1;
            block5: for (Type type : parameterTypeList) {
                if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    for (ObjectType streamBase : streamBaseList) {
                        if (!Hierarchy.isSubtype((ReferenceType)objectType, (ReferenceType)streamBase)) continue;
                        Stream paramStream = new Stream(firstLocation, objectType.getClassName(), streamBase.getClassName());
                        paramStream.setIsOpenOnCreation(true);
                        paramStream.setOpenLocation(firstLocation);
                        paramStream.setInstanceParam(local);
                        resourceCollection.addPreexistingResource((Object)paramStream);
                        break;
                    }
                }
                switch (type.getType()) {
                    case 7: 
                    case 11: {
                        local += 2;
                        continue block5;
                    }
                    default: {
                        ++local;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        resourceTracker.setResourceCollection(resourceCollection);
        super.analyzeMethod(classContext, method, (ResourceTracker)resourceTracker, resourceCollection);
        resourceTracker.markTransitiveUninterestingStreamEscapes();
        Iterator i = resourceCollection.resourceIterator();
        while (i.hasNext()) {
            Stream stream = (Stream)i.next();
            StreamEquivalenceClass equivalenceClass = resourceTracker.getStreamEquivalenceClass(stream);
            if (!stream.isClosed()) continue;
            equivalenceClass.setClosed();
        }
        for (PotentialOpenStream pos : this.potentialOpenStreamList) {
            Location openLocation;
            Stream stream = pos.stream;
            if (stream.isClosed() || stream.isUninteresting() || (openLocation = stream.getOpenLocation()) == null || IGNORE_WRAPPED_UNINTERESTING_STREAMS && resourceTracker.isUninterestingStreamEscape(stream)) continue;
            String sourceFile = javaClass.getSourceFileName();
            this.bugReporter.reportBug(new BugInstance((Detector)this, pos.bugType, pos.priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(classContext, methodGen, sourceFile, stream.getLocation().getHandle()));
        }
    }

    public void inspectResult(ClassContext classContext, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>> dataflow, Stream stream) {
        ResourceValueFrame exitFrame = (ResourceValueFrame)dataflow.getResultFact(cfg.getExit());
        int exitStatus = exitFrame.getStatus();
        if (exitStatus == 1 || exitStatus == 2) {
            String bugType = stream.getBugType();
            int priority = 2;
            if (exitStatus == 2) {
                bugType = new StringBuffer().append(bugType).append("_EXCEPTION_PATH").toString();
                priority = 3;
            }
            this.potentialOpenStreamList.add(new PotentialOpenStream(bugType, priority, stream));
        } else if (exitStatus == 3) {
            stream.setClosed();
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$detect$FindOpenStream == null ? (class$edu$umd$cs$findbugs$detect$FindOpenStream = FindOpenStream.class$("edu.umd.cs.findbugs.detect.FindOpenStream")) : class$edu$umd$cs$findbugs$detect$FindOpenStream).getName()).append(" <class file> <method name> <bytecode offset>").toString());
            System.exit(1);
        }
        String classFile = argv[0];
        String methodName = argv[1];
        int offset = Integer.parseInt(argv[2]);
        ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker> driver = new ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker>(){

            public StreamResourceTracker createResourceTracker(ClassContext classContext, Method method) {
                return new StreamResourceTracker(streamFactoryList, classContext.getLookupFailureCallback());
            }

            public /* synthetic */ ResourceTracker createResourceTracker(ClassContext x0, Method x1) throws CFGBuilderException, DataflowAnalysisException {
                return this.createResourceTracker(x0, x1);
            }
        };
        driver.execute(classFile, methodName, offset);
    }

    public /* synthetic */ void analyzeMethod(ClassContext x0, Method x1, ResourceTracker x2, ResourceCollection x3) throws CFGBuilderException, DataflowAnalysisException {
        this.analyzeMethod(x0, x1, (StreamResourceTracker)x2, (ResourceCollection<Stream>)x3);
    }

    public /* synthetic */ void inspectResult(ClassContext x0, MethodGen x1, CFG x2, Dataflow x3, Object x4) {
        this.inspectResult(x0, x1, x2, (Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>>)x3, (Stream)x4);
    }

    public /* synthetic */ ResourceTracker getResourceTracker(ClassContext x0, Method x1) throws DataflowAnalysisException, CFGBuilderException {
        return this.getResourceTracker(x0, x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        ArrayList<StreamFactory> streamFactoryCollection = new ArrayList<StreamFactory>();
        streamFactoryCollection.add(new IOStreamFactory("java.io.InputStream", new String[]{"java.io.ByteArrayInputStream", "java.io.StringBufferInputStream", "java.io.PipedInputStream", "java.io.ObjectInputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.OutputStream", new String[]{"java.io.ByteArrayOutputStream", "java.io.PipedOutputStream", "java.io.ObjectOutputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Reader", new String[]{"java.io.StringReader", "java.io.CharArrayReader", "java.io.PipedReader"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Writer", new String[]{"java.io.StringWriter", "java.io.CharArrayWriter", "java.io.PipedWriter"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getInputStream", "()Ljava/io/InputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getOutputStream", "()Ljava/io/OutputStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.InputStream", "java.lang.System", "in", "Ljava/io/InputStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "out", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "err", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.InputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Reader"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.OutputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Writer"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.sql.DataSource", "getConnection", "()Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("javax.sql.DataSource", "getConnection", "(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "()Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(II)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(III)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryList = streamFactoryCollection.toArray(new StreamFactory[streamFactoryCollection.size()]);
        PRESCREEN_CLASS_LIST = new String[]{"Stream", "Reader", "Writer", "DriverManager", "Connection"};
    }

    private static class PotentialOpenStream {
        public final String bugType;
        public final int priority;
        public final Stream stream;

        public PotentialOpenStream(String bugType, int priority, Stream stream) {
            this.bugType = bugType;
            this.priority = priority;
            this.stream = stream;
        }
    }
}

