/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.detect.DeadLocalStoreProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.StoreInstruction;

public class FindDeadLocalStores
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fdls.debug");
    private static final String FINDBUGS_EXCLUDED_LOCALS_PROP_NAME = "findbugs.dls.exclusions";
    private static final Set<String> EXCLUDED_LOCALS = new HashSet<String>();
    private static final boolean DO_EXCLUDE_LOCALS = SystemProperties.getProperty((String)"findbugs.dls.exclusions") != null;
    private static final BitSet defensiveConstantValueOpcodes;
    private BugReporter bugReporter;

    public FindDeadLocalStores(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            System.out.println("Debugging FindDeadLocalStores detector");
        }
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        return true;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        if (FindDeadLocalStores.DEBUG) {
            System.out.println("    Analyzing method " + classContext.getJavaClass().getClassName() + "." + method.getName());
        }
        javaClass = classContext.getJavaClass();
        accumulator = new BugAccumulator(this.bugReporter);
        llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
        numLocals = method.getCode().getMaxLocals();
        localStoreCount = new int[numLocals];
        localLoadCount = new int[numLocals];
        localIncrementCount = new int[numLocals];
        methodGen = classContext.getMethodGen(method);
        cfg = classContext.getCFG(method);
        liveStoreSetAtEntry = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getResultFact(cfg.getEntry());
        complainedAbout = new BitSet();
        localsThatAreParameters = PreorderVisitor.getNumberArguments((String)method.getSignature());
        if (!method.isStatic()) {
            ++localsThatAreParameters;
        }
        this.countLocalStoresLoadsAndIncrements(localStoreCount, localLoadCount, localIncrementCount, cfg);
        i = cfg.locationIterator();
        while (i.hasNext()) {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            location = (Location)i.next();
                            pendingBugReportAboutOverwrittenParameter = null;
                            try {
                                propertySet = new WarningPropertySet();
                                if (this.isStore(location)) break block34;
                                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                            }
                            catch (Throwable var33_34) {
                                if (pendingBugReportAboutOverwrittenParameter != null) {
                                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                }
                                throw var33_34;
                            }
                            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                            continue;
                        }
                        if (location.getBasicBlock().isExceptionHandler()) {
                            propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.EXCEPTION_HANDLER);
                        }
                        if ((name = (lvAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation((Method)method, (Location)location, (IndexedInstruction)(ins = (IndexedInstruction)location.getHandle().getInstruction()))).getName()).charAt(0) == '$' || name.charAt(0) == '_') {
                            propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SYNTHETIC_NAME);
                        }
                        if (!FindDeadLocalStores.EXCLUDED_LOCALS.contains(name)) break block35;
                        if (pendingBugReportAboutOverwrittenParameter == null) continue;
                        this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                        continue;
                    }
                    propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, name);
                    local = ins.getIndex();
                    v0 = parameterThatIsDeadAtEntry = local < localsThatAreParameters && ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSetAtEntry, local) == false;
                    if (parameterThatIsDeadAtEntry && !complainedAbout.get(local)) {
                        pendingBugReportAboutOverwrittenParameter = new BugInstance((Detector)this, "IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN", 2).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation).addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle());
                        complainedAbout.set(local);
                    }
                    storeOfNull = false;
                    prevInsHandle = location.getHandle().getPrev();
                    if (prevInsHandle == null) ** GOTO lbl67
                    prevIns = prevInsHandle.getInstruction();
                    if (!(prevIns instanceof LDC) && !(prevIns instanceof ConstantPushInstruction)) break block36;
                    if (pendingBugReportAboutOverwrittenParameter == null) continue;
                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                    continue;
                }
                if (prevIns instanceof ACONST_NULL) {
                    storeOfNull = true;
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.STORE_OF_NULL);
                }
lbl67:
                // 4 sources

                liveStoreSet = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getFactAtLocation(location);
                if (!((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSet, local)) break block37;
                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                continue;
            }
            killedBySubsequentStore = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).killedByStore(liveStoreSet, local);
            if (killedBySubsequentStore) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.KILLED_BY_SUBSEQUENT_STORE);
            }
            prev = location.getBasicBlock().getPredecessorOf(location.getHandle());
            prevOpCode = -1;
            if (prev != null && FindDeadLocalStores.defensiveConstantValueOpcodes.get(prev.getInstruction().getOpcode())) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE);
                prevOpCode = prev.getInstruction().getOpcode();
            }
            if (prev != null && prev.getInstruction() instanceof GETFIELD && (prev2 = prev.getPrev()) != null && prev2.getInstruction() instanceof ALOAD) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.CACHING_VALUE);
            }
            if (ins instanceof IINC) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_INCREMENT);
                if (localIncrementCount[local] == 1) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_DEAD_INCREMENT);
                }
            } else if (ins instanceof ASTORE && prev != null) {
                prevIns = prev.getInstruction();
                if (prevIns instanceof INVOKESPECIAL && ((INVOKESPECIAL)prevIns).getMethodName(methodGen.getConstantPool()).equals("<init>") || prevIns instanceof ANEWARRAY || prevIns instanceof NEWARRAY || prevIns instanceof MULTIANEWARRAY) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_OBJECT_STORE);
                }
            } else if (!killedBySubsequentStore && localStoreCount[local] == 2 && localLoadCount[local] > 0) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.TWO_STORES_MULTIPLE_LOADS);
            } else if (!parameterThatIsDeadAtEntry && localStoreCount[local] == 1) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_STORE);
            } else if (!parameterThatIsDeadAtEntry && localLoadCount[local] == 0) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.NO_LOADS);
            }
            if (parameterThatIsDeadAtEntry) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.PARAM_DEAD_ON_ENTRY);
                if (pendingBugReportAboutOverwrittenParameter != null) {
                    pendingBugReportAboutOverwrittenParameter.setPriority(1);
                }
            }
            if (localStoreCount[local] > 3) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.MANY_STORES);
            }
            if ((priority = propertySet.computePriority(2)) <= 4) {
                bugInstance = new BugInstance((Detector)this, storeOfNull != false ? "DLS_DEAD_LOCAL_STORE_OF_NULL" : "DLS_DEAD_LOCAL_STORE", priority).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation);
                if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                    WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
                    propertySet.decorateBugInstance(bugInstance);
                }
                sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (MethodGen)methodGen, (String)javaClass.getSourceFileName(), (InstructionHandle)location.getHandle());
                if (FindDeadLocalStores.DEBUG) {
                    System.out.println(javaClass.getSourceFileName() + " : " + methodGen.getName());
                    System.out.println("priority: " + priority);
                    System.out.println("Reporting " + bugInstance);
                    System.out.println(propertySet);
                }
                accumulator.accumulateBug(bugInstance, sourceLineAnnotation);
            }
            if (pendingBugReportAboutOverwrittenParameter == null) continue;
            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
        }
        accumulator.reportAccumulatedBugs();
    }

    private void countLocalStoresLoadsAndIncrements(int[] localStoreCount, int[] localLoadCount, int[] localIncrementCount, CFG cfg) {
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            if (location.getBasicBlock().isExceptionHandler()) continue;
            boolean isStore = this.isStore(location);
            boolean isLoad = this.isLoad(location);
            if (!isStore && !isLoad) continue;
            IndexedInstruction ins = (IndexedInstruction)location.getHandle().getInstruction();
            int local = ins.getIndex();
            if (ins instanceof IINC) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                int n2 = local;
                localLoadCount[n2] = localLoadCount[n2] + 1;
                int n3 = local;
                localIncrementCount[n3] = localIncrementCount[n3] + 1;
                continue;
            }
            if (isStore) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                continue;
            }
            int n = local;
            localLoadCount[n] = localLoadCount[n] + 1;
        }
    }

    private void checkLocalVariableName(LocalVariableTable lvt, int local, int pc, WarningPropertySet propertySet) {
        LocalVariable lv;
        if (lvt != null && (lv = lvt.getLocalVariable(local, pc)) != null) {
            String localName = lv.getName();
            propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, localName);
        }
    }

    private boolean isStore(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof StoreInstruction || ins instanceof IINC;
    }

    private boolean isLoad(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LoadInstruction || ins instanceof IINC;
    }

    public void report() {
    }

    static {
        String exclLocalsProperty = SystemProperties.getProperty((String)FINDBUGS_EXCLUDED_LOCALS_PROP_NAME);
        if (exclLocalsProperty != null) {
            EXCLUDED_LOCALS.addAll(Arrays.asList(exclLocalsProperty.split(",")));
            EXCLUDED_LOCALS.remove("");
        }
        defensiveConstantValueOpcodes = new BitSet();
        defensiveConstantValueOpcodes.set(14);
        defensiveConstantValueOpcodes.set(15);
        defensiveConstantValueOpcodes.set(11);
        defensiveConstantValueOpcodes.set(12);
        defensiveConstantValueOpcodes.set(1);
        defensiveConstantValueOpcodes.set(3);
        defensiveConstantValueOpcodes.set(4);
    }
}

