/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTFunDecl;
import Mini.Environment;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.Node;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;

public class ASTIfExpr
extends ASTExpr
implements Constants {
    private ASTExpr if_expr;
    private ASTExpr then_expr;
    private ASTExpr else_expr;

    ASTIfExpr(int id2) {
        super(id2);
    }

    ASTIfExpr(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTIfExpr(p, id2);
    }

    public void closeNode() {
        this.if_expr = (ASTExpr)this.children[0];
        this.then_expr = (ASTExpr)this.children[1];
        if (this.children.length == 3) {
            this.else_expr = (ASTExpr)this.children[2];
        } else {
            MiniC.addError(this.if_expr.getLine(), this.if_expr.getColumn(), "IF expression has no ELSE branch");
        }
        this.children = null;
    }

    public ASTExpr traverse(Environment env) {
        this.env = env;
        this.if_expr = this.if_expr.traverse(env);
        this.then_expr = this.then_expr.traverse(env);
        if (this.else_expr != null) {
            this.else_expr = this.else_expr.traverse(env);
        }
        return this;
    }

    public int eval(int expected) {
        int else_type;
        int if_type = this.if_expr.eval(4);
        if (if_type != 4) {
            MiniC.addError(this.if_expr.getLine(), this.if_expr.getColumn(), "IF expression is not of type boolean, but " + TYPE_NAMES[if_type] + ".");
        }
        int then_type = this.then_expr.eval(expected);
        if (expected != 15 && then_type != expected) {
            MiniC.addError(this.then_expr.getLine(), this.then_expr.getColumn(), "THEN expression is not of expected type " + TYPE_NAMES[expected] + " but " + TYPE_NAMES[then_type] + ".");
        }
        if (this.else_expr != null) {
            else_type = this.else_expr.eval(expected);
            if (expected != 15 && else_type != expected) {
                MiniC.addError(this.else_expr.getLine(), this.else_expr.getColumn(), "ELSE expression is not of expected type " + TYPE_NAMES[expected] + " but " + TYPE_NAMES[else_type] + ".");
            } else if (then_type == 15) {
                then_type = else_type;
                this.then_expr.setType(else_type);
            }
        } else {
            else_type = then_type;
            this.else_expr = this.then_expr;
        }
        if (then_type != else_type) {
            MiniC.addError(this.line, this.column, "Type mismatch in THEN-ELSE: " + TYPE_NAMES[then_type] + " vs. " + TYPE_NAMES[else_type] + ".");
        }
        this.type = then_type;
        this.is_simple = this.if_expr.isSimple() && this.then_expr.isSimple() && this.else_expr.isSimple();
        return this.type;
    }

    public void code(StringBuffer buf) {
        this.if_expr.code(buf);
        buf.append("    if(" + ASTFunDecl.pop() + " == 1) {\n");
        int size = ASTFunDecl.size;
        this.then_expr.code(buf);
        ASTFunDecl.size = size;
        buf.append("    } else {\n");
        this.else_expr.code(buf);
        buf.append("    }\n");
    }

    public void byte_code(InstructionList il, MethodGen method, ConstantPoolGen cp) {
        this.if_expr.byte_code(il, method, cp);
        InstructionList then_code = new InstructionList();
        InstructionList else_code = new InstructionList();
        this.then_expr.byte_code(then_code, method, cp);
        this.else_expr.byte_code(else_code, method, cp);
        BranchHandle i = il.append(new IFEQ(null));
        ASTFunDecl.pop();
        il.append(then_code);
        BranchHandle g = il.append(new GOTO(null));
        i.setTarget(il.append(else_code));
        g.setTarget(il.append(InstructionConstants.NOP));
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        this.if_expr.dump(String.valueOf(prefix) + " ");
        this.then_expr.dump(String.valueOf(prefix) + " ");
        if (this.else_expr != null) {
            this.else_expr.dump(String.valueOf(prefix) + " ");
        }
    }
}

