/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.bcel.Constants;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public class JasminVisitor
extends EmptyVisitor {
    private JavaClass clazz;
    private PrintWriter out;
    private String class_name;
    private ConstantPoolGen cp;
    private Method _method;
    private Hashtable map;

    public JasminVisitor(JavaClass clazz, OutputStream out) {
        this.clazz = clazz;
        this.out = new PrintWriter(out);
        this.class_name = clazz.getClassName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
    }

    public void disassemble() {
        new DescendingVisitor(this.clazz, this).visit();
        this.out.close();
    }

    public void visitJavaClass(JavaClass clazz) {
        this.out.println(";; Produced by JasminVisitor (BCEL)");
        this.out.println(";; http://jakarta.apache.org/bcel/");
        this.out.println(";; " + new Date() + "\n");
        this.out.println(".source " + clazz.getSourceFileName());
        this.out.println("." + Utility.classOrInterface(clazz.getAccessFlags()) + " " + Utility.accessToString(clazz.getAccessFlags(), true) + " " + clazz.getClassName().replace('.', '/'));
        this.out.println(".super " + clazz.getSuperclassName().replace('.', '/'));
        String[] interfaces = clazz.getInterfaceNames();
        int i = 0;
        while (i < interfaces.length) {
            this.out.println(".implements " + interfaces[i].replace('.', '/'));
            ++i;
        }
        this.out.print("\n");
    }

    public void visitField(Field field) {
        this.out.print(".field " + Utility.accessToString(field.getAccessFlags()) + " \"" + field.getName() + "\"" + field.getSignature());
        if (field.getAttributes().length == 0) {
            this.out.print("\n");
        }
    }

    public void visitConstantValue(ConstantValue cv) {
        this.out.println(" = " + cv);
    }

    private final void printEndMethod(Attribute attr) {
        Attribute[] attributes = this._method.getAttributes();
        if (attr == attributes[attributes.length - 1]) {
            this.out.println(".end method");
        }
    }

    public void visitDeprecated(Deprecated attribute) {
        this.printEndMethod(attribute);
    }

    public void visitSynthetic(Synthetic attribute) {
        if (this._method != null) {
            this.printEndMethod(attribute);
        }
    }

    public void visitMethod(Method method) {
        this._method = method;
        this.out.println("\n.method " + Utility.accessToString(this._method.getAccessFlags()) + " " + this._method.getName() + this._method.getSignature());
        Attribute[] attributes = this._method.getAttributes();
        if (attributes == null || attributes.length == 0) {
            this.out.println(".end method");
        }
    }

    public void visitExceptionTable(ExceptionTable e) {
        String[] names = e.getExceptionNames();
        int i = 0;
        while (i < names.length) {
            this.out.println(".throws " + names[i].replace('.', '/'));
            ++i;
        }
        this.printEndMethod(e);
    }

    public void visitCode(Code code) {
        InstructionHandle ih;
        InstructionHandle ih2;
        int label_counter = 0;
        this.out.println(".limit stack " + code.getMaxStack());
        this.out.println(".limit locals " + code.getMaxLocals());
        MethodGen mg = new MethodGen(this._method, this.class_name, this.cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        this.map = new Hashtable();
        int i = 0;
        while (i < ihs.length) {
            if (ihs[i] instanceof BranchHandle) {
                BranchInstruction bi = (BranchInstruction)ihs[i].getInstruction();
                if (bi instanceof Select) {
                    InstructionHandle[] targets = ((Select)bi).getTargets();
                    int j = 0;
                    while (j < targets.length) {
                        this.put(targets[j], "Label" + label_counter++ + ":");
                        ++j;
                    }
                }
                ih2 = bi.getTarget();
                this.put(ih2, "Label" + label_counter++ + ":");
            }
            ++i;
        }
        LocalVariableGen[] lvs = mg.getLocalVariables();
        int i2 = 0;
        while (i2 < lvs.length) {
            ih2 = lvs[i2].getStart();
            this.put(ih2, "Label" + label_counter++ + ":");
            ih2 = lvs[i2].getEnd();
            this.put(ih2, "Label" + label_counter++ + ":");
            ++i2;
        }
        CodeExceptionGen[] ehs = mg.getExceptionHandlers();
        int i3 = 0;
        while (i3 < ehs.length) {
            CodeExceptionGen c = ehs[i3];
            ih = c.getStartPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getEndPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getHandlerPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ++i3;
        }
        LineNumberGen[] lns = mg.getLineNumbers();
        int i4 = 0;
        while (i4 < lns.length) {
            ih = lns[i4].getInstruction();
            this.put(ih, ".line " + lns[i4].getSourceLine());
            ++i4;
        }
        i4 = 0;
        while (i4 < lvs.length) {
            LocalVariableGen l = lvs[i4];
            this.out.println(".var " + l.getIndex() + " is " + l.getName() + " " + l.getType().getSignature() + " from " + this.get(l.getStart()) + " to " + this.get(l.getEnd()));
            ++i4;
        }
        this.out.print("\n");
        i4 = 0;
        while (i4 < ihs.length) {
            ih = ihs[i4];
            Instruction inst = ih.getInstruction();
            String str = (String)this.map.get(ih);
            if (str != null) {
                this.out.println(str);
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    int j;
                    Select s = (Select)inst;
                    int[] matchs = s.getMatchs();
                    InstructionHandle[] targets = s.getTargets();
                    if (s instanceof TABLESWITCH) {
                        this.out.println("\ttableswitch " + matchs[0] + " " + matchs[matchs.length - 1]);
                        j = 0;
                        while (j < targets.length) {
                            this.out.println("\t\t" + this.get(targets[j]));
                            ++j;
                        }
                    } else {
                        this.out.println("\tlookupswitch ");
                        j = 0;
                        while (j < targets.length) {
                            this.out.println("\t\t" + matchs[j] + " : " + this.get(targets[j]));
                            ++j;
                        }
                    }
                    this.out.println("\t\tdefault: " + this.get(s.getTarget()));
                } else {
                    BranchInstruction bi = (BranchInstruction)inst;
                    ih = bi.getTarget();
                    str = this.get(ih);
                    this.out.println("\t" + Constants.OPCODE_NAMES[bi.getOpcode()] + " " + str);
                }
            } else {
                this.out.println("\t" + inst.toString(this.cp.getConstantPool()));
            }
            ++i4;
        }
        this.out.print("\n");
        i4 = 0;
        while (i4 < ehs.length) {
            CodeExceptionGen c = ehs[i4];
            ObjectType caught = c.getCatchType();
            String class_name = caught == null ? "all" : caught.getClassName().replace('.', '/');
            this.out.println(".catch " + class_name + " from " + this.get(c.getStartPC()) + " to " + this.get(c.getEndPC()) + " using " + this.get(c.getHandlerPC()));
            ++i4;
        }
        this.printEndMethod(code);
    }

    private final String get(InstructionHandle ih) {
        String str = new StringTokenizer((String)this.map.get(ih), "\n").nextToken();
        return str.substring(0, str.length() - 1);
    }

    private final void put(InstructionHandle ih, String line) {
        String str = (String)this.map.get(ih);
        if (str == null) {
            this.map.put(ih, line);
        } else {
            if (line.startsWith("Label") || str.endsWith(line)) {
                return;
            }
            this.map.put(ih, String.valueOf(str) + "\n" + line);
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                System.err.println("disassemble: No input files specified");
            } else {
                int i = 0;
                while (i < argv.length) {
                    JavaClass java_class = Repository.lookupClass(argv[i]);
                    if (java_class == null) {
                        java_class = new ClassParser(argv[i]).parse();
                    }
                    String class_name = java_class.getClassName();
                    int index = class_name.lastIndexOf(46);
                    String path = class_name.substring(0, index + 1).replace('.', File.separatorChar);
                    class_name = class_name.substring(index + 1);
                    if (!path.equals("")) {
                        File f = new File(path);
                        f.mkdirs();
                    }
                    String name = String.valueOf(path) + class_name + ".j";
                    FileOutputStream out = new FileOutputStream(name);
                    new JasminVisitor(java_class, out).disassemble();
                    System.out.println("File dumped to: " + name);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

