/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseValueOfResolution
extends BugResolution {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$UseValueOfResolution;

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && workingUnit == null) {
            throw new AssertionError();
        }
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        Statement statement = ASTUtil.getStatement(workingUnit, method, bug.getPrimarySourceLineAnnotation());
        ClassInstanceCreation primitiveTypeCreation = this.findPrimitiveTypeCreation(statement);
        if (primitiveTypeCreation == null) {
            throw new BugResolutionException("Primitive type creation not found.");
        }
        MethodInvocation valueOfInvocation = this.createValueOfInvocation(rewrite, primitiveTypeCreation);
        rewrite.replace((ASTNode)primitiveTypeCreation, (ASTNode)valueOfInvocation, null);
    }

    @CheckForNull
    protected ClassInstanceCreation findPrimitiveTypeCreation(Statement statement) {
        switch (statement.getNodeType()) {
            case 60: {
                return this.findPrimitiveTypeCreation(((VariableDeclarationStatement)statement).fragments());
            }
        }
        return null;
    }

    @CheckForNull
    protected ClassInstanceCreation findPrimitiveTypeCreation(List<VariableDeclarationFragment> variableDeclarations) {
        for (VariableDeclarationFragment variableDeclaration : variableDeclarations) {
            Expression initializer = variableDeclaration.getInitializer();
            if (initializer == null || !(initializer instanceof ClassInstanceCreation)) continue;
            return (ClassInstanceCreation)initializer;
        }
        return null;
    }

    protected MethodInvocation createValueOfInvocation(ASTRewrite rewrite, ClassInstanceCreation primitiveTypeCreation) {
        AST ast = rewrite.getAST();
        MethodInvocation valueOfInvocation = ast.newMethodInvocation();
        List arguments = primitiveTypeCreation.arguments();
        SimpleName primitiveTypeName = ast.newSimpleName(primitiveTypeCreation.getType().resolveBinding().getName());
        valueOfInvocation.setExpression((Expression)primitiveTypeName);
        valueOfInvocation.setName(ast.newSimpleName("valueOf"));
        List newArguments = valueOfInvocation.arguments();
        for (Expression argument : arguments) {
            Expression expression = (Expression)rewrite.createCopyTarget((ASTNode)argument);
            newArguments.add(expression);
        }
        return valueOfInvocation;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$UseValueOfResolution == null ? (class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$UseValueOfResolution = UseValueOfResolution.class$("edu.umd.cs.findbugs.plugin.eclipse.quickfix.UseValueOfResolution")) : class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$UseValueOfResolution).desiredAssertionStatus();
    }
}

