/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public abstract class CorrectOddnessCheckResolution
extends BugResolution {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && workingUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bug == null) {
            throw new AssertionError();
        }
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        Statement statement = ASTUtil.getStatement(workingUnit, method, bug.getPrimarySourceLineAnnotation());
        String originalFieldName = null;
        if (!(statement instanceof IfStatement)) {
            throw new BugResolutionException("Statement is not of type IfStatement");
        }
        originalFieldName = this.getOriginalFieldName((IfStatement)statement);
        AST ast = workingUnit.getAST();
        SimpleName replaceField = ast.newSimpleName(originalFieldName);
        InfixExpression replaceExpression = this.createReplaceExpression(ast, replaceField);
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)replaceExpression, null);
    }

    protected abstract InfixExpression createReplaceExpression(AST var1, SimpleName var2);

    protected String getOriginalFieldName(IfStatement originalStatement) {
        InfixExpression originalLeftOperand;
        if (!$assertionsDisabled && originalStatement == null) {
            throw new AssertionError();
        }
        InfixExpression originalExpression = (InfixExpression)originalStatement.getExpression();
        Expression leftOperand = originalExpression.getLeftOperand();
        if (leftOperand.getClass().equals(ParenthesizedExpression.class)) {
            ParenthesizedExpression parEx = (ParenthesizedExpression)originalExpression.getLeftOperand();
            originalLeftOperand = (InfixExpression)parEx.getExpression();
        } else {
            originalLeftOperand = (InfixExpression)originalExpression.getLeftOperand();
        }
        SimpleName originalField = (SimpleName)originalLeftOperand.getLeftOperand();
        return originalField.getIdentifier();
    }

    protected boolean resolveBindings() {
        return true;
    }

    static {
        $assertionsDisabled = !CorrectOddnessCheckResolution.class.desiredAssertionStatus();
    }
}

