/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.ProjectUtilities;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.ExtendedPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.util.FileSelectionDialog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FindbugsPropertyPage
extends PropertyPage {
    private static final String COLUMN_PROPS_DESCRIPTION = "description";
    private static final String COLUMN_PROPS_NAME = "name";
    private static final String COLUMN_PROPS_BUG_ABBREV = "bug codes";
    private boolean initialEnabled;
    private Button chkEnableFindBugs;
    private Combo minPriorityCombo;
    private Button[] chkEnableBugCategoryList;
    private String[] bugCategoryList;
    private UserPreferences origUserPreferences;
    private UserPreferences currentUserPreferences;
    private IProject project;
    protected CheckboxTableViewer availableFactoriesTableViewer;
    protected Map<DetectorFactory, String> factoriesToBugAbbrev;
    private Button restoreDefaultsButton;
    private ComboViewer effortViewer;
    private ExtendedPreferences origExtendedPreferences;
    private ExtendedPreferences currentExtendedPreferences;
    private EffortPlaceHolder[] effortLevels;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IAdaptable resource = this.getElement();
        this.project = (IProject)resource.getAdapter(IProject.class);
        this.collectUserPreferences();
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.chkEnableFindBugs = new Button(composite, 32);
        this.chkEnableFindBugs.setText(this.getMessage("property.runAuto"));
        this.initialEnabled = this.isEnabled();
        this.chkEnableFindBugs.setSelection(this.initialEnabled);
        Composite prioGroup = new Composite(composite, 0);
        GridLayout prioLayout = new GridLayout(3, false);
        prioGroup.setLayout((Layout)prioLayout);
        Label minPrioLabel = new Label(prioGroup, 0);
        minPrioLabel.setText(this.getMessage("property.minPriority"));
        minPrioLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo = new Combo(prioGroup, 12);
        this.minPriorityCombo.add("High");
        this.minPriorityCombo.add("Medium");
        this.minPriorityCombo.add("Low");
        this.minPriorityCombo.setText(this.origUserPreferences.getFilterSettings().getMinPriority());
        this.minPriorityCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String data = FindbugsPropertyPage.this.minPriorityCombo.getText();
                System.out.println("Minimum priority changed to " + data + "!");
                FindbugsPropertyPage.this.currentUserPreferences.getFilterSettings().setMinPriority(data);
            }
        });
        Composite categoryGroup = new Composite(composite, 0);
        categoryGroup.setLayout((Layout)new GridLayout(2, true));
        Label activeCategoriesLabel = new Label(categoryGroup, 0);
        activeCategoriesLabel.setText(this.getMessage("property.enableCategory"));
        activeCategoriesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buildBugCategoryList(categoryGroup, this.project);
        this.buildLabel(composite, "property.selectPattern");
        Table availableRulesTable = this.buildAvailableRulesTableViewer(composite, this.project);
        GridData tableLayoutData = new GridData();
        tableLayoutData.grabExcessHorizontalSpace = true;
        tableLayoutData.grabExcessVerticalSpace = true;
        tableLayoutData.horizontalAlignment = 4;
        tableLayoutData.verticalAlignment = 4;
        tableLayoutData.heightHint = 50;
        tableLayoutData.widthHint = 590;
        availableRulesTable.setLayoutData((Object)tableLayoutData);
        this.addSeparator(composite);
        this.restoreDefaultsButton = new Button(composite, 0);
        this.restoreDefaultsButton.setText(this.getMessage("property.restoreSettings"));
        this.restoreDefaultsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.restoreDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindbugsPropertyPage.this.restoreDefaultSettings();
            }
        });
        TabItem generalTab = new TabItem(tabFolder, 0);
        generalTab.setText(this.getMessage("property.tabgeneral"));
        generalTab.setControl((Control)composite);
        TabItem extendedTab = new TabItem(tabFolder, 0);
        extendedTab.setText(this.getMessage("property.tabextended"));
        extendedTab.setControl((Control)this.createExtendedComposite((Composite)tabFolder));
        return composite;
    }

    private Composite createExtendedComposite(Composite parent) {
        this.collectExtendedPreferences();
        Composite extendedComposite = new Composite(parent, 0);
        extendedComposite.setLayout((Layout)new GridLayout(2, false));
        Label effortLabel = new Label(extendedComposite, 0);
        effortLabel.setText(this.getMessage("property.effort"));
        effortLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.effortViewer = new ComboViewer(extendedComposite, 12);
        this.effortViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.effortViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.effortLevels = new EffortPlaceHolder[]{new EffortPlaceHolder(this.getMessage("property.effortmin"), "min"), new EffortPlaceHolder(this.getMessage("property.effortdefault"), "default"), new EffortPlaceHolder(this.getMessage("property.effortmax"), "max")};
        this.effortViewer.add((Object[])this.effortLevels);
        String effort = this.currentExtendedPreferences.getEffort();
        for (int i = 0; i < this.effortLevels.length; ++i) {
            if (!this.effortLevels[i].getEffortLevel().equals(effort)) continue;
            this.effortViewer.setSelection((ISelection)new StructuredSelection((Object)this.effortLevels[i]), true);
        }
        this.effortViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EffortPlaceHolder placeHolder = (EffortPlaceHolder)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                FindbugsPropertyPage.this.currentExtendedPreferences.setEffort(placeHolder.getEffortLevel());
            }
        });
        this.createFilterTable(extendedComposite, true);
        this.createFilterTable(extendedComposite, false);
        return extendedComposite;
    }

    private void createFilterTable(Composite parent, final boolean includeFilter) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label titleLabel = new Label(tableComposite, 0);
        final String title = includeFilter ? this.getMessage("property.includefilter") : this.getMessage("property.excludefilter");
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        final TableViewer viewer = new TableViewer(tableComposite, 2818);
        viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        String[] filterFiles = includeFilter ? this.currentExtendedPreferences.getIncludeFilterFiles() : this.currentExtendedPreferences.getExcludeFilterFiles();
        final ArrayList<FilePlaceHolder> filters = new ArrayList<FilePlaceHolder>();
        if (filterFiles != null) {
            for (int i = 0; i < filterFiles.length; ++i) {
                filters.add(new FilePlaceHolder(this.project.getFile(filterFiles[i])));
            }
        }
        viewer.add(filters.toArray());
        final Button addButton = new Button(tableComposite, 8);
        String addButtonLabel = includeFilter ? this.getMessage("property.includefilteraddbutton") : this.getMessage("property.excludefilteraddbutton");
        addButton.setText(addButtonLabel);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog dialog = new FileSelectionDialog(addButton.getShell(), title, ".xml");
                dialog.setInput(FindbugsPropertyPage.this.project);
                dialog.setAllowMultiple(true);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    for (int i = 0; i < result.length; ++i) {
                        FilePlaceHolder holder = new FilePlaceHolder((IFile)result[i]);
                        filters.add(holder);
                        viewer.add((Object)holder);
                    }
                    if (includeFilter) {
                        FindbugsPropertyPage.this.currentExtendedPreferences.setIncludeFilterFiles(FindbugsPropertyPage.this.filesToStrings(filters));
                    } else {
                        FindbugsPropertyPage.this.currentExtendedPreferences.setExcludeFilterFiles(FindbugsPropertyPage.this.filesToStrings(filters));
                    }
                }
            }
        });
        final Button removeButton = new Button(tableComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, 1, false, true));
        String removeButtonLabel = includeFilter ? this.getMessage("property.includefilterremovebutton") : this.getMessage("property.excludefilterremovebutton");
        removeButton.setText(removeButtonLabel);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selectionIter = ((IStructuredSelection)viewer.getSelection()).iterator();
                while (selectionIter.hasNext()) {
                    Object element = selectionIter.next();
                    FilePlaceHolder holder = (FilePlaceHolder)((Object)element);
                    filters.remove((Object)holder);
                    viewer.remove((Object)holder);
                }
                if (includeFilter) {
                    FindbugsPropertyPage.this.currentExtendedPreferences.setIncludeFilterFiles(FindbugsPropertyPage.this.filesToStrings(filters));
                } else {
                    FindbugsPropertyPage.this.currentExtendedPreferences.setExcludeFilterFiles(FindbugsPropertyPage.this.filesToStrings(filters));
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private String[] filesToStrings(List filters) {
        String[] result = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FilePlaceHolder holder = (FilePlaceHolder)((Object)filters.get(i));
            result[i] = holder.getFile().getProjectRelativePath().toString();
        }
        return result;
    }

    private void collectUserPreferences() {
        try {
            this.origUserPreferences = FindbugsPlugin.getUserPreferences(this.project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get user preferences for project");
            this.origUserPreferences = UserPreferences.createDefaultUserPreferences();
        }
        this.currentUserPreferences = (UserPreferences)this.origUserPreferences.clone();
    }

    private void collectExtendedPreferences() {
        try {
            this.origExtendedPreferences = FindbugsPlugin.getExtendedPreferences(this.project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not get user preferences for project");
            this.origExtendedPreferences = new ExtendedPreferences();
        }
        this.currentExtendedPreferences = (ExtendedPreferences)this.origExtendedPreferences.clone();
    }

    private void restoreDefaultSettings() {
        this.chkEnableFindBugs.setSelection(false);
        this.minPriorityCombo.setText("Medium");
        for (int i = 0; i < this.chkEnableBugCategoryList.length; ++i) {
            this.chkEnableBugCategoryList[i].setSelection(true);
        }
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        for (int i = 0; i < itemList.length; ++i) {
            TableItem item = itemList[i];
            DetectorFactory factory = (DetectorFactory)item.getData();
            item.setChecked(factory.isDefaultEnabled());
        }
    }

    private void addSeparator(Composite composite) {
        Label separator = new Label(composite, 262);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)data);
    }

    private void buildBugCategoryList(Composite categoryGroup, final IProject project) {
        DetectorFactoryCollection.instance();
        LinkedList bugCategoryList = new LinkedList(I18N.instance().getBugCategories());
        LinkedList<Button> checkBoxList = new LinkedList<Button>();
        Iterator i = bugCategoryList.iterator();
        while (i.hasNext()) {
            String category = (String)i.next();
            Button checkBox = new Button(categoryGroup, 32);
            checkBox.setText(I18N.instance().getBugCategoryDescription(category));
            checkBox.setSelection(this.origUserPreferences.getFilterSettings().containsCategory(category));
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = 15;
            checkBox.setLayoutData((Object)layoutData);
            checkBox.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    System.out.println("Category preferences changed!");
                    FindbugsPropertyPage.this.syncSelectedCategories();
                    FindbugsPropertyPage.this.populateAvailableRulesTable(project);
                }
            });
            checkBoxList.add(checkBox);
        }
        this.chkEnableBugCategoryList = checkBoxList.toArray(new Button[checkBoxList.size()]);
        this.bugCategoryList = bugCategoryList.toArray(new String[bugCategoryList.size()]);
    }

    private void syncSelectedCategories() {
        for (int i = 0; i < this.chkEnableBugCategoryList.length; ++i) {
            Button checkBox = this.chkEnableBugCategoryList[i];
            String category = this.bugCategoryList[i];
            if (checkBox.getSelection()) {
                this.currentUserPreferences.getFilterSettings().addCategory(category);
                continue;
            }
            this.currentUserPreferences.getFilterSettings().removeCategory(category);
        }
    }

    private Table buildAvailableRulesTableViewer(Composite parent, IProject project) {
        BugPatternTableSorter sorter = new BugPatternTableSorter(this);
        int tableStyle = 68388;
        this.availableFactoriesTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)tableStyle);
        this.availableFactoriesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                System.out.println("Detector selection changed!");
                FindbugsPropertyPage.this.syncUserPreferencesWithTable();
            }
        });
        int currentColumnIdx = -1;
        Table factoriesTable = this.availableFactoriesTableViewer.getTable();
        TableColumn bugsAbbrevColumn = new TableColumn(factoriesTable, 16384);
        bugsAbbrevColumn.setResizable(true);
        bugsAbbrevColumn.setText(this.getMessage("property.bugCodes"));
        bugsAbbrevColumn.setWidth(100);
        this.addColumnSelectionListener(sorter, bugsAbbrevColumn, ++currentColumnIdx);
        TableColumn factoryNameColumn = new TableColumn(factoriesTable, 16384);
        factoryNameColumn.setResizable(true);
        factoryNameColumn.setText(this.getMessage("property.detectorName"));
        factoryNameColumn.setWidth(200);
        this.addColumnSelectionListener(sorter, factoryNameColumn, ++currentColumnIdx);
        TableColumn bugsDescriptionColumn = new TableColumn(factoriesTable, 4);
        bugsDescriptionColumn.setResizable(true);
        bugsDescriptionColumn.setText(this.getMessage("property.detectorDescription"));
        bugsDescriptionColumn.setWidth(280);
        factoriesTable.setLinesVisible(true);
        factoriesTable.setHeaderVisible(true);
        this.availableFactoriesTableViewer.setContentProvider((IContentProvider)new DetectorFactoriesContentProvider());
        this.availableFactoriesTableViewer.setLabelProvider((IBaseLabelProvider)new DetectorFactoryLabelProvider(this));
        this.availableFactoriesTableViewer.setColumnProperties(new String[]{COLUMN_PROPS_BUG_ABBREV, COLUMN_PROPS_NAME, COLUMN_PROPS_DESCRIPTION});
        this.availableFactoriesTableViewer.setSorter((ViewerSorter)sorter);
        this.populateAvailableRulesTable(project);
        factoriesTable.setEnabled(true);
        return factoriesTable;
    }

    private void addColumnSelectionListener(final BugPatternTableSorter sorter, TableColumn column, final int columnIdx) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumnIndex(columnIdx);
                FindbugsPropertyPage.this.availableFactoriesTableViewer.refresh();
            }
        });
    }

    private boolean reportsInEnabledCategory(DetectorFactory factory) {
        Iterator i = factory.getReportedBugPatterns().iterator();
        while (i.hasNext()) {
            BugPattern pattern = (BugPattern)i.next();
            if (!this.currentUserPreferences.getFilterSettings().containsCategory(pattern.getCategory())) continue;
            return true;
        }
        return false;
    }

    private void populateAvailableRulesTable(IProject project) {
        ArrayList<DetectorFactory> allAvailableList = new ArrayList<DetectorFactory>();
        this.factoriesToBugAbbrev = new HashMap<DetectorFactory, String>();
        Iterator iterator = DetectorFactoryCollection.instance().factoryIterator();
        while (iterator.hasNext()) {
            DetectorFactory factory = (DetectorFactory)iterator.next();
            if (factory.isHidden() || !this.reportsInEnabledCategory(factory)) continue;
            allAvailableList.add(factory);
            this.addBugsAbbreviation(factory);
        }
        this.availableFactoriesTableViewer.setInput(allAvailableList);
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        for (int i = 0; i < itemList.length; ++i) {
            DetectorFactory rule = (DetectorFactory)itemList[i].getData();
            if (!this.currentUserPreferences.isDetectorEnabled(rule)) continue;
            itemList[i].setChecked(true);
        }
    }

    protected void addBugsAbbreviation(DetectorFactory factory) {
        this.factoriesToBugAbbrev.put(factory, this.createBugsAbbreviation(factory));
    }

    protected String getBugsAbbreviation(DetectorFactory factory) {
        String abbr = this.factoriesToBugAbbrev.get(factory);
        if (abbr == null) {
            abbr = this.createBugsAbbreviation(factory);
        }
        if (abbr == null) {
            abbr = "";
        }
        return abbr;
    }

    protected String createBugsAbbreviation(DetectorFactory factory) {
        StringBuffer sb = new StringBuffer();
        Collection patterns = factory.getReportedBugPatterns();
        LinkedHashSet<String> abbrs = new LinkedHashSet<String>();
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            BugPattern pattern = (BugPattern)iter.next();
            String abbr = pattern.getAbbrev();
            abbrs.add(abbr);
        }
        iter = abbrs.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            sb.append(element);
            if (!iter.hasNext()) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        String message = this.getMessage(msgKey);
        label.setText(message == null ? msgKey : message);
        return label;
    }

    public boolean performOk() {
        boolean selection = this.chkEnableFindBugs.getSelection();
        boolean result = true;
        boolean filterOptionsChanged = false;
        if (!this.currentUserPreferences.equals((Object)this.origUserPreferences)) {
            try {
                FindbugsPlugin.saveUserPreferences(this.project, this.currentUserPreferences);
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not store FindBugs preferences for project");
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not store FindBugs preferences for project");
            }
            if (!this.currentUserPreferences.getFilterSettings().equals((Object)this.origUserPreferences.getFilterSettings())) {
                filterOptionsChanged = true;
            }
        }
        if (!this.currentExtendedPreferences.equals(this.origExtendedPreferences)) {
            try {
                if (!FindbugsPlugin.getUserPreferencesFile(this.project).exists()) {
                    FindbugsPlugin.saveUserPreferences(this.project, this.currentUserPreferences);
                }
                FindbugsPlugin.saveExtendedPreferences(this.project, this.currentExtendedPreferences);
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not store FindBugs preferences for project");
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not store FindBugs preferences for project");
            }
            if (this.initialEnabled && selection) {
                this.runFindbugsBuilder();
            }
        }
        if (!this.initialEnabled && selection) {
            result = this.addNature();
        } else if (this.initialEnabled && !selection) {
            result = this.removeNature();
        }
        if (result && filterOptionsChanged) {
            MarkerUtil.redisplayMarkers(this.project, this.getShell());
        }
        return result;
    }

    private boolean isEnabled() {
        boolean result = false;
        try {
            if (this.project.hasNature("edu.umd.cs.findbugs.plugin.eclipse.findbugsNature")) {
                result = true;
            }
        }
        catch (CoreException e) {
            System.err.println("Exception: " + (Object)((Object)e));
        }
        return result;
    }

    protected IProject getProject() {
        return this.project;
    }

    private void runFindbugsBuilder() {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
        try {
            monitor.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        FindbugsPropertyPage.this.getProject().build(15, "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder", null, monitor);
                    }
                    catch (OperationCanceledException e) {
                    }
                    catch (CoreException e) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Error while runnning FindBugs builder for project");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            FindbugsPlugin.getDefault().logException(e, "Error while runnning FindBugs builder for project");
        }
        catch (InterruptedException e) {
            FindbugsPlugin.getDefault().logException(e, "Findbugs builder was interrupted");
        }
    }

    private boolean addNature() {
        boolean result = true;
        try {
            NatureWorker worker = new NatureWorker(true);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
            monitor.run(true, true, (IRunnableWithProgress)worker);
        }
        catch (InvocationTargetException e) {
            System.err.println("Exception: " + e);
        }
        catch (InterruptedException e) {
            System.err.println("Exception: " + e);
        }
        return result;
    }

    private boolean removeNature() {
        boolean result = true;
        try {
            NatureWorker worker = new NatureWorker(false);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
            monitor.run(true, true, (IRunnableWithProgress)worker);
        }
        catch (InvocationTargetException e) {
            System.err.println("Exception: " + e);
        }
        catch (InterruptedException e) {
            System.err.println("Exception: " + e);
        }
        return result;
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    protected void syncUserPreferencesWithTable() {
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        for (int i = 0; i < itemList.length; ++i) {
            DetectorFactory factory = (DetectorFactory)itemList[i].getData();
            this.currentUserPreferences.enableDetector(factory, itemList[i].getChecked());
        }
    }

    private static final class FilePlaceHolder
    extends WorkbenchAdapter
    implements IAdaptable {
        private final IFile file;

        public FilePlaceHolder(IFile file) {
            this.file = file;
        }

        public String getLabel(Object object) {
            return this.file.getProjectRelativePath().toString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.file.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = FindbugsPropertyPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
            if (adapter != null) {
                return adapter.getImageDescriptor((Object)this.file);
            }
            return super.getImageDescriptor(object);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = FindbugsPropertyPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
                return this;
            }
            return null;
        }

        public IFile getFile() {
            return this.file;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof FilePlaceHolder) {
                return this.file.equals(((FilePlaceHolder)((Object)obj)).file);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    private static final class EffortPlaceHolder
    extends WorkbenchAdapter
    implements IAdaptable {
        private final String name;
        private final String effortLevel;

        public EffortPlaceHolder(String name, String effortLevel) {
            this.name = name;
            this.effortLevel = effortLevel;
        }

        public String getLabel(Object object) {
            return this.name;
        }

        public String getEffortLevel() {
            return this.effortLevel;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = FindbugsPropertyPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
                return this;
            }
            return null;
        }
    }

    private static final class DetectorFactoriesContentProvider
    implements IStructuredContentProvider {
        private DetectorFactoriesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return null;
        }
    }

    private static final class DetectorFactoryLabelProvider
    implements ITableLabelProvider {
        private FindbugsPropertyPage page;

        DetectorFactoryLabelProvider(FindbugsPropertyPage page) {
            this.page = page;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof DetectorFactory)) {
                return null;
            }
            DetectorFactory factory = (DetectorFactory)element;
            switch (columnIndex) {
                case 0: {
                    return this.page.getBugsAbbreviation(factory);
                }
                case 1: {
                    return factory.getShortName();
                }
                case 2: {
                    StringBuffer sb = new StringBuffer();
                    Collection patterns = factory.getReportedBugPatterns();
                    Iterator iter = patterns.iterator();
                    while (iter.hasNext()) {
                        BugPattern pattern = (BugPattern)iter.next();
                        sb.append(pattern.getShortDescription());
                        if (!iter.hasNext()) continue;
                        sb.append(" | ");
                    }
                    return sb.toString();
                }
            }
            return null;
        }
    }

    private static final class BugPatternTableSorter
    extends ViewerSorter
    implements Comparator {
        private int sortColumnIndex;
        private int lastSortColumnIdx;
        boolean revertOrder;
        private FindbugsPropertyPage page;

        BugPatternTableSorter(FindbugsPropertyPage page) {
            this.page = page;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        public int compare(Object e1, Object e2) {
            String s2;
            String s1;
            int result = 0;
            DetectorFactory factory1 = (DetectorFactory)e1;
            DetectorFactory factory2 = (DetectorFactory)e2;
            switch (this.getSortColumnIndex()) {
                case 0: {
                    s1 = this.page.getBugsAbbreviation(factory1);
                    s2 = this.page.getBugsAbbreviation(factory2);
                    break;
                }
                default: {
                    s1 = "" + factory1.getShortName();
                    s2 = factory2.getShortName();
                }
            }
            result = s1.compareTo(s2);
            if (result == 0) {
                switch (this.getSortColumnIndex()) {
                    case 0: {
                        s1 = "" + factory1.getShortName();
                        s2 = factory2.getShortName();
                        break;
                    }
                    default: {
                        s1 = this.page.getBugsAbbreviation(factory1);
                        s2 = this.page.getBugsAbbreviation(factory2);
                    }
                }
                result = s1.compareTo(s2);
            } else if (this.revertOrder) {
                result = -result;
            }
            return result;
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals(FindbugsPropertyPage.COLUMN_PROPS_NAME) || property.equals(FindbugsPropertyPage.COLUMN_PROPS_BUG_ABBREV);
        }

        public void setSortColumnIndex(int sortColumnIndex) {
            this.lastSortColumnIdx = this.sortColumnIndex;
            this.sortColumnIndex = sortColumnIndex;
            this.revertOrder = !this.revertOrder && this.lastSortColumnIdx == sortColumnIndex;
        }

        public int getSortColumnIndex() {
            return this.sortColumnIndex;
        }
    }

    private final class NatureWorker
    implements IRunnableWithProgress {
        private boolean add = true;

        public NatureWorker(boolean add) {
            this.add = add;
        }

        public void run(IProgressMonitor monitor) {
            try {
                if (this.add) {
                    ProjectUtilities.addFindBugsNature(FindbugsPropertyPage.this.project, monitor);
                } else {
                    ProjectUtilities.removeFindBugsNature(FindbugsPropertyPage.this.project, monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                System.err.println("Exception: " + (Object)((Object)e));
            }
        }
    }
}

