/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.workflow.RecursiveSearchForJavaFiles;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;

public class SetBugDatabaseInfo {
    private static final String USAGE = "Usage: <cmd>  [options] [<oldData> [<newData>]]";
    static SourceSearcher sourceSearcher;

    public static void main(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        SetInfoCommandLine commandLine = new SetInfoCommandLine();
        int argCount = commandLine.parse(args, 0, 2, USAGE);
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount < args.length) {
            origCollection.readXML(args[argCount++], project);
        } else {
            origCollection.readXML(System.in, project);
        }
        if (commandLine.revisionName != null) {
            origCollection.setReleaseName(commandLine.revisionName);
        }
        if (commandLine.revisionTimestamp != 0L) {
            origCollection.setTimestamp(commandLine.revisionTimestamp);
        }
        Iterator<String> i$ = commandLine.sourcePaths.iterator();
        while (i$.hasNext()) {
            String source = i$.next();
            project.addSourceDir(source);
        }
        HashMap missingFiles = new HashMap();
        if (!commandLine.searchSourcePaths.isEmpty()) {
            sourceSearcher = new SourceSearcher(project);
            Iterator<BugInstance> i$2 = origCollection.getCollection().iterator();
            while (i$2.hasNext()) {
                BugInstance bug = i$2.next();
                SourceLineAnnotation src = bug.getPrimarySourceLineAnnotation();
                if (SetBugDatabaseInfo.sourceSearcher.sourceNotFound.contains(src.getClassName()) || sourceSearcher.findSource(src)) continue;
                HashSet<String> paths = (HashSet<String>)missingFiles.get(src.getSourceFile());
                if (paths == null) {
                    paths = new HashSet<String>();
                    missingFiles.put(src.getSourceFile(), paths);
                }
                String fullPath = SetBugDatabaseInfo.fullPath(src);
                paths.add(fullPath);
            }
            HashSet<String> foundPaths = new HashSet<String>();
            Iterator<String> i$3 = commandLine.searchSourcePaths.iterator();
            while (i$3.hasNext()) {
                String f = i$3.next();
                Iterator<File> i$4 = RecursiveSearchForJavaFiles.search(new File(f)).iterator();
                while (i$4.hasNext()) {
                    File javaFile = i$4.next();
                    Set matchingMissingClasses = (Set)missingFiles.get(javaFile.getName());
                    if (matchingMissingClasses == null) continue;
                    Iterator i$5 = matchingMissingClasses.iterator();
                    while (i$5.hasNext()) {
                        String dir;
                        String sourcePath = (String)i$5.next();
                        String path = javaFile.getAbsolutePath();
                        if (!path.endsWith(sourcePath) || !foundPaths.add(dir = path.substring(0, path.length() - sourcePath.length()))) continue;
                        project.addSourceDir(dir);
                        if (argCount >= args.length) continue;
                        System.out.println("Found " + dir);
                    }
                }
            }
        }
        if (argCount < args.length) {
            origCollection.writeXML(args[argCount++], project);
        } else {
            origCollection.writeXML(System.out, project);
        }
    }

    static String fullPath(SourceLineAnnotation src) {
        return src.getPackageName().replace('.', File.separatorChar) + File.separatorChar + src.getSourceFile();
    }

    static class SetInfoCommandLine
    extends CommandLine {
        String revisionName;
        long revisionTimestamp = 0L;
        public List<String> sourcePaths = new LinkedList<String>();
        public List<String> searchSourcePaths = new LinkedList<String>();

        SetInfoCommandLine() {
            this.addOption("-name", "name", "set name for (last) revision");
            this.addOption("-timestamp", "when", "set timestamp for (last) revision");
            this.addOption("-source", "directory", "Add this directory to the source search path");
            this.addOption("-findSource", "directory", "Find and add all relevant source directions contained within this directory");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("no option " + option);
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-name")) {
                this.revisionName = argument;
            } else if (option.equals("-timestamp")) {
                this.revisionTimestamp = Date.parse(argument);
            } else if (option.equals("-source")) {
                this.sourcePaths.add(argument);
            } else if (option.equals("-findSource")) {
                this.searchSourcePaths.add(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

