/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FuzzyBugComparator;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SloppyBugComparator;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.VersionInsensitiveBugComparator;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.model.MovedClassMap;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BugHistory {
    private static final boolean DEBUG = false;
    public static final SetOperation ADDED_WARNINGS = new SetOperation(){

        @Override
        public SortedBugCollection perform(Set<BugInstance> result, SortedBugCollection origCollection, SortedBugCollection newCollection) {
            result.addAll(newCollection.getCollection());
            List inBoth = BugHistory.getSharedInstances(result, origCollection);
            BugHistory.removeBugInstances(result, inBoth);
            return newCollection;
        }
    };
    public static final SetOperation RETAINED_WARNINGS = new SetOperation(){

        @Override
        public SortedBugCollection perform(Set<BugInstance> result, SortedBugCollection origCollection, SortedBugCollection newCollection) {
            result.addAll(newCollection.getCollection());
            List inBoth = BugHistory.getSharedInstances(result, origCollection);
            BugHistory.replaceBugInstances(result, inBoth);
            return newCollection;
        }
    };
    public static final SetOperation REMOVED_WARNINGS = new SetOperation(){

        @Override
        public SortedBugCollection perform(Set<BugInstance> result, SortedBugCollection origCollection, SortedBugCollection newCollection) {
            result.addAll(origCollection.getCollection());
            List inBoth = BugHistory.getSharedInstances(result, newCollection);
            BugHistory.removeBugInstances(result, inBoth);
            return origCollection;
        }
    };
    private SortedBugCollection origCollection;
    private SortedBugCollection newCollection;
    private SortedBugCollection resultCollection;
    private SortedBugCollection originator;
    private WarningComparator comparator;
    private static final int VERSION_INSENSITIVE_COMPARATOR = 0;
    private static final int FUZZY_COMPARATOR = 1;
    private static final int SLOPPY_COMPARATOR = 2;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$workflow$BugHistory;

    public BugHistory(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        this.origCollection = origCollection;
        this.newCollection = newCollection;
    }

    public WarningComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(WarningComparator comparator) {
        this.comparator = comparator;
    }

    public SortedBugCollection performSetOperation(SetOperation operation) {
        TreeSet<BugInstance> result = new TreeSet<BugInstance>(this.getComparator());
        this.originator = operation.perform(result, this.origCollection, this.newCollection);
        LinkedList<BugInstance> selected = new LinkedList<BugInstance>();
        SortedBugCollection.cloneAll(selected, result);
        SortedBugCollection resultCollection = this.originator.duplicate();
        resultCollection.clearBugInstances();
        resultCollection.addAll(selected);
        this.resultCollection = resultCollection;
        return resultCollection;
    }

    public SortedBugCollection getOriginator() {
        return this.originator;
    }

    public SortedBugCollection getOrigCollection() {
        return this.origCollection;
    }

    public SortedBugCollection getNewCollection() {
        return this.newCollection;
    }

    public SortedBugCollection getResultCollection() {
        return this.resultCollection;
    }

    public void writeResultCollection(Project origProject, Project newProject, OutputStream outputStream) throws IOException {
        this.getResultCollection().writeXML(outputStream, this.getOriginator() == this.getOrigCollection() ? origProject : newProject);
    }

    private static List<BugInstance> getSharedInstances(Set<BugInstance> result, SortedBugCollection collection) {
        LinkedList<BugInstance> inBoth = new LinkedList<BugInstance>();
        Iterator<BugInstance> i = collection.iterator();
        while (i.hasNext()) {
            BugInstance origBugInstance = i.next();
            if (!result.contains(origBugInstance)) continue;
            inBoth.add(origBugInstance);
        }
        return inBoth;
    }

    private static void replaceBugInstances(Set<BugInstance> dest, Collection<BugInstance> source) {
        dest.clear();
        dest.addAll(source);
    }

    private static void removeBugInstances(Set<BugInstance> result, Collection<BugInstance> toRemove) {
        for (BugInstance aToRemove : toRemove) {
            result.remove(aToRemove);
        }
    }

    private static SortedBugCollection readCollection(String fileName, Project project) throws IOException, DocumentException {
        SortedBugCollection result = new SortedBugCollection();
        result.readXML(fileName, project);
        return result;
    }

    public static void main(String[] argv) throws Exception {
        BugHistoryCommandLine commandLine = new BugHistoryCommandLine();
        int argCount = commandLine.parse(argv);
        if (commandLine.getSetOp() == null) {
            System.err.println("No set operation specified");
            BugHistory.printUsage();
            System.exit(1);
        }
        if (commandLine.getListFile() != null) {
            if (argv.length != argCount) {
                BugHistory.printUsage();
            }
            BugHistory.runBulk(commandLine);
        } else {
            if (argv.length - argCount != 2) {
                BugHistory.printUsage();
            }
            String origFile = argv[argCount++];
            String newFile = argv[argCount++];
            BugHistory.runSinglePair(commandLine, origFile, newFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBulk(BugHistoryCommandLine commandLine) throws FileNotFoundException, IOException, DocumentException {
        BufferedReader reader = commandLine.getListFile().equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(commandLine.getListFile()));
        int missing = 0;
        try {
            String csvRecord;
            BugCollectionAndProjectCache cache = new BugCollectionAndProjectCache();
            while ((csvRecord = reader.readLine()) != null) {
                BugCollectionAndProject next;
                BugCollectionAndProject orig;
                String[] tuple = (csvRecord = csvRecord.trim()).split(",");
                if (tuple.length < 2) continue;
                String origFile = tuple[0];
                String newFile = tuple[1];
                try {
                    orig = cache.fetch(origFile);
                    next = cache.fetch(newFile);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    System.err.println(new StringBuffer().append("Warning: error reading bug collection: ").append(e.toString()).toString());
                    ++missing;
                    continue;
                }
                if (commandLine.isVerbose()) {
                    System.out.print(new StringBuffer().append("Computing delta from ").append(origFile).append(" to ").append(newFile).append("...").toString());
                    System.out.flush();
                }
                BugHistory bugHistory = commandLine.createAndExecute(orig.getBugCollection(), next.getBugCollection(), orig.getProject(), next.getProject());
                String outputFile = commandLine.getBulkOutputFileName(newFile);
                if (commandLine.isVerbose()) {
                    System.out.print(new StringBuffer().append("Writing ").append(outputFile).append("...").toString());
                    System.out.flush();
                }
                bugHistory.writeResultCollection(orig.getProject(), next.getProject(), new BufferedOutputStream(new FileOutputStream(outputFile)));
                if (!commandLine.isVerbose()) continue;
                System.out.println("done");
            }
        }
        finally {
            reader.close();
        }
        if (missing > 0) {
            System.err.println(new StringBuffer().append(missing).append(" pairs skipped because of missing files").toString());
        }
    }

    private static void runSinglePair(BugHistoryCommandLine commandLine, String origFile, String newFile) throws IOException, DocumentException {
        Project origProject = new Project();
        Project newProject = new Project();
        BugHistory bugHistory = commandLine.createAndExecute(origFile, newFile, origProject, newProject);
        if (commandLine.isCount()) {
            System.out.println(bugHistory.getResultCollection().getCollection().size());
        } else {
            PrintStream outputStream = System.out;
            bugHistory.writeResultCollection(origProject, newProject, outputStream);
        }
    }

    private static void printUsage() {
        System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$workflow$BugHistory == null ? (class$edu$umd$cs$findbugs$workflow$BugHistory = BugHistory.class$("edu.umd.cs.findbugs.workflow.BugHistory")) : class$edu$umd$cs$findbugs$workflow$BugHistory).getName()).append(" [options] <operation> <old results> <new results>").toString());
        new BugHistoryCommandLine().printUsage(System.err);
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private static class BugHistoryCommandLine
    extends CommandLine {
        private int comparatorType = 0;
        private boolean count;
        private String opName;
        private SetOperation setOp;
        private String listFile;
        private String outputDir;
        private boolean verbose;

        public BugHistoryCommandLine() {
            this.addSwitch("-fuzzy", "use fuzzy warning matching");
            this.addSwitch("-sloppy", "use sloppy warning matching");
            this.addSwitch("-added", "compute added warnings");
            this.addSwitch("-new", "same as \"-added\" switch");
            this.addSwitch("-removed", "compute removed warnings");
            this.addSwitch("-fixed", "same as \"-removed\" switch");
            this.addSwitch("-retained", "compute retained warnings");
            this.addSwitch("-count", "just print warning count");
            this.addOption("-bulk", "file of csv xml file pairs", "bulk mode, output written to v2-OP.xml");
            this.addOption("-outputDir", "output dir", "output directory for bulk mode (optional)");
            this.addSwitch("-verbose", "verbose output for bulk mode");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-fuzzy")) {
                this.comparatorType = 1;
            } else if (option.equals("-sloppy")) {
                this.comparatorType = 2;
            } else if (option.equals("-added") || option.equals("-new")) {
                this.opName = option;
                this.setOp = ADDED_WARNINGS;
            } else if (option.equals("-removed") || option.equals("-fixed")) {
                this.opName = option;
                this.setOp = REMOVED_WARNINGS;
            } else if (option.equals("-retained")) {
                this.opName = option;
                this.setOp = RETAINED_WARNINGS;
            } else if (option.equals("-count")) {
                this.count = true;
            } else if (option.equals("-verbose")) {
                this.verbose = true;
            } else {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-bulk")) {
                this.listFile = argument;
            } else if (option.equals("-outputDir")) {
                this.outputDir = argument;
            } else {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
        }

        public int getComparatorType() {
            return this.comparatorType;
        }

        public boolean isCount() {
            return this.count;
        }

        public String getOpName() {
            return this.opName;
        }

        public SetOperation getSetOp() {
            return this.setOp;
        }

        public String getListFile() {
            return this.listFile;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void configure(BugHistory bugHistory, SortedBugCollection origCollection, SortedBugCollection newCollection) {
            WarningComparator comparator;
            switch (this.getComparatorType()) {
                case 0: {
                    comparator = new VersionInsensitiveBugComparator();
                    break;
                }
                case 1: {
                    FuzzyBugComparator fuzzy = new FuzzyBugComparator();
                    fuzzy.registerBugCollection(origCollection);
                    fuzzy.registerBugCollection(newCollection);
                    comparator = fuzzy;
                    break;
                }
                case 2: {
                    comparator = new SloppyBugComparator();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            MovedClassMap classNameRewriter = new MovedClassMap(origCollection, newCollection).execute();
            comparator.setClassNameRewriter(classNameRewriter);
            bugHistory.setComparator(comparator);
        }

        public BugHistory createAndExecute(String origFile, String newFile, Project origProject, Project newProject) throws IOException, DocumentException {
            SortedBugCollection origCollection = BugHistory.readCollection(origFile, origProject);
            SortedBugCollection newCollection = BugHistory.readCollection(newFile, newProject);
            return this.createAndExecute(origCollection, newCollection, origProject, newProject);
        }

        public BugHistory createAndExecute(SortedBugCollection origCollection, SortedBugCollection newCollection, Project origProject, Project newProject) {
            BugHistory bugHistory = new BugHistory(origCollection, newCollection);
            this.configure(bugHistory, origCollection, newCollection);
            bugHistory.performSetOperation(this.getSetOp());
            return bugHistory;
        }

        public String getBulkOutputFileName(String fileName) {
            File file = new File(fileName);
            String filePart = file.getName();
            int ext = filePart.lastIndexOf(46);
            filePart = ext < 0 ? filePart + this.getOpName() : filePart.substring(0, ext) + this.getOpName() + filePart.substring(ext);
            String dirPart = this.getOutputDir() != null ? this.getOutputDir() : file.getParent();
            File outputFile = new File(dirPart, filePart);
            return outputFile.getPath();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetOperation {
        public SortedBugCollection perform(Set<BugInstance> var1, SortedBugCollection var2, SortedBugCollection var3);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugCollectionAndProjectCache
    extends LinkedHashMap<String, BugCollectionAndProject> {
        private static final long serialVersionUID = 1L;
        private static final int CACHE_SIZE = 5;

        private BugCollectionAndProjectCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BugCollectionAndProject> eldest) {
            return this.size() > 5;
        }

        public BugCollectionAndProject fetch(String fileName) throws IOException, DocumentException {
            BugCollectionAndProject result = (BugCollectionAndProject)this.get(fileName);
            if (result == null) {
                Project project = new Project();
                SortedBugCollection bugCollection = BugHistory.readCollection(fileName, project);
                result = new BugCollectionAndProject(bugCollection, project);
                this.put(fileName, result);
            }
            return result;
        }
    }

    private static class BugCollectionAndProject {
        SortedBugCollection bugCollection;
        Project project;

        public BugCollectionAndProject(SortedBugCollection bugCollection, Project project) {
            this.bugCollection = bugCollection;
            this.project = project;
        }

        public SortedBugCollection getBugCollection() {
            return this.bugCollection;
        }

        public Project getProject() {
            return this.project;
        }
    }
}

