/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.TreeSet;

public class PrettyPrinter {
    private static UnicodeSet patternWhitespace = new UnicodeSet("[[:Cn:][:Default_Ignorable_Code_Point:][:patternwhitespace:]]");
    private boolean first = true;
    private StringBuffer target = new StringBuffer();
    private int firstCodePoint = -2;
    private int lastCodePoint = -2;
    private boolean compressRanges = true;
    private String lastString = "";
    private UnicodeSet toQuote = new UnicodeSet(patternWhitespace);
    private Transliterator quoter = null;
    private Comparator ordering;
    private Comparator spaceComp = Collator.getInstance(ULocale.ROOT);

    public PrettyPrinter() {
        this.setOrdering(Collator.getInstance(ULocale.ROOT));
        ((RuleBasedCollator)this.spaceComp).setStrength(0);
    }

    public Transliterator getQuoter() {
        return this.quoter;
    }

    public PrettyPrinter setQuoter(Transliterator quoter) {
        this.quoter = quoter;
        return this;
    }

    public boolean isCompressRanges() {
        return this.compressRanges;
    }

    public PrettyPrinter setCompressRanges(boolean compressRanges) {
        this.compressRanges = compressRanges;
        return this;
    }

    public Comparator getOrdering() {
        return this.ordering;
    }

    public PrettyPrinter setOrdering(Comparator ordering) {
        this.ordering = new CollectionUtilities.MultiComparator(new Comparator[]{ordering, new UTF16.StringComparator(true, false, 0)});
        return this;
    }

    public Comparator getSpaceComparator() {
        return this.spaceComp;
    }

    public PrettyPrinter setSpaceComparator(Comparator spaceComp) {
        this.spaceComp = spaceComp;
        return this;
    }

    public UnicodeSet getToQuote() {
        return this.toQuote;
    }

    public PrettyPrinter setToQuote(UnicodeSet toQuote) {
        toQuote = (UnicodeSet)toQuote.clone();
        toQuote.addAll(patternWhitespace);
        this.toQuote = toQuote;
        return this;
    }

    public String toPattern(UnicodeSet uset) {
        this.first = true;
        TreeSet<String> orderedStrings = new TreeSet<String>(this.ordering);
        Object it = new UnicodeSetIterator(uset);
        while (((UnicodeSetIterator)it).next()) {
            orderedStrings.add(((UnicodeSetIterator)it).getString());
        }
        this.target.setLength(0);
        this.target.append("[");
        it = orderedStrings.iterator();
        while (it.hasNext()) {
            this.appendUnicodeSetItem((String)it.next());
        }
        this.flushLast();
        this.target.append("]");
        String sresult = this.target.toString();
        UnicodeSet doubleCheck = new UnicodeSet(sresult);
        if (!uset.equals(doubleCheck)) {
            throw new InternalError("Failure to round-trip in pretty-print");
        }
        return sresult;
    }

    PrettyPrinter appendUnicodeSetItem(String s) {
        if (UTF16.hasMoreCodePointsThan(s, 1)) {
            this.flushLast();
            this.addSpace(s);
            this.target.append("{");
            int i = 0;
            while (i < s.length()) {
                int cp = UTF16.charAt(s, i);
                this.appendQuoted(cp);
                i += UTF16.getCharCount(cp);
            }
            this.target.append("}");
            this.lastString = s;
        } else {
            int cp;
            if (!this.compressRanges) {
                this.flushLast();
            }
            if ((cp = UTF16.charAt(s, 0)) == this.lastCodePoint + 1) {
                this.lastCodePoint = cp;
            } else {
                this.flushLast();
                this.firstCodePoint = this.lastCodePoint = cp;
            }
        }
        return this;
    }

    private void addSpace(String s) {
        if (this.first) {
            this.first = false;
        } else if (this.spaceComp.compare(s, this.lastString) != 0) {
            this.target.append(' ');
        } else {
            int type = UCharacter.getType(UTF16.charAt(s, 0));
            if (type == 6 || type == 7) {
                this.target.append(' ');
            }
        }
    }

    private void flushLast() {
        if (this.lastCodePoint >= 0) {
            this.addSpace(UTF16.valueOf(this.firstCodePoint));
            if (this.firstCodePoint != this.lastCodePoint) {
                this.appendQuoted(this.firstCodePoint);
                this.target.append(this.firstCodePoint + 1 == this.lastCodePoint ? (char)' ' : '-');
            }
            this.appendQuoted(this.lastCodePoint);
            this.lastString = UTF16.valueOf(this.lastCodePoint);
            this.lastCodePoint = -2;
            this.firstCodePoint = -2;
        }
    }

    PrettyPrinter appendQuoted(int codePoint) {
        if (this.toQuote.contains(codePoint)) {
            if (this.quoter != null) {
                this.target.append(this.quoter.transliterate(UTF16.valueOf(codePoint)));
                return this;
            }
            if (codePoint > 65535) {
                this.target.append("\\U");
                this.target.append(Utility.hex(codePoint, 8));
            } else {
                this.target.append("\\u");
                this.target.append(Utility.hex(codePoint, 4));
            }
            return this;
        }
        switch (codePoint) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                this.target.append('\\');
                break;
            }
            default: {
                if (!patternWhitespace.contains(codePoint)) break;
                this.target.append('\\');
            }
        }
        UTF16.append(this.target, codePoint);
        return this;
    }
}

